/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.repl;

import java.io.IOException;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DumpDirCleanerTask
extends TimerTask {
    public static final Logger LOG = LoggerFactory.getLogger(DumpDirCleanerTask.class);
    private final HiveConf conf;
    private final Path dumpRoot;
    private final long ttl;

    public DumpDirCleanerTask(HiveConf conf) {
        this.conf = conf;
        this.dumpRoot = new Path(conf.getVar(HiveConf.ConfVars.REPLDIR));
        this.ttl = conf.getTimeVar(HiveConf.ConfVars.REPL_DUMPDIR_TTL, TimeUnit.MILLISECONDS);
    }

    @Override
    public void run() {
        LOG.debug("Trying to delete old dump dirs");
        try {
            FileStatus[] statuses;
            FileSystem fs = FileSystem.get(this.dumpRoot.toUri(), this.conf);
            for (FileStatus status : statuses = fs.listStatus(this.dumpRoot)) {
                if (status.getModificationTime() >= System.currentTimeMillis() - this.ttl) continue;
                fs.delete(status.getPath(), true);
                LOG.info("Deleted old dump dir: " + status.getPath());
            }
        }
        catch (IOException e) {
            LOG.error("Error while trying to delete dump dir", e);
        }
    }
}

