/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc.importExport;

import com.exasol.jdbc.Translator;
import com.exasol.jdbc.importExport.HTTPThread;
import com.exasol.jdbc.importExport.KeyManager;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.sql.SQLException;
import java.util.HashMap;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class HttpPush {
    private Socket sock = null;
    private HashMap hd = new HashMap();
    private String commandstring;
    private String urlstring;
    private String[] fileNames;
    private DataOutputStream out = null;
    private DataInputStream in = null;
    private String remotehost = "";
    private String cookie = "";
    private int remoteport = 0;
    private boolean secure = false;
    HTTPThread caller = null;

    private static final int swabInt(int n) {
        return n >>> 24 | n << 24 | n << 8 & 0xFF0000 | n >> 8 & 0xFF00;
    }

    public HttpPush(Socket socket, String[] stringArray, String string, boolean bl, boolean bl2) throws IOException, SQLException {
        this.fileNames = stringArray;
        this.sock = socket;
        this.cookie = string;
        this.secure = bl;
        this.in = new DataInputStream(new BufferedInputStream(this.sock.getInputStream()));
        this.out = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
        if (bl2) {
            this.out.writeInt(0x2212102);
            this.out.writeInt(HttpPush.swabInt(1));
            this.out.writeInt(HttpPush.swabInt(1));
            this.out.flush();
            if (HttpPush.swabInt(this.in.readInt()) != 1) {
                throw new SQLException(Translator.WrongProtocolNumber(), "04507");
            }
            this.remoteport = HttpPush.swabInt(this.in.readInt());
            byte[] byArray = new byte[16];
            this.in.readFully(byArray);
            this.remotehost = new String(byArray, 0, 15).trim();
        }
    }

    public void connect(HTTPThread hTTPThread) throws IOException, InterruptedException {
        int n;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.caller = hTTPThread;
        if (this.caller.ThreadWasInterrupted()) {
            this.close();
            throw new InterruptedException("HTTPThread canceled.");
        }
        if (this.secure) {
            try {
                object4 = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                ((TrustManagerFactory)object4).init((KeyStore)null);
                object3 = SSLContext.getInstance("SSL");
                object2 = new KeyManager();
                ((SSLContext)object3).init(((KeyManager)object2).getKeyManager().getKeyManagers(), ((TrustManagerFactory)object4).getTrustManagers(), null);
                object = ((SSLContext)object3).getSocketFactory();
                if (this.caller.ThreadWasInterrupted()) {
                    this.close();
                    throw new InterruptedException("HTTPS Thread canceled.");
                }
                SSLSocket sSLSocket = (SSLSocket)((SSLSocketFactory)object).createSocket(this.sock, this.remotehost, this.remoteport, true);
                sSLSocket.setUseClientMode(false);
                sSLSocket.setEnableSessionCreation(true);
                sSLSocket.setNeedClientAuth(false);
                sSLSocket.setWantClientAuth(false);
                if (this.caller.ThreadWasInterrupted()) {
                    sSLSocket.close();
                    this.close();
                    throw new InterruptedException("HTTPS Thread canceled.");
                }
                sSLSocket.startHandshake();
                this.sock = sSLSocket;
                this.in = new DataInputStream(new BufferedInputStream(this.sock.getInputStream()));
                this.out = new DataOutputStream(new BufferedOutputStream(this.sock.getOutputStream()));
            }
            catch (Throwable throwable) {
                throw new IOException(throwable.getMessage());
            }
        }
        object4 = new ByteArrayOutputStream();
        object3 = new ByteArrayOutputStream();
        object2 = new ByteArrayOutputStream();
        object = new ByteArrayOutputStream();
        this.caller.NowConnected();
        String string = "";
        String string2 = "";
        int n2 = 0;
        while (this.in.available() == 0 && n2 == 3 || this.caller.ThreadWasInterrupted()) {
            if (!this.caller.ThreadWasInterrupted()) continue;
            this.close();
            throw new InterruptedException("HTTP Thread canceled.");
        }
        while (n2 != 3 && !this.caller.ThreadWasInterrupted() && (n = this.in.read()) != -1) {
            switch (n2) {
                case 0: {
                    if (n == 32) {
                        ((ByteArrayOutputStream)object4).close();
                        n2 = 1;
                        break;
                    }
                    if (n == 10) {
                        ((ByteArrayOutputStream)object4).close();
                        n2 = 4;
                        break;
                    }
                    ((ByteArrayOutputStream)object4).write(n);
                    break;
                }
                case 1: {
                    if (n == 32) {
                        ((ByteArrayOutputStream)object3).close();
                        n2 = 2;
                        break;
                    }
                    if (n == 10) {
                        ((ByteArrayOutputStream)object3).close();
                        n2 = 4;
                        break;
                    }
                    ((ByteArrayOutputStream)object3).write(n);
                    break;
                }
                case 2: {
                    if (n != 10) break;
                    n2 = 4;
                    break;
                }
                case 4: {
                    if (n == 10) {
                        n2 = 3;
                        break;
                    }
                    if ("\r ".indexOf(n) >= 0) break;
                    if (n == 58) {
                        ((ByteArrayOutputStream)object).close();
                        string = ((ByteArrayOutputStream)object).toString();
                        object = new ByteArrayOutputStream();
                        n2 = 5;
                        break;
                    }
                    ((ByteArrayOutputStream)object).write(n);
                    break;
                }
                case 5: {
                    if ("\n".indexOf(n) >= 0) {
                        n2 = 6;
                        break;
                    }
                    if ("\r".indexOf(n) >= 0) break;
                    ((ByteArrayOutputStream)object).write(n);
                    break;
                }
                case 6: {
                    if (" ".indexOf(n) >= 0) {
                        n2 = 5;
                        break;
                    }
                    ((ByteArrayOutputStream)object).close();
                    string2 = ((ByteArrayOutputStream)object).toString();
                    if (string == null) {
                        throw new IOException("internal error");
                    }
                    this.hd.put(string, string2);
                    if (n == 10) {
                        n2 = 3;
                        break;
                    }
                    object = new ByteArrayOutputStream();
                    ((ByteArrayOutputStream)object).write(n);
                    n2 = 4;
                }
            }
        }
        this.commandstring = ((ByteArrayOutputStream)object4).toString();
        this.urlstring = ((ByteArrayOutputStream)object3).toString();
    }

    public String getRemoteHost() {
        return this.remotehost;
    }

    public int getRemotePort() {
        return this.remoteport;
    }

    public HashMap getHeader() {
        return this.hd;
    }

    public String getCommand() {
        return this.commandstring;
    }

    public String getURL() {
        return this.urlstring;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void push(PushFileInterface pushFileInterface) throws IOException {
        try {
            this.out.write("HTTP/1.1 200 OK\r\n".getBytes());
            this.out.write("Server: EXALoader\r\n".getBytes());
            this.out.write("Content-type: application/octet-stream\r\n".getBytes());
            this.out.write("Content-disposition: attachment; filename=".getBytes());
            for (int i = 0; i < this.fileNames.length; ++i) {
                this.out.write(this.fileNames[i].getBytes());
                if (i >= this.fileNames.length - 1) continue;
                this.out.write(" ,".getBytes());
            }
            this.out.write("\r\nConnection: close\r\n\r\n".getBytes());
            this.out.flush();
            byte[] byArray = pushFileInterface.getBuffer();
            while (pushFileInterface.hasMoreElements()) {
                int n = pushFileInterface.nextElement();
                this.out.write(byArray, 0, n);
            }
            this.out.flush();
        }
        finally {
            this.close();
            pushFileInterface.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushFileNotFound(String string) throws IOException {
        try {
            this.out.write("HTTP/1.1 404 Not found\r\n\r\n".getBytes());
            this.out.flush();
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushPermissionDenied(String string) throws IOException {
        try {
            this.out.write("HTTP/1.1 401 Unauthorized\r\n\r\n".getBytes());
            this.out.flush();
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pull(PullFileInterface pullFileInterface) throws IOException {
        try {
            this.out.write("HTTP/1.1 100 OK\r\n".getBytes());
            this.out.write("Server: EXALoader\r\n\r\n".getBytes());
            this.out.flush();
            try {
                String string;
                int n;
                while ((n = Integer.parseInt(string = this.in.readLine(), 16)) != 0) {
                    byte[] byArray = new byte[n + 2];
                    this.in.readFully(byArray, 0, n + 2);
                    pullFileInterface.putBuffer(byArray, n);
                }
            }
            finally {
                pullFileInterface.close();
            }
            this.out.write("HTTP/1.1 200 OK\r\n".getBytes());
            this.out.write("Server: EXALoader\r\n".getBytes());
            this.out.write("Connection: close\r\n\r\n".getBytes());
        }
        finally {
            this.out.flush();
            this.close();
        }
    }

    public void close() throws IOException {
        this.out.close();
        this.sock.close();
        if (null != this.caller) {
            this.caller.NowDisconnected();
        }
    }

    public static interface PullFileInterface {
        public void putBuffer(byte[] var1, int var2) throws IOException;

        public void close() throws IOException;
    }

    public static interface PushFileInterface {
        public byte[] getBuffer();

        public boolean hasMoreElements() throws IOException;

        public int nextElement() throws IOException;

        public void close() throws IOException;
    }

    public static class ServerState {
        static final int COMMAND = 0;
        static final int URL = 1;
        static final int VERSION = 2;
        static final int EOF = 3;
        static final int KEY = 4;
        static final int VALUE = 5;
        static final int NEWLINE = 6;
    }
}

