/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import java.util.ResourceBundle;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.core.DBeaverActivator;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomTableEditor;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.utils.CommonUtils;

public class PrefPageConfirmations
extends AbstractPrefPage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.main.confirmations";
    private Table confirmTable;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        ResourceBundle coreBundle = DBeaverActivator.getCoreResourceBundle();
        ResourceBundle rsvBundle = ResourceBundle.getBundle("org.jkiss.dbeaver.ui.controls.resultset.internal.ResultSetMessages");
        ResourceBundle navigatorBundle = ResourceBundle.getBundle("org.jkiss.dbeaver.ui.internal.UINavigatorMessages");
        ResourceBundle sqlBundle = ResourceBundle.getBundle("org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages");
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        this.confirmTable = new Table(composite, 67584);
        this.confirmTable.setLayoutData((Object)new GridData(1808));
        this.confirmTable.setHeaderVisible(true);
        this.confirmTable.setLinesVisible(true);
        UIUtils.createTableColumn((Table)this.confirmTable, (int)16384, (String)CoreMessages.pref_page_confirmations_table_column_confirmation);
        UIUtils.createTableColumn((Table)this.confirmTable, (int)16384, (String)CoreMessages.pref_page_confirmations_table_column_group);
        UIUtils.createTableColumn((Table)this.confirmTable, (int)131072, (String)CoreMessages.pref_page_confirmations_table_column_value);
        new CustomTableEditor(this.confirmTable){
            {
                this.firstTraverseIndex = 2;
                this.lastTraverseIndex = 2;
                this.editOnEnter = false;
            }

            @Nullable
            protected Control createEditor(Table table, int index, TableItem item) {
                if (index != 2) {
                    return null;
                }
                CCombo editor = new CCombo((Composite)table, 12);
                editor.setItems(new String[]{CoreMessages.pref_page_confirmations_combo_always, CoreMessages.pref_page_confirmations_combo_never, CoreMessages.pref_page_confirmations_combo_prompt});
                editor.setText(item.getText(2));
                return editor;
            }

            protected void saveEditorValue(Control control, int index, TableItem item) {
                item.setText(2, ((CCombo)control).getText());
            }
        };
        this.createConfirmItem(CoreMessages.pref_page_confirmations_group_general_actions, coreBundle, "exit");
        this.createConfirmItem(CoreMessages.pref_page_confirmations_group_general_actions, rsvBundle, "order_resultset");
        this.createConfirmItem(CoreMessages.pref_page_confirmations_group_general_actions, rsvBundle, "fetch_all_rows");
        this.createConfirmItem(CoreMessages.pref_page_confirmations_group_general_actions, coreBundle, "disconnect_txn");
        this.createConfirmItem(CoreMessages.pref_page_confirmations_group_general_actions, coreBundle, "driver_download");
        this.createConfirmItem(CoreMessages.pref_page_confirmations_group_general_actions, coreBundle, "version_check");
        this.createConfirmItem(CoreMessages.pref_page_confirmations_group_object_editor, navigatorBundle, "entity_delete");
        this.createConfirmItem(CoreMessages.pref_page_confirmations_group_object_editor, navigatorBundle, "entity_reject");
        this.createConfirmItem(CoreMessages.pref_page_confirmations_group_object_editor, navigatorBundle, "entity_revert");
        this.createConfirmItem(CoreMessages.pref_page_confirmations_group_object_editor, rsvBundle, "keep_statement_open");
        this.createConfirmItem(CoreMessages.pref_page_confirmations_group_object_editor, sqlBundle, "dangerous_sql");
        this.createConfirmItem(CoreMessages.pref_page_confirmations_group_object_editor, sqlBundle, "mass_parallel_sql");
        this.createConfirmItem(CoreMessages.pref_page_confirmations_group_object_editor, sqlBundle, "close_running_query");
        this.createConfirmItem(CoreMessages.pref_page_confirmations_group_object_editor, sqlBundle, "close_result_tabs");
        UIUtils.asyncExec(() -> UIUtils.packColumns((Table)this.confirmTable, (boolean)true));
        return composite;
    }

    private void createConfirmItem(String group, ResourceBundle bundle, String id) {
        String labelKey = ConfirmationDialog.getResourceKey((String)id, (String)"title");
        String title = bundle.getString(labelKey);
        TableItem item = new TableItem(this.confirmTable, 0);
        item.setData("id", (Object)id);
        item.setData("bundle", (Object)bundle);
        item.setText(0, title);
        item.setText(1, group);
        item.setText(2, this.getCurrentConfirmValue(id));
    }

    private String getCurrentConfirmValue(String id) {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        String value = store.getString("org.jkiss.dbeaver.core.confirm." + id);
        if (CommonUtils.isEmpty((String)value)) {
            value = "prompt";
        }
        switch (value) {
            case "always": {
                return CoreMessages.pref_page_confirmations_combo_always;
            }
            case "never": {
                return CoreMessages.pref_page_confirmations_combo_never;
            }
        }
        return CoreMessages.pref_page_confirmations_combo_prompt;
    }

    protected void performDefaults() {
        TableItem[] tableItemArray = this.confirmTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            String id = (String)item.getData("id");
            item.setText(2, this.getCurrentConfirmValue(id));
            ++n2;
        }
        super.performDefaults();
    }

    public boolean performOk() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        TableItem[] tableItemArray = this.confirmTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            String id = (String)item.getData("id");
            String title = item.getText(2);
            String value = title.equals(CoreMessages.pref_page_confirmations_combo_always) ? "always" : (title.equals(CoreMessages.pref_page_confirmations_combo_never) ? "never" : "prompt");
            store.setValue("org.jkiss.dbeaver.core.confirm." + id, value);
            ++n2;
        }
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
        return super.performOk();
    }
}

