/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.informix.model;

import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.model.DBPObjectStatistics;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;

public class InformixTable
extends GenericTable
implements DBPObjectStatistics {
    private long tabSize = -1L;

    public InformixTable(GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        super(container, tableName, tableType, dbResult);
    }

    public boolean hasStatistics() {
        return this.tabSize != -1L;
    }

    public long getStatObjectSize() {
        return this.tabSize;
    }

    void fetchStatistics(JDBCResultSet dbResult) throws SQLException {
        this.tabSize = dbResult.getLong("tabsize");
    }

    @Nullable
    public DBPPropertySource getStatProperties() {
        return null;
    }

    @NotNull
    public DBCStatistics truncateData(@NotNull DBCSession session, @NotNull DBCExecutionSource source) throws DBCException {
        DBCStatistics statistics = super.truncateData(session, source);
        DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)session.getExecutionContext());
        if (txnManager != null && txnManager.isSupportsTransactions() && !txnManager.isAutoCommit()) {
            txnManager.commit(session);
        }
        return statistics;
    }
}

