/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.erd.ui.part;

import java.util.List;
import org.eclipse.draw2dl.Border;
import org.eclipse.draw2dl.CompoundBorder;
import org.eclipse.draw2dl.Figure;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.LineBorder;
import org.eclipse.draw2dl.MarginBorder;
import org.eclipse.draw2dl.geometry.Rectangle;
import org.eclipse.gef3.EditPart;
import org.eclipse.gef3.NodeEditPart;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.jkiss.dbeaver.erd.model.ERDAssociation;
import org.jkiss.dbeaver.erd.model.ERDElement;
import org.jkiss.dbeaver.erd.ui.part.AssociationPart;
import org.jkiss.dbeaver.erd.ui.part.ICustomizablePart;
import org.jkiss.dbeaver.erd.ui.part.PropertyAwarePart;
import org.jkiss.dbeaver.ui.UIUtils;

public abstract class NodePart
extends PropertyAwarePart
implements NodeEditPart,
ICustomizablePart {
    private Rectangle bounds;

    public abstract ERDElement getElement();

    protected List<ERDAssociation> getModelSourceConnections() {
        return this.getElement().getAssociations();
    }

    protected List<ERDAssociation> getModelTargetConnections() {
        return this.getElement().getReferences();
    }

    public AssociationPart getConnectionPart(ERDAssociation rel, boolean source) {
        for (Object conn : source ? this.getSourceConnections() : this.getTargetConnections()) {
            if (!(conn instanceof AssociationPart) || ((AssociationPart)conn).getAssociation() != rel) continue;
            return (AssociationPart)conn;
        }
        return null;
    }

    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setBounds(Rectangle bounds) {
        this.modifyBounds(bounds);
    }

    public void modifyBounds(Rectangle bounds) {
        Rectangle oldBounds = this.bounds;
        if (!bounds.equals((Object)oldBounds)) {
            this.bounds = bounds;
            Figure entityFigure = (Figure)this.getFigure();
            this.getDiagramPart().setLayoutConstraint((EditPart)this, (IFigure)entityFigure, bounds);
        }
    }

    @Override
    public boolean getCustomTransparency() {
        IFigure figure = this.getFigure();
        return figure != null && !figure.isOpaque();
    }

    @Override
    public void setCustomTransparency(boolean transparency) {
        IFigure figure = this.getFigure();
        if (figure != null) {
            figure.setOpaque(!transparency);
        }
    }

    @Override
    public int getCustomBorderWidth() {
        IFigure figure = this.getFigure();
        if (figure != null) {
            Border border = figure.getBorder();
            if (border instanceof LineBorder) {
                return ((LineBorder)border).getWidth();
            }
            if (border instanceof CompoundBorder && ((CompoundBorder)border).getOuterBorder() instanceof LineBorder) {
                return ((LineBorder)((CompoundBorder)border).getOuterBorder()).getWidth();
            }
        }
        return 0;
    }

    @Override
    public void setCustomBorderWidth(int borderWidth) {
        IFigure figure = this.getFigure();
        if (figure != null) {
            figure.setBorder(this.createBorder(borderWidth));
        }
    }

    protected Border createBorder(int borderWidth) {
        Object newBorder = borderWidth == 0 ? new MarginBorder(5) : new CompoundBorder((Border)new LineBorder(UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.attributes.foreground"), borderWidth), (Border)new MarginBorder(5));
        return newBorder;
    }

    @Override
    public Color getCustomBackgroundColor() {
        IFigure figure = this.getFigure();
        return figure == null ? null : figure.getBackgroundColor();
    }

    @Override
    public void setCustomBackgroundColor(Color color) {
        IFigure figure = this.getFigure();
        if (figure != null) {
            figure.setBackgroundColor(color == null ? UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.notes.background") : color);
        }
    }

    @Override
    public Color getCustomForegroundColor() {
        IFigure figure = this.getFigure();
        return figure == null ? null : figure.getForegroundColor();
    }

    @Override
    public void setCustomForegroundColor(Color color) {
        IFigure figure = this.getFigure();
        if (figure != null) {
            figure.setForegroundColor(color == null ? UIUtils.getColorRegistry().get("org.jkiss.dbeaver.erd.diagram.notes.foreground") : color);
        }
    }

    @Override
    public Font getCustomFont() {
        IFigure figure = this.getFigure();
        return figure == null ? null : figure.getFont();
    }

    @Override
    public void setCustomFont(Font font) {
        IFigure figure = this.getFigure();
        if (figure != null) {
            figure.setFont(font);
        }
    }
}

