/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.registry;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.dbeaver.model.sql.registry.SQLDialectDescriptor;
import org.jkiss.utils.CommonUtils;

public class SQLDialectRegistry {
    static final String TAG_DIALECT = "dialect";
    private static SQLDialectRegistry instance = null;
    private final Map<String, SQLDialectDescriptor> dialects = new LinkedHashMap<String, SQLDialectDescriptor>();

    public static synchronized SQLDialectRegistry getInstance() {
        if (instance == null) {
            instance = new SQLDialectRegistry();
            instance.loadExtensions(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private SQLDialectRegistry() {
    }

    private void loadExtensions(IExtensionRegistry registry) {
        IConfigurationElement ext;
        IConfigurationElement[] extConfigs;
        IConfigurationElement[] iConfigurationElementArray = extConfigs = registry.getConfigurationElementsFor("org.jkiss.dbeaver.sqlDialect");
        int n = extConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            ext = iConfigurationElementArray[n2];
            if (TAG_DIALECT.equals(ext.getName())) {
                SQLDialectDescriptor dialectDescriptor = new SQLDialectDescriptor(ext);
                this.dialects.put(dialectDescriptor.getId(), dialectDescriptor);
            }
            ++n2;
        }
        iConfigurationElementArray = extConfigs;
        n = extConfigs.length;
        n2 = 0;
        while (n2 < n) {
            ext = iConfigurationElementArray[n2];
            if (TAG_DIALECT.equals(ext.getName())) {
                String dialectId = ext.getAttribute("id");
                String parentDialectId = ext.getAttribute("parent");
                if (!CommonUtils.isEmpty((String)dialectId) && !CommonUtils.isEmpty((String)parentDialectId)) {
                    SQLDialectDescriptor dialect = this.dialects.get(dialectId);
                    SQLDialectDescriptor parentDialect = this.dialects.get(parentDialectId);
                    if (dialect != null && parentDialect != null) {
                        dialect.setParentDialect(parentDialect);
                    }
                }
            }
            ++n2;
        }
    }

    public void dispose() {
        this.dialects.clear();
    }

    public List<SQLDialectDescriptor> getDialects() {
        return new ArrayList<SQLDialectDescriptor>(this.dialects.values());
    }

    public SQLDialectDescriptor getDialect(String id) {
        return this.dialects.get(id);
    }

    public List<SQLDialectDescriptor> getRootDialects() {
        ArrayList<SQLDialectDescriptor> roots = new ArrayList<SQLDialectDescriptor>();
        for (SQLDialectDescriptor dd : this.dialects.values()) {
            if (dd.getParentDialect() != null) continue;
            roots.add(dd);
        }
        return roots;
    }
}

