/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.ui.resultset.document;

import com.dbeaver.ee.runtime.ui.resultset.document.AbstractDocumentPresentation;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IFindReplaceTargetExtension;
import org.eclipse.jface.text.IFindReplaceTargetExtension3;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.jkiss.dbeaver.Log;

public class DocumentFindReplaceTarget
implements IFindReplaceTarget,
IFindReplaceTargetExtension,
IFindReplaceTargetExtension3 {
    private static final Log log = Log.getLog(DocumentFindReplaceTarget.class);
    private final AbstractDocumentPresentation documentPresentation;
    private Pattern searchPattern;
    private Color scopeHighlightColor;
    private boolean replaceAll;

    public DocumentFindReplaceTarget(AbstractDocumentPresentation documentPresentation) {
        this.documentPresentation = documentPresentation;
    }

    public boolean canPerformFind() {
        return true;
    }

    public int findAndSelect(int widgetOffset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord) {
        return this.findAndSelect(widgetOffset, findString, searchForward, caseSensitive, wholeWord, false);
    }

    public Point getSelection() {
        return this.documentPresentation.getTextSelection();
    }

    public String getSelectionText() {
        return this.documentPresentation.getSelectionText();
    }

    public boolean isEditable() {
        return !this.documentPresentation.getController().isReadOnly();
    }

    public void replaceSelection(String text) {
        this.replaceSelection(text, false);
    }

    public void beginSession() {
    }

    public void endSession() {
    }

    public IRegion getScope() {
        return null;
    }

    public void setScope(IRegion scope) {
    }

    public Point getLineSelection() {
        return this.getSelection();
    }

    public void setSelection(int offset, int length) {
        this.documentPresentation.setTextSelection(offset, length);
        this.documentPresentation.redraw();
    }

    public void setScopeHighlightColor(Color color) {
        this.scopeHighlightColor = color;
    }

    public void setReplaceAllMode(boolean replaceAll) {
        this.replaceAll = replaceAll;
    }

    public int findAndSelect(int offset, String findString, boolean searchForward, boolean caseSensitive, boolean wholeWord, boolean regExSearch) {
        Pattern findPattern;
        this.searchPattern = null;
        if (regExSearch) {
            try {
                findPattern = Pattern.compile(findString, caseSensitive ? 0 : 2);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                log.warn((Object)("Bad regex pattern: " + findString));
                return -1;
            }
        } else {
            findPattern = Pattern.compile(Pattern.quote(findString), caseSensitive ? 0 : 2);
        }
        if (offset == -1) {
            offset = 0;
        }
        return this.documentPresentation.findText(offset, searchForward, findPattern);
    }

    public void replaceSelection(String str, boolean regExReplace) {
    }
}

