/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.runtime.internal.ui.resultset.json;

import com.dbeaver.ee.runtime.internal.ui.resultset.ResultsetMessages;
import com.dbeaver.ee.runtime.internal.ui.resultset.json.JSONRenderer;
import com.dbeaver.ee.runtime.ui.resultset.document.AbstractDocumentPresentation;
import com.dbeaver.ee.runtime.ui.resultset.document.IDocumentFrame;
import com.dbeaver.ee.runtime.ui.resultset.document.IDocumentRenderer;
import java.util.HashMap;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.data.DBDDocument;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.editors.BinaryEditorInput;
import org.jkiss.dbeaver.ui.editors.json.JSONTextEditor;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class JSONPresentation
extends AbstractDocumentPresentation {
    @Override
    @NotNull
    protected IDocumentRenderer createRenderer(@NotNull IDocumentFrame frame) {
        return new JSONRenderer(frame);
    }

    @Override
    @NotNull
    protected IEditorInput createEditorInput(@NotNull DBDDocument document, boolean readOnly) {
        return new BinaryEditorInput("#document", this.convertDocumentToData(document), readOnly, GeneralUtils.UTF8_ENCODING);
    }

    @Override
    @NotNull
    protected IEditorPart createEditorPart() throws DBException {
        return new JSONTextEditor();
    }

    @Override
    @NotNull
    public DBDDocument createDocumentFromContent(@NotNull DBDContent content) {
        return null;
    }

    @Override
    @NotNull
    protected DBDDocument createNewDocument() throws DBException {
        DBDAttributeBinding currentAttribute = this.getController().getActivePresentation().getCurrentAttribute();
        if (currentAttribute == null) {
            throw new DBException(ResultsetMessages.JSONPresentation_e_no_attribute);
        }
        DBCExecutionContext executionContext = this.getController().getExecutionContext();
        if (executionContext == null) {
            throw new DBException(ResultsetMessages.JSONPresentation_e_no_context);
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (DBCSession session = executionContext.openSession((DBRProgressMonitor)new VoidProgressMonitor(), DBCExecutionPurpose.UTIL, ResultsetMessages.JSONPresentation_session_make_string);){
            Object value = currentAttribute.getValueHandler().getValueFromObject(session, (DBSTypedObject)currentAttribute, new HashMap(), false, false);
            if (value instanceof DBDDocument) {
                return (DBDDocument)value;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        String fqn = currentAttribute.getFullyQualifiedName(DBPEvaluationContext.UI);
        throw new DBException(NLS.bind((String)ResultsetMessages.JSONPresentation_e_attribute_fqn, (Object)fqn));
    }
}

