/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.snowflake.model;

import java.sql.ResultSet;
import java.util.Date;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.model.DBPObjectStatistics;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;

public class SnowflakeTable
extends GenericTable
implements DBPObjectStatistics {
    private long tableSize = -1L;
    private Date createTime;
    private Date lastAlter;
    private String clusteringKey;

    public SnowflakeTable(GenericStructContainer container, @Nullable String tableName, @Nullable String tableType, @Nullable JDBCResultSet dbResult) {
        super(container, tableName, tableType, dbResult);
        if (dbResult != null) {
            this.tableSize = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"BYTES");
            this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATED");
            this.lastAlter = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"LAST_ALTERED");
            this.clusteringKey = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"CLUSTERING_KEY");
        }
    }

    @Property(viewable=true, order=6)
    public Date getCreateTime() {
        return this.createTime;
    }

    @Property(viewable=true, order=7)
    public Date getLastAlter() {
        return this.lastAlter;
    }

    @Property(viewable=true, order=8)
    public String getClusteringKey() {
        return this.clusteringKey;
    }

    public boolean hasStatistics() {
        return this.tableSize != -1L;
    }

    public long getStatObjectSize() {
        return this.tableSize;
    }

    @Nullable
    public DBPPropertySource getStatProperties() {
        return null;
    }
}

