/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.util;

import com.ingres.gcf.util.Config;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class ConfigFile
implements Config {
    private Properties properties = null;
    private Config config = null;

    public ConfigFile(InputStream inputStream) throws IOException, IllegalArgumentException, NullPointerException {
        this(inputStream, (Config)null);
    }

    public ConfigFile(InputStream inputStream, Config config) throws IOException, IllegalArgumentException, NullPointerException {
        if (inputStream == null) {
            throw new NullPointerException();
        }
        this.initialize(inputStream, config);
    }

    public ConfigFile(File file) throws IOException, IllegalArgumentException, NullPointerException, FileNotFoundException, SecurityException {
        this(file, (Config)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigFile(File file, Config config) throws IOException, IllegalArgumentException, NullPointerException, FileNotFoundException, SecurityException {
        if (file == null) {
            throw new NullPointerException();
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            this.initialize(fileInputStream, config);
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    public ConfigFile(URL uRL) throws IOException, IllegalArgumentException, NullPointerException {
        this(uRL, (Config)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigFile(URL uRL, Config config) throws IOException, IllegalArgumentException, NullPointerException {
        if (uRL == null) {
            throw new NullPointerException();
        }
        InputStream inputStream = uRL.openStream();
        try {
            this.initialize(inputStream, config);
        }
        finally {
            inputStream.close();
        }
    }

    public ConfigFile(String string) throws IOException, IllegalArgumentException, NullPointerException, FileNotFoundException, SecurityException {
        this(string, (Config)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigFile(String string, Config config) throws IOException, IllegalArgumentException, NullPointerException, FileNotFoundException, SecurityException {
        InputStream inputStream = null;
        if (string == null) {
            throw new NullPointerException();
        }
        try {
            inputStream = new FileInputStream(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (inputStream == null) {
                URL uRL = ConfigFile.class.getClassLoader().getResource(string);
                if (uRL != null) {
                    inputStream = uRL.openStream();
                } else {
                    throw new FileNotFoundException();
                }
            }
            this.initialize(inputStream, config);
        }
        finally {
            if (inputStream != null) {
                ((InputStream)inputStream).close();
            }
        }
    }

    @Override
    public String get(String string) {
        String string2 = this.properties.getProperty(string);
        if (string2 == null && this.config != null) {
            string2 = this.config.get(string);
        }
        return string2;
    }

    @Override
    public String getKey() {
        return this.config != null ? this.config.getKey() : "";
    }

    @Override
    public String getKey(String string) {
        return this.config != null ? this.config.getKey(string) : string;
    }

    private void initialize(InputStream inputStream, Config config) throws IOException, IllegalArgumentException {
        this.config = config;
        this.properties = new Properties();
        this.properties.load(inputStream);
    }
}

