/*
 * Decompiled with CFR 0.152.
 */
package com.ingres.gcf.jdbc;

import com.ingres.gcf.jdbc.DrvBlob;
import com.ingres.gcf.jdbc.DrvClob;
import com.ingres.gcf.jdbc.DrvConn;
import com.ingres.gcf.jdbc.DrvLOB;
import com.ingres.gcf.jdbc.DrvNlob;
import com.ingres.gcf.jdbc.DrvPrep;
import com.ingres.gcf.jdbc.JdbcBlob;
import com.ingres.gcf.jdbc.JdbcClob;
import com.ingres.gcf.jdbc.JdbcQPMD;
import com.ingres.gcf.jdbc.JdbcRSMD;
import com.ingres.gcf.jdbc.JdbcStmt;
import com.ingres.gcf.jdbc.ParamSet;
import com.ingres.gcf.jdbc.RsltCurs;
import com.ingres.gcf.jdbc.RsltScrUpd;
import com.ingres.gcf.jdbc.RsltScroll;
import com.ingres.gcf.jdbc.RsltUpd;
import com.ingres.gcf.util.DbmsConst;
import com.ingres.gcf.util.SqlData;
import com.ingres.gcf.util.SqlExFactory;
import com.ingres.gcf.util.SqlWarn;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.DataTruncation;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.LinkedList;

public class JdbcPrep
extends JdbcStmt
implements PreparedStatement,
DbmsConst {
    protected ParamSet params;
    private String query_text = null;
    private JdbcQPMD prepQPMD = null;
    private JdbcRSMD prepRSMD = null;
    private JdbcRSMD emptyRSMD = null;
    private boolean loadGeneratedKeys = false;
    private JdbcRSMD localRSMD = null;

    JdbcPrep(DrvConn drvConn, String string, int n, int n2, int n3, boolean bl) throws SQLException {
        this(drvConn, n, n2, n3, bl);
        this.title = this.trace.getTraceName() + "-PreparedStatement[" + this.inst_id + "]";
        this.tr_id = "Prep[" + this.inst_id + "]";
        if (this.trace.enabled(2)) {
            this.trace.write(this.tr_id + ": '" + string + "'");
        }
        try {
            DrvPrep drvPrep = drvConn.createPrepStmt(string);
            this.query_text = string;
            this.prepRSMD = drvPrep.getMetaData();
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ": error preparing statement");
            }
            if (this.trace.enabled(1)) {
                SqlExFactory.trace(sQLException, this.trace);
            }
            throw sQLException;
        }
    }

    protected JdbcPrep(DrvConn drvConn, int n, int n2, int n3, boolean bl) {
        super(drvConn, n, n2, n3);
        this.loadGeneratedKeys = bl;
        this.params = new ParamSet(drvConn);
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeQuery()");
        }
        if (this.prepRSMD == null) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".executeQuery(): statement is not a query");
            }
            this.clearResults();
            throw SqlExFactory.get(ERR_GC4017_NO_RESULT_SET);
        }
        this.exec(this.params);
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeQuery(): " + this.resultSet);
        }
        return this.resultSet;
    }

    @Override
    public int executeUpdate() throws SQLException {
        int n;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeUpdate()");
        }
        if (this.prepRSMD != null) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".executeUpdate(): statement is a query");
            }
            this.clearResults();
            throw SqlExFactory.get(ERR_GC4018_RESULT_SET_NOT_PERMITTED);
        }
        this.exec(this.params);
        int n2 = n = (this.rslt_items & 8) != 0 ? this.rslt_val_rowcnt : 0;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeUpdate(): " + n);
        }
        return n;
    }

    @Override
    public boolean execute() throws SQLException {
        boolean bl;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".execute()");
        }
        this.exec(this.params);
        boolean bl2 = bl = this.resultSet != null;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".execute(): " + bl);
        }
        return bl;
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeQuery('" + string + "')");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public int executeUpdate(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeUpdate('" + string + "')");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public int executeUpdate(String string, int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeUpdate('" + string + "'," + n + ")");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public int executeUpdate(String string, int[] nArray) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeUpdate('" + string + "'," + (nArray == null ? "null" : "[" + nArray.length + "]") + ")");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeUpdate('" + string + "'," + (stringArray == null ? "null" : "[" + stringArray.length + "]") + ")");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public boolean execute(String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".execute('" + string + "' )");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public boolean execute(String string, int n) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".execute('" + string + "'," + n + ")");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public boolean execute(String string, int[] nArray) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".execute('" + string + "'," + (nArray == null ? "null" : "[" + nArray.length + "]") + ")");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public boolean execute(String string, String[] stringArray) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".execute('" + string + "'," + (stringArray == null ? "null" : "[" + stringArray.length + "]") + ")");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".addBatch()");
        }
        if (this.prepRSMD != null) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".addBatch(): statement is a query");
            }
            throw SqlExFactory.get(ERR_GC4018_RESULT_SET_NOT_PERMITTED);
        }
        if (this.batch == null) {
            this.newBatch();
        }
        LinkedList linkedList = this.batch;
        synchronized (linkedList) {
            this.batch.addLast(this.params);
            this.params = new ParamSet(this.conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        int[] nArray;
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".executeBatch()");
        }
        if (this.batch == null) {
            return BatchExec.noResults;
        }
        if ((this.conn.cnf_flags & 0x200) == 0 || this.conn.db_protocol_level < 6) {
            nArray = this.iterateBatch();
        } else {
            DrvPrep drvPrep;
            try {
                drvPrep = this.conn.findPrepStmt(this.query_text);
            }
            catch (SQLException sQLException) {
                if (this.trace.enabled()) {
                    this.trace.log(this.title + ": error preparing statement");
                }
                if (this.trace.enabled(1)) {
                    SqlExFactory.trace(sQLException, this.trace);
                }
                throw sQLException;
            }
            LinkedList linkedList = this.batch;
            synchronized (linkedList) {
                BatchExec batchExec = new BatchExec(this.conn);
                try {
                    nArray = batchExec.execute(this.batch, drvPrep.getStmtName());
                }
                finally {
                    this.batch.clear();
                }
            }
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] iterateBatch() throws SQLException {
        int[] nArray;
        LinkedList linkedList = this.batch;
        synchronized (linkedList) {
            int n = this.batch.size();
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                try {
                    ParamSet paramSet = (ParamSet)this.batch.pollFirst();
                    if (this.trace.enabled()) {
                        this.trace.log(this.title + ".executeBatch[" + i + "] ");
                    }
                    this.exec(paramSet);
                    int n2 = nArray[i] = (this.rslt_items & 8) != 0 ? this.rslt_val_rowcnt : -2;
                    if (!this.trace.enabled()) continue;
                    this.trace.log(this.title + ".executeBatch[" + i + "] = " + nArray[i]);
                    continue;
                }
                catch (SQLException sQLException) {
                    int[] nArray2 = new int[i];
                    if (i > 0) {
                        System.arraycopy(nArray, 0, nArray2, 0, i);
                    }
                    BatchUpdateException batchUpdateException = new BatchUpdateException(sQLException.getMessage(), sQLException.getSQLState(), sQLException.getErrorCode(), nArray2);
                    batchUpdateException.setNextException(sQLException.getNextException());
                    this.batch.clear();
                    throw batchUpdateException;
                }
            }
            this.batch.clear();
        }
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void exec(ParamSet paramSet) throws SQLException {
        DrvPrep drvPrep;
        int n;
        boolean bl = false;
        this.clearResults();
        int n2 = paramSet.getCount();
        for (n = 0; n < n2; ++n) {
            if (paramSet.isSet(n)) continue;
            if (!this.trace.enabled(1)) throw SqlExFactory.get(ERR_GC4020_NO_PARAM);
            this.trace.write(this.tr_id + ": parameter not set: " + (n + 1));
            throw SqlExFactory.get(ERR_GC4020_NO_PARAM);
        }
        try {
            drvPrep = this.conn.findPrepStmt(this.query_text);
            this.prepRSMD = drvPrep.getMetaData();
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ": error preparing statement");
            }
            if (!this.trace.enabled(1)) throw sQLException;
            SqlExFactory.trace(sQLException, this.trace);
            throw sQLException;
        }
        this.msg.lock();
        bl = true;
        try {
            JdbcRSMD jdbcRSMD;
            String string;
            if (this.prepRSMD == null) {
                this.msg.begin((byte)4);
                this.msg.write((short)4);
                this.msg.write((short)3);
                this.msg.write(drvPrep.getStmtName());
                this.msg.done(n2 <= 0);
                if (n2 > 0) {
                    paramSet.sendDesc(false);
                    paramSet.sendData(true);
                }
                this.readResults(this.timeout, true);
                if (!this.loadGeneratedKeys) return;
                this.loadGeneratedKeys();
                bl = this.msg.isLocked(false);
                return;
            }
            n = this.getConcurrency(drvPrep.getConcurrency());
            short s = 0;
            boolean bl2 = true;
            String string2 = drvPrep.getStmtName();
            String string3 = string = this.crsr_name != null ? this.crsr_name : this.conn.getUniqueID("JDBC_CRSR_");
            if (n == 0) {
                if (this.conn.msg_protocol_level < 2) {
                    string2 = string2 + " for readonly";
                } else {
                    s = (short)(s | 1);
                    if (this.conn.msg_protocol_level >= 3 && this.rs_type == 1003 && this.rs_fetch_size != 1) {
                        s = (short)(s | 4);
                        bl2 = false;
                    }
                }
            }
            if ((this.conn.cnf_flags & 0x100) != 0 && this.rs_type != 1003) {
                s = (short)(s | 0x40);
            } else if (this.conn.msg_protocol_level >= 3) {
                s = (short)(s | 2);
            }
            if (this.enableLocators(false)) {
                s = (short)(s | 0x20);
            }
            this.msg.begin((byte)4);
            this.msg.write((short)5);
            if (s != 0) {
                this.msg.write((short)6);
                this.msg.write((short)2);
                this.msg.write(s);
            }
            this.msg.write((short)2);
            this.msg.write(string);
            this.msg.write((short)3);
            this.msg.write(string2);
            this.msg.done(n2 <= 0);
            if (n2 > 0) {
                paramSet.sendDesc(false);
                paramSet.sendData(true);
            }
            if ((jdbcRSMD = this.readResults(this.timeout, bl2)) == null) {
                jdbcRSMD = this.prepRSMD;
            }
            switch (this.rslt_flags & 0x12) {
                case 0: {
                    if (this.rs_type != 1003 || this.rs_concur != 1) {
                        this.warnings = SqlWarn.get(ERR_GC4016_RS_CHANGED);
                    }
                    this.resultSet = new RsltUpd(this.conn, (JdbcStmt)this, jdbcRSMD, this.rslt_val_stmt, string, drvPrep.getTableName());
                    if (!this.msg.moreMessages()) return;
                    this.readResults(this.timeout, true);
                    return;
                }
                case 16: {
                    if (this.rs_type != 1005 || this.rs_concur != 1) {
                        this.warnings = SqlWarn.get(ERR_GC4016_RS_CHANGED);
                    }
                    this.resultSet = new RsltScrUpd(this.conn, (JdbcStmt)this, jdbcRSMD, this.rslt_val_stmt, string, drvPrep.getTableName());
                    if (!this.msg.moreMessages()) return;
                    this.readResults(this.timeout, true);
                    return;
                }
                case 2: {
                    if (this.rs_type != 1003 || this.rs_concur == 1) {
                        this.warnings = SqlWarn.get(ERR_GC4016_RS_CHANGED);
                    }
                    this.resultSet = new RsltCurs(this.conn, this, jdbcRSMD, this.rslt_val_stmt, this.crsr_name, this.getPreFetchSize(), this.msg.moreMessages());
                    return;
                }
                case 18: {
                    if (this.rs_type != 1004 || this.rs_concur == 1) {
                        this.warnings = SqlWarn.get(ERR_GC4016_RS_CHANGED);
                    }
                    this.resultSet = new RsltScroll(this.conn, this, jdbcRSMD, this.rslt_val_stmt, this.crsr_name, this.getPreFetchSize(), this.msg.moreMessages());
                    return;
                }
            }
            return;
        }
        catch (SQLException sQLException) {
            if (this.trace.enabled()) {
                this.trace.log(this.title + ".execute(): error executing query");
            }
            if (!this.trace.enabled(1)) throw sQLException;
            SqlExFactory.trace(sQLException, this.trace);
            throw sQLException;
        }
        finally {
            if (bl) {
                this.msg.unlock();
            }
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.query_text != null) {
            this.conn.dropPrepStmt(this.query_text);
            this.query_text = null;
        }
        super.close();
        this.params.clear(true);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getMetaData(): " + this.prepRSMD);
        }
        if (this.prepRSMD == null && this.emptyRSMD == null) {
            this.emptyRSMD = new JdbcRSMD(0, this.trace);
        }
        return this.prepRSMD == null ? this.emptyRSMD : this.prepRSMD;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getParameterMetaData()");
        }
        if (this.prepQPMD == null) {
            try {
                DrvPrep drvPrep = this.conn.findPrepStmt(this.query_text);
                this.prepQPMD = new JdbcQPMD(this.conn, drvPrep.getStmtName());
            }
            catch (SQLException sQLException) {
                if (this.trace.enabled()) {
                    this.trace.log(this.title + ": error describing statement");
                }
                if (this.trace.enabled(1)) {
                    SqlExFactory.trace(sQLException, this.trace);
                }
                throw sQLException;
            }
        }
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".getParameterMetaData(): " + this.prepQPMD);
        }
        return this.prepQPMD;
    }

    @Override
    public void clearParameters() throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".clearParameters()");
        }
        this.params.clear(false);
    }

    @Override
    public void setNull(int n, int n2, String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setNull( " + n + ", " + n2 + (string == null ? " )" : ", " + string + " )"));
        }
        n = this.paramMap(n);
        this.params.init(n, n2);
        this.params.setNull(n);
    }

    @Override
    public void setBoolean(int n, boolean bl) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setBoolean( " + n + ", " + bl + " )");
        }
        n = this.paramMap(n);
        this.params.init(n, 16);
        this.params.setBoolean(n, bl);
    }

    @Override
    public void setByte(int n, byte by) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setByte( " + n + ", " + by + " )");
        }
        n = this.paramMap(n);
        this.params.init(n, -6);
        this.params.setByte(n, by);
    }

    @Override
    public void setShort(int n, short s) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setShort( " + n + ", " + s + " )");
        }
        n = this.paramMap(n);
        this.params.init(n, 5);
        this.params.setShort(n, s);
    }

    @Override
    public void setInt(int n, int n2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + " setInt( " + n + ", " + n2 + " )");
        }
        n = this.paramMap(n);
        this.params.init(n, 4);
        this.params.setInt(n, n2);
    }

    @Override
    public void setLong(int n, long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setLong( " + n + ", " + l + " )");
        }
        n = this.paramMap(n);
        this.params.init(n, -5);
        this.params.setLong(n, l);
    }

    @Override
    public void setFloat(int n, float f) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setFloat( " + n + ", " + f + " )");
        }
        n = this.paramMap(n);
        this.params.init(n, 7);
        this.params.setFloat(n, f);
    }

    @Override
    public void setDouble(int n, double d) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setDouble( " + n + ", " + d + " )");
        }
        n = this.paramMap(n);
        this.params.init(n, 8);
        this.params.setDouble(n, d);
    }

    @Override
    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setBigDecimal( " + n + ", " + bigDecimal + " )");
        }
        n = this.paramMap(n);
        this.params.init(n, 3);
        this.params.setBigDecimal(n, bigDecimal);
    }

    @Override
    public void setString(int n, String string) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setString( " + n + ", " + string + " )");
        }
        n = this.paramMap(n);
        this.params.init(n, 12);
        this.params.setString(n, string);
    }

    @Override
    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setBytes( " + n + ", " + (byArray == null ? "null" : "[" + byArray.length + "]") + " )");
        }
        n = this.paramMap(n);
        this.params.init(n, -3);
        this.params.setBytes(n, byArray);
    }

    @Override
    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setDate( " + n + ", " + date + (calendar == null ? " )" : ", " + calendar + " )"));
        }
        n = this.paramMap(n);
        this.params.init(n, 91);
        this.params.setDate(n, date, calendar == null ? null : calendar.getTimeZone());
    }

    @Override
    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setTime( " + n + ", " + time + (calendar == null ? " )" : ", " + calendar + " )"));
        }
        n = this.paramMap(n);
        this.params.init(n, 92);
        this.params.setTime(n, time, calendar == null ? null : calendar.getTimeZone());
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setTimestamp( " + n + ", " + timestamp + (calendar == null ? " )" : ", " + calendar + " )"));
        }
        n = this.paramMap(n);
        this.params.init(n, 93);
        this.params.setTimestamp(n, timestamp, calendar == null ? null : calendar.getTimeZone());
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setBinaryStream( " + n + ", " + l + " )");
        }
        if (inputStream != null && l >= 0L && l <= (long)this.conn.max_vbyt_len) {
            byte[] byArray = new byte[(int)l];
            try {
                int n2;
                int n3 = n2 = l > 0L ? inputStream.read(byArray) : 0;
                if ((long)n2 != l) {
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.tr_id + ".setBinaryStream: read only " + n2 + " of " + l + " bytes!");
                    }
                    this.setWarning(new DataTruncation(n, true, false, (int)l, n2));
                }
            }
            catch (IOException iOException) {
                throw SqlExFactory.get(ERR_GC4007_BLOB_IO);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            n = this.paramMap(n);
            this.params.init(n, -3);
            this.params.setBytes(n, byArray);
        } else {
            n = this.paramMap(n);
            this.params.init(n, -4);
            this.params.setBinaryStream(n, inputStream);
        }
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setAsciiStream( " + n + ", " + l + " )");
        }
        if (inputStream != null && l >= 0L && l <= (long)(this.conn.ucs2_supported ? this.conn.max_nvch_len : this.conn.max_vchr_len)) {
            char[] cArray = new char[(int)l];
            try {
                int n2;
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "US-ASCII");
                int n3 = n2 = l > 0L ? inputStreamReader.read(cArray) : 0;
                if ((long)n2 != l) {
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.tr_id + ".setAsciiStream: read only " + n2 + " of " + l + " characters!");
                    }
                    this.setWarning(new DataTruncation(n, true, false, (int)l, n2));
                }
            }
            catch (IOException iOException) {
                throw SqlExFactory.get(ERR_GC4007_BLOB_IO);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            n = this.paramMap(n);
            this.params.init(n, 12);
            this.params.setString(n, new String(cArray));
        } else {
            n = this.paramMap(n);
            this.params.init(n, -1);
            this.params.setAsciiStream(n, inputStream);
        }
    }

    @Override
    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setUnicodeStream( " + n + ", " + n2 + " )");
        }
        n = this.paramMap(n);
        this.params.init(n, -1);
        this.params.setUnicodeStream(n, inputStream);
    }

    @Override
    public void setCharacterStream(int n, Reader reader, long l) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setCharacterStream( " + n + ", " + l + " )");
        }
        if (reader != null && l >= 0L && l <= (long)(this.conn.ucs2_supported ? this.conn.max_nvch_len : this.conn.max_vchr_len)) {
            char[] cArray = new char[(int)l];
            try {
                int n2;
                int n3 = n2 = l > 0L ? reader.read(cArray) : 0;
                if ((long)n2 != l) {
                    if (this.trace.enabled(1)) {
                        this.trace.write(this.tr_id + ".setCharacterStream: read only " + n2 + " of " + l + " characters!");
                    }
                    this.setWarning(new DataTruncation(n, true, false, (int)l, n2));
                }
            }
            catch (IOException iOException) {
                throw SqlExFactory.get(ERR_GC4007_BLOB_IO);
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            n = this.paramMap(n);
            this.params.init(n, 12);
            this.params.setString(n, new String(cArray));
        } else {
            n = this.paramMap(n);
            this.params.init(n, -1);
            this.params.setCharacterStream(n, reader);
        }
    }

    @Override
    public void setBlob(int n, Blob blob) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setBlob(" + n + "," + blob + ")");
        }
        n = this.paramMap(n);
        if (blob == null) {
            this.params.init(n, 2004);
            this.params.setNull(n);
        } else if (blob instanceof JdbcBlob && ((JdbcBlob)blob).isValidLocator(this.conn)) {
            DrvLOB drvLOB = ((JdbcBlob)blob).getLOB();
            this.params.init(n, drvLOB);
            if (drvLOB instanceof DrvBlob) {
                this.params.setBlob(n, (DrvBlob)drvLOB);
            } else {
                this.params.setBinaryStream(n, blob.getBinaryStream());
            }
        } else {
            this.params.init(n, -4);
            this.params.setBinaryStream(n, blob.getBinaryStream());
        }
    }

    @Override
    public void setClob(int n, Clob clob) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setClob(" + n + "," + clob + ")");
        }
        n = this.paramMap(n);
        if (clob == null) {
            this.params.init(n, 2005);
            this.params.setNull(n);
        } else if (clob instanceof JdbcClob && ((JdbcClob)clob).isValidLocator(this.conn)) {
            DrvLOB drvLOB = ((JdbcClob)clob).getLOB();
            this.params.init(n, drvLOB);
            if (drvLOB instanceof DrvClob) {
                this.params.setClob(n, (DrvClob)drvLOB);
            } else if (drvLOB instanceof DrvNlob) {
                this.params.setClob(n, (DrvNlob)drvLOB);
            } else {
                this.params.setCharacterStream(n, clob.getCharacterStream());
            }
        } else {
            this.params.init(n, -1);
            this.params.setCharacterStream(n, clob.getCharacterStream());
        }
    }

    @Override
    public void setObject(int n, Object object) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setObject( " + n + " )");
        }
        if (object != null) {
            if (object instanceof Blob) {
                object = object instanceof JdbcBlob && ((JdbcBlob)object).isValidLocator(this.conn) ? ((JdbcBlob)object).getLOB() : ((Blob)object).getBinaryStream();
            } else if (object instanceof Clob) {
                object = object instanceof JdbcClob && ((JdbcClob)object).isValidLocator(this.conn) ? ((JdbcClob)object).getLOB() : ((Clob)object).getCharacterStream();
            }
        }
        n = this.paramMap(n);
        this.params.init(n, object);
        this.params.setObject(n, object);
    }

    @Override
    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setObject( " + n + ", " + n2 + ", " + n3 + " )");
        }
        if (object != null) {
            if (object instanceof Blob) {
                object = object instanceof JdbcBlob && ((JdbcBlob)object).isValidLocator(this.conn) ? ((JdbcBlob)object).getLOB() : ((Blob)object).getBinaryStream();
            } else if (object instanceof Clob) {
                object = object instanceof JdbcClob && ((JdbcClob)object).isValidLocator(this.conn) ? ((JdbcClob)object).getLOB() : ((Clob)object).getCharacterStream();
            }
        }
        n = this.paramMap(n);
        switch (n2) {
            case 1111: {
                n2 = SqlData.getSqlType(object);
                this.params.init(n, object, true);
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                if (object != null && object instanceof String && ((String)object).length() == 0) {
                    this.params.init(n, n2, true);
                    break;
                }
                this.params.init(n, n2);
                break;
            }
            case -4: 
            case 2004: {
                if (object == null) {
                    this.params.init(n, n2);
                    break;
                }
                if (object instanceof DrvBlob) {
                    n2 = 2004;
                    this.params.init(n, object);
                    break;
                }
                n2 = -4;
                this.params.init(n, n2);
                break;
            }
            case -1: 
            case 2005: {
                if (object == null) {
                    this.params.init(n, n2);
                    break;
                }
                if (object instanceof DrvClob || object instanceof DrvNlob) {
                    n2 = 2005;
                    this.params.init(n, object);
                    break;
                }
                n2 = -1;
                this.params.init(n, n2);
                break;
            }
            default: {
                this.params.init(n, n2);
            }
        }
        this.params.setObject(n, object, n2, n3);
    }

    @Override
    public void setNull(int n, int n2) throws SQLException {
        this.setNull(n, n2, null);
    }

    @Override
    public void setDate(int n, Date date) throws SQLException {
        this.setDate(n, date, null);
    }

    @Override
    public void setTime(int n, Time time) throws SQLException {
        this.setTime(n, time, null);
    }

    @Override
    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.setTimestamp(n, timestamp, null);
    }

    @Override
    public void setObject(int n, Object object, int n2) throws SQLException {
        this.setObject(n, object, n2, 0);
    }

    @Override
    public void setNString(int n, String string) throws SQLException {
        this.setString(n, string);
    }

    @Override
    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.setCharacterStream(n, reader, (long)n2);
    }

    @Override
    public void setCharacterStream(int n, Reader reader) throws SQLException {
        this.setCharacterStream(n, reader, -1L);
    }

    @Override
    public void setClob(int n, Reader reader, long l) throws SQLException {
        this.setCharacterStream(n, reader, l);
    }

    @Override
    public void setClob(int n, Reader reader) throws SQLException {
        this.setCharacterStream(n, reader, -1L);
    }

    @Override
    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        this.setCharacterStream(n, reader, l);
    }

    @Override
    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        this.setCharacterStream(n, reader, -1L);
    }

    @Override
    public void setNClob(int n, NClob nClob) throws SQLException {
        this.setClob(n, nClob);
    }

    @Override
    public void setNClob(int n, Reader reader, long l) throws SQLException {
        this.setCharacterStream(n, reader, l);
    }

    @Override
    public void setNClob(int n, Reader reader) throws SQLException {
        this.setCharacterStream(n, reader, -1L);
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setAsciiStream(n, inputStream, (long)n2);
    }

    @Override
    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        this.setAsciiStream(n, inputStream, -1L);
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.setBinaryStream(n, inputStream, (long)n2);
    }

    @Override
    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        this.setBinaryStream(n, inputStream, -1L);
    }

    @Override
    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        this.setBinaryStream(n, inputStream, l);
    }

    @Override
    public void setBlob(int n, InputStream inputStream) throws SQLException {
        this.setBinaryStream(n, inputStream, -1L);
    }

    @Override
    public void setArray(int n, Array array) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setArray(" + n + ")");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void setRef(int n, Ref ref) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setRef(" + n + ")");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void setURL(int n, URL uRL) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setURL(" + n + ")");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void setRowId(int n, RowId rowId) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setRowId( " + n + ", " + rowId + " )");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".setSQLXML( " + n + ")");
        }
        throw SqlExFactory.get(ERR_GC4019_UNSUPPORTED);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".isWrapperFor(" + clazz + ")");
        }
        if (clazz != null) {
            return clazz.isInstance(this);
        }
        throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        if (this.trace.enabled()) {
            this.trace.log(this.title + ".Unwrap(" + clazz + ")");
        }
        if (clazz != null) {
            if (!clazz.isInstance(this)) {
                throw SqlExFactory.get(ERR_GC4023_NO_OBJECT);
            }
            return clazz.cast(this);
        }
        throw SqlExFactory.get(ERR_GC4010_PARAM_VALUE);
    }

    protected int paramMap(int n) throws SQLException {
        if (n < 1) {
            throw SqlExFactory.get(ERR_GC4011_INDEX_RANGE);
        }
        return n - 1;
    }

    @Override
    protected JdbcRSMD readDesc() throws SQLException {
        this.localRSMD = this.readDesc(this.localRSMD);
        return this.localRSMD;
    }

    protected static class BatchExec
    extends JdbcStmt.BatchExec {
        public BatchExec(DrvConn drvConn) {
            super(drvConn);
        }

        public int[] execute(LinkedList linkedList, String string) throws SQLException {
            if (linkedList == null || linkedList.peekFirst() == null) {
                return noResults;
            }
            this.clearResults();
            this.msg.lock();
            try {
                ParamSet paramSet;
                boolean bl = true;
                int n = 0;
                while ((paramSet = (ParamSet)linkedList.pollFirst()) != null) {
                    int n2 = paramSet.getCount();
                    byte by = linkedList.peekFirst() == null ? (byte)2 : 4;
                    for (int i = 0; i < n2; ++i) {
                        if (paramSet.isSet(i)) continue;
                        if (this.trace.enabled(1)) {
                            this.trace.write(this.tr_id + ": parameter not set: " + (i + 1));
                        }
                        throw SqlExFactory.get(ERR_GC4020_NO_PARAM);
                    }
                    if (this.trace.enabled()) {
                        this.trace.log(this.title + ".executeBatch[" + n + "]");
                    }
                    ++n;
                    this.msg.begin((byte)12);
                    this.msg.write((short)4);
                    if (bl) {
                        this.msg.write((short)3);
                        this.msg.write(string);
                        bl = false;
                    } else {
                        this.msg.write((short)6);
                        this.msg.write((short)2);
                        this.msg.write((short)128);
                    }
                    if (n2 <= 0) {
                        this.msg.done(by);
                        continue;
                    }
                    this.msg.done(false);
                    paramSet.sendDesc(false);
                    paramSet.sendData(by);
                }
                this.readResults(n);
            }
            catch (SQLException sQLException) {
                if (this.trace.enabled()) {
                    this.trace.log(this.title + ".execute(): error executing batch");
                }
                if (this.trace.enabled(1)) {
                    SqlExFactory.trace(sQLException, this.trace);
                }
                throw sQLException;
            }
            finally {
                this.msg.unlock();
            }
            return this.batchResults();
        }
    }
}

