/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mssql.model.generic;

import java.sql.SQLException;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.mssql.model.generic.SQLServerGenericDataSource;
import org.jkiss.dbeaver.ext.mssql.model.generic.SQLServerGenericTableColumn;
import org.jkiss.dbeaver.ext.mssql.model.generic.SQLServerMetaModel;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPObjectWithLazyDescription;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;

public class SQLServerGenericTable
extends GenericTable
implements DBPObjectWithLazyDescription {
    public SQLServerGenericTable(GenericStructContainer container, String tableName, String tableType, JDBCResultSet dbResult) {
        super(container, tableName, tableType, dbResult);
    }

    @Nullable
    public synchronized List<SQLServerGenericTableColumn> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return super.getAttributes(monitor);
    }

    public SQLServerGenericTableColumn getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBException {
        return (SQLServerGenericTableColumn)super.getAttribute(monitor, attributeName);
    }

    public String getDescription() {
        return super.getDescription();
    }

    @Property(viewable=true, length=PropertyLength.MULTILINE, order=100)
    public String getDescription(DBRProgressMonitor monitor) throws DBException {
        String description = this.getDescription();
        if (description != null || !this.isSqlServer()) {
            return description;
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (JDBCSession session = (JDBCSession)DBUtils.openUtilSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read table description");){
            DBSCatalog defaultDatabase = DBUtils.getDefaultContext((DBSObject)this.getDataSource(), (boolean)true).getContextDefaults().getDefaultCatalog();
            boolean switchSchema = this.getCatalog() != null && defaultDatabase != null && defaultDatabase != this.getCatalog();
            try {
                Throwable throwable2 = null;
                Object var9_13 = null;
                try (JDBCPreparedStatement dbStat = session.prepareStatement(String.valueOf(switchSchema ? "USE " + DBUtils.getQuotedIdentifier((DBSObject)this.getCatalog()) + ";\n" : "") + "SELECT cast(value as varchar(8000)) as value " + "FROM fn_listextendedproperty ('MS_DESCRIPTION', 'schema', ?, 'table', ?, default, default);\n" + (switchSchema ? "USE " + DBUtils.getQuotedIdentifier((DBSObject)defaultDatabase) + ";\n" : ""));){
                    dbStat.setString(1, this.getSchema().getName());
                    dbStat.setString(2, this.getName());
                    Throwable throwable3 = null;
                    Object var12_18 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        description = dbResult.next() ? dbResult.getString(1) : "";
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (SQLException e) {
                throw new DBException((Throwable)e, (DBPDataSource)this.getDataSource());
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
        this.setDescription(description);
        return description;
    }

    public SQLServerGenericDataSource getDataSource() {
        return (SQLServerGenericDataSource)super.getDataSource();
    }

    private boolean isSqlServer() {
        return ((SQLServerMetaModel)this.getDataSource().getMetaModel()).isSqlServer();
    }

    protected boolean isTruncateSupported() {
        return true;
    }
}

