/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redis.exec;

import com.dbeaver.db.redis.RedisUtils;
import com.dbeaver.db.redis.exec.RedisBaseResultSet;
import com.dbeaver.db.redis.exec.RedisBaseStatement;
import com.dbeaver.db.redis.exec.RedisCommandStatement;
import com.dbeaver.db.redis.exec.RedisResultSetCursor;
import com.dbeaver.db.redis.exec.RedisResultSetList;
import com.dbeaver.db.redis.exec.RedisResultSetSimple;
import com.dbeaver.db.redis.exec.RedisSession;
import com.dbeaver.db.redis.model.RedisKey;
import com.dbeaver.db.redis.model.RedisKeyType;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import redis.clients.jedis.commands.JedisClusterCommands;
import redis.clients.jedis.commands.JedisCommands;

public class RedisKeyGetStatement
extends RedisBaseStatement {
    private static final Log log = Log.getLog(RedisKeyGetStatement.class);
    @NotNull
    private final RedisKeyType keyType;
    @NotNull
    private final RedisKey key;
    private RedisBaseResultSet resultSet;

    public RedisKeyGetStatement(@NotNull RedisSession session, @NotNull RedisKey key, long firstRow, long maxRows) {
        super(session, "SELECT * FROM " + key, firstRow, maxRows);
        this.key = key;
        this.keyType = key.getKeyType(session.getProgressMonitor());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean executeStatement() throws DBCException {
        if (this.session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        }
        RedisUtils.selectCurDatabase(this.session, this.key.getDatabase());
        String keyName = this.key.getFullyQualifiedName(DBPEvaluationContext.DML);
        try {
            switch (this.keyType) {
                case string: {
                    Object keyValue;
                    boolean isJson = false;
                    try {
                        keyValue = this.session.supportsCommands(JedisCommands.class) ? this.session.getCommands(JedisCommands.class).get(keyName) : this.session.getCommands(JedisClusterCommands.class).get(keyName);
                    }
                    catch (Exception e) {
                        if (e.getMessage() == null || !e.getMessage().startsWith("WRONGTYPE")) throw e;
                        try {
                            keyValue = RedisCommandStatement.executeCommand(this.session.getJedisClient(), "JSON.GET", keyName);
                            isJson = true;
                        }
                        catch (Throwable throwable) {
                            throw e;
                        }
                    }
                    this.resultSet = new RedisResultSetSimple(this, keyValue, this.offset);
                    if (!isJson) return true;
                    ((RedisResultSetSimple)this.resultSet).setJson(true);
                    return true;
                }
                case set: 
                case zset: 
                case hash: {
                    this.resultSet = new RedisResultSetCursor(this, keyName, this.keyType);
                    return true;
                }
                case list: {
                    this.resultSet = new RedisResultSetList(this, keyName);
                    return true;
                }
                default: {
                    throw new DBCException("Unsupported key type: " + (Object)((Object)this.keyType));
                }
            }
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            if (this.session.isLoggingEnabled()) {
                QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, -1L, this.executeError);
            }
        }
    }

    public RedisBaseResultSet openResultSet() throws DBCException {
        if (this.resultSet == null) {
            throw new DBCException("Can't open Redis key result set before execute");
        }
        return this.resultSet;
    }
}

