/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.rds.RdsAsyncClient;
import software.amazon.awssdk.services.rds.model.CustomAvailabilityZone;
import software.amazon.awssdk.services.rds.model.DescribeCustomAvailabilityZonesRequest;
import software.amazon.awssdk.services.rds.model.DescribeCustomAvailabilityZonesResponse;

public class DescribeCustomAvailabilityZonesPublisher
implements SdkPublisher<DescribeCustomAvailabilityZonesResponse> {
    private final RdsAsyncClient client;
    private final DescribeCustomAvailabilityZonesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeCustomAvailabilityZonesPublisher(RdsAsyncClient client, DescribeCustomAvailabilityZonesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeCustomAvailabilityZonesPublisher(RdsAsyncClient client, DescribeCustomAvailabilityZonesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeCustomAvailabilityZonesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeCustomAvailabilityZonesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CustomAvailabilityZone> customAvailabilityZones() {
        Function<DescribeCustomAvailabilityZonesResponse, Iterator> getIterator = response -> {
            if (response != null && response.customAvailabilityZones() != null) {
                return response.customAvailabilityZones().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeCustomAvailabilityZonesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeCustomAvailabilityZonesResponseFetcher
    implements AsyncPageFetcher<DescribeCustomAvailabilityZonesResponse> {
        private DescribeCustomAvailabilityZonesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCustomAvailabilityZonesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeCustomAvailabilityZonesResponse> nextPage(DescribeCustomAvailabilityZonesResponse previousPage) {
            if (previousPage == null) {
                return DescribeCustomAvailabilityZonesPublisher.this.client.describeCustomAvailabilityZones(DescribeCustomAvailabilityZonesPublisher.this.firstRequest);
            }
            return DescribeCustomAvailabilityZonesPublisher.this.client.describeCustomAvailabilityZones((DescribeCustomAvailabilityZonesRequest)((Object)DescribeCustomAvailabilityZonesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

