/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb.dom;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.internal.OracleConnection;
import oracle.xdb.XMLType;
import oracle.xdb.dom.XDBAttribute;
import oracle.xdb.dom.XDBCData;
import oracle.xdb.dom.XDBComment;
import oracle.xdb.dom.XDBDOMException;
import oracle.xdb.dom.XDBDocFragment;
import oracle.xdb.dom.XDBDocumentType;
import oracle.xdb.dom.XDBDomImplementation;
import oracle.xdb.dom.XDBElement;
import oracle.xdb.dom.XDBEntity;
import oracle.xdb.dom.XDBEntityReference;
import oracle.xdb.dom.XDBNode;
import oracle.xdb.dom.XDBNodeList;
import oracle.xdb.dom.XDBNotImplementedException;
import oracle.xdb.dom.XDBNotation;
import oracle.xdb.dom.XDBProcInst;
import oracle.xdb.dom.XDBText;
import oracle.xdb.spi.XDBResource;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class XDBDocument
extends XDBNode
implements Document {
    static final String NAME_NAMESPACE_SEPARATOR = ":";
    private XMLType m_parentXML = null;

    private synchronized native long createNative(long var1);

    private synchronized native long createFromStringNative(long var1, String var3);

    private static synchronized native long getEnvNative(long var0);

    private synchronized native long createElementNative(long var1, long var3, String var5, String var6, String var7);

    private synchronized native long createDocumentFragmentNative(long var1, long var3);

    private synchronized native long createTextNodeNative(long var1, long var3, String var5);

    private synchronized native long createAttributeNative(long var1, long var3, String var5, String var6, String var7);

    private synchronized native long createEntityRefNative(long var1, long var3, String var5);

    private synchronized native long createPINodeNative(long var1, long var3, String var5, String var6);

    private synchronized native long createCommentNodeNative(long var1, long var3, String var5);

    private synchronized native long getElementsByTagNative(long var1, long var3, String var5, String var6);

    private synchronized native long importNodeNative(long var1, long var3, long var5, boolean var7);

    private synchronized native long createFromBytesNative(long var1, byte[] var3);

    private synchronized native void destroyNative(long var1, long var3);

    private synchronized native long getDocumentElementNative(long var1, long var3);

    private synchronized native long setDocumentElementNative(long var1, long var3, long var5);

    private synchronized native long replDocumentElementNative(long var1, long var3);

    private synchronized native long removeDocumentElementNative(long var1, long var3);

    private synchronized native long getDocTypeNative(long var1, long var3);

    private synchronized native boolean checkDocValidNative(long var1);

    @Override
    public DocumentType getDoctype() {
        if (this.m_closed) {
            return null;
        }
        long dtdcs = this.getDocTypeNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate);
        if (dtdcs == 0L) {
            return null;
        }
        return new XDBDocumentType(this, dtdcs);
    }

    @Override
    public DOMImplementation getImplementation() {
        if (this.m_closed) {
            return null;
        }
        return new XDBDomImplementation(this.m_conn);
    }

    @Override
    public Element getDocumentElement() {
        if (this.m_closed) {
            return null;
        }
        long retVal = this.getDocumentElementNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate);
        if (retVal == 0L) {
            return null;
        }
        return new XDBElement(this, retVal);
    }

    @Override
    public Element createElement(String tagName) throws DOMException {
        if (this.m_closed) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        XDBNode.validateName(tagName);
        int index = tagName.lastIndexOf(NAME_NAMESPACE_SEPARATOR);
        String namespace = "";
        String name = tagName;
        long retVal = this.createElementNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate, null, namespace, name);
        return new XDBElement(this, retVal);
    }

    @Override
    public DocumentFragment createDocumentFragment() {
        if (this.m_closed) {
            return null;
        }
        long retVal = this.createDocumentFragmentNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate);
        return new XDBDocFragment(this, retVal);
    }

    @Override
    public Text createTextNode(String data) {
        if (this.m_closed) {
            return null;
        }
        long retVal = this.createTextNodeNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate, data);
        return new XDBText(this, retVal);
    }

    @Override
    public Comment createComment(String data) {
        if (this.m_closed) {
            return null;
        }
        long commentxob = this.createCommentNodeNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate, data);
        return new XDBComment(this, commentxob);
    }

    @Override
    public CDATASection createCDATASection(String data) throws DOMException {
        if (this.m_closed) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        long retVal = this.createTextNodeNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate, data);
        return new XDBCData(this, retVal);
    }

    @Override
    public ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        if (this.m_closed) {
            return null;
        }
        XDBNode.validateName(target);
        long pixob = this.createPINodeNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate, target, data);
        return new XDBProcInst(this, pixob);
    }

    @Override
    public Attr createAttribute(String qname) throws DOMException {
        if (this.m_closed) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        XDBNode.validateName(qname);
        int index = qname.lastIndexOf(NAME_NAMESPACE_SEPARATOR);
        String namespace = null;
        String name = qname;
        long retVal = this.createAttributeNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate, null, namespace, name);
        return new XDBAttribute(this, retVal);
    }

    @Override
    public EntityReference createEntityReference(String name) throws DOMException {
        if (this.m_closed) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        XDBNode.validateName(name);
        long erxob = this.createEntityRefNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate, name);
        if (erxob == 0L) {
            return null;
        }
        return new XDBEntityReference(this, erxob);
    }

    @Override
    public NodeList getElementsByTagName(String tagname) {
        if (this.m_closed) {
            return null;
        }
        long retval = this.getElementsByTagNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate, null, tagname);
        if (retval == 0L) {
            return null;
        }
        return new XDBNodeList(retval, this);
    }

    @Override
    public Node importNode(Node importNode, boolean deep) throws DOMException {
        if (this.m_closed) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        short nodeType = importNode.getNodeType();
        if (nodeType != 9 && nodeType != 10) {
            long node = this.importNodeNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate, ((XDBNode)importNode).toCState(), deep);
            XDBNode retval = null;
            if (node != 0L) {
                switch (nodeType) {
                    case 2: {
                        retval = new XDBAttribute(this.m_owner, node);
                        break;
                    }
                    case 4: {
                        retval = new XDBCData(this.m_owner, node);
                        break;
                    }
                    case 8: {
                        retval = new XDBComment(this.m_owner, node);
                        break;
                    }
                    case 11: {
                        retval = new XDBDocFragment(this.m_owner, node);
                        break;
                    }
                    case 9: {
                        retval = new XDBDocument(this.m_conn, node);
                        break;
                    }
                    case 10: {
                        retval = new XDBDocumentType(this.m_owner, node);
                        break;
                    }
                    case 1: {
                        retval = new XDBElement(this.m_owner, node);
                        break;
                    }
                    case 6: {
                        retval = new XDBEntity(this.m_owner, node);
                        break;
                    }
                    case 5: {
                        retval = new XDBEntityReference(this.m_owner, node);
                        break;
                    }
                    case 12: {
                        retval = new XDBNotation(this.m_owner, node);
                        break;
                    }
                    case 7: {
                        retval = new XDBProcInst(this.m_owner, node);
                        break;
                    }
                    case 3: {
                        retval = new XDBText(this.m_owner, node);
                    }
                }
            }
            return retval;
        }
        throw new XDBDOMException(9, "Node type not supported");
    }

    @Override
    public Element createElementNS(String nsURI, String qname) throws DOMException {
        if (this.m_closed) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        XDBNode.validateName(qname);
        int index = qname.lastIndexOf(NAME_NAMESPACE_SEPARATOR);
        String namespace = "";
        String name = qname;
        long retVal = this.createElementNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate, nsURI, namespace, name);
        return new XDBElement(this, retVal);
    }

    @Override
    public Attr createAttributeNS(String nsURI, String qname) throws DOMException {
        if (this.m_closed) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        XDBNode.validateName(qname);
        int index = qname.lastIndexOf(NAME_NAMESPACE_SEPARATOR);
        String namespace = "";
        String name = qname;
        long retVal = this.createAttributeNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate, nsURI, namespace, name);
        return new XDBAttribute(this, retVal);
    }

    @Override
    public NodeList getElementsByTagNameNS(String nsURI, String tagname) {
        if (this.m_closed) {
            return null;
        }
        long retval = this.getElementsByTagNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate, nsURI, tagname);
        if (retval == 0L) {
            return null;
        }
        return new XDBNodeList(retval, this);
    }

    @Override
    public Element getElementById(String id) {
        if (this.m_closed) {
            return null;
        }
        throw new XDBNotImplementedException();
    }

    @Override
    public String getNodeName() {
        if (this.m_closed) {
            return null;
        }
        return "#document";
    }

    @Override
    public Document getOwnerDocument() {
        return null;
    }

    @Override
    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (this.m_closed) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        long retVal = this.getDocumentElementNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate);
        if (retVal == 0L) {
            if (!(newChild instanceof XDBNode)) {
                throw new XDBDOMException(9, "argument must be an XDBNode");
            }
            XDBNode newch = (XDBNode)newChild;
            this.setDocumentElementNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate, newch.toCState());
            return newChild;
        }
        throw new XDBDOMException(3, "");
    }

    @Override
    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        if (this.m_closed) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        XDBNode oldch = (XDBNode)oldChild;
        if (oldch.toCState() == this.getDocumentElementNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate) && newChild.getNodeType() == 1) {
            this.insertBefore(newChild, oldChild);
            this.removeChild(oldChild);
        }
        return oldChild;
    }

    @Override
    public Node removeChild(Node arg) throws DOMException {
        if (this.m_closed) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        if (!(arg instanceof XDBNode)) {
            throw new XDBDOMException(9, "argument must be an XDBNode");
        }
        XDBNode xarg = (XDBNode)arg;
        if (xarg.toCState() == this.getDocumentElementNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate)) {
            this.removeDocumentElementNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate);
            return arg;
        }
        throw new XDBDOMException(8, "");
    }

    @Override
    public Node appendChild(Node arg) throws DOMException {
        if (this.m_closed) {
            throw new DOMException(11, "CLOSED_OBJECT");
        }
        if (!(arg instanceof XDBNode)) {
            throw new XDBDOMException(9, "argument must be an XDBNode");
        }
        if (arg.getNodeType() != 1 && arg.getNodeType() != 11) {
            throw new XDBDOMException(9, "");
        }
        XDBNode xarg = (XDBNode)arg;
        super.appendChild(arg);
        return arg;
    }

    @Override
    public Node getFirstChild() {
        if (this.m_closed) {
            return null;
        }
        return super.getFirstChild();
    }

    @Override
    public Node getLastChild() {
        if (this.m_closed) {
            return null;
        }
        return super.getLastChild();
    }

    @Override
    public Node getPreviousSibling() {
        return null;
    }

    @Override
    public Node getNextSibling() {
        return null;
    }

    public XDBDocument() {
        super(null, 0L, (short)9);
        this.m_owner = this;
        this.m_conn = null;
        this.m_xobcstate = this.createNative(XDBDocument.getGP(this.m_conn));
    }

    public XDBDocument(Connection conn) throws Exception {
        super(null, 0L, (short)9);
        this.initConn(conn);
        this.m_owner = this;
        this.m_conn = conn;
        this.m_xobcstate = this.createNative(XDBDocument.getGP(conn));
    }

    public XDBDocument(String source) {
        super(null, 0L, (short)9);
        this.m_owner = this;
        this.m_conn = null;
        this.m_xobcstate = this.createFromStringNative(XDBDocument.getGP(this.m_conn), source);
    }

    public XDBDocument(Connection conn, String source) throws Exception {
        super(null, 0L, (short)9);
        this.initConn(conn);
        this.m_owner = this;
        this.m_conn = conn;
        this.m_xobcstate = this.createFromStringNative(XDBDocument.getGP(conn), source);
    }

    public XDBDocument(byte[] source) {
        super(null, 0L, (short)9);
        this.m_owner = this;
        this.m_conn = null;
        this.m_xobcstate = this.createFromBytesNative(XDBDocument.getGP(this.m_conn), source);
    }

    public XDBDocument(Connection conn, byte[] source) throws Exception {
        super(null, 0L, (short)9);
        this.initConn(conn);
        this.m_owner = this;
        this.m_conn = conn;
        this.m_xobcstate = this.createFromBytesNative(XDBDocument.getGP(conn), source);
    }

    public XDBDocument(Connection conn, long xobd) throws XDBDOMException {
        super(null, xobd, (short)9);
        this.initConn(conn);
        this.m_owner = this;
        this.m_conn = conn;
        if (this.m_xobcstate == 0L) {
            this.m_closed = true;
        }
    }

    public XDBDocument(XMLType parxmlt, Connection conn, long xobd) throws XDBDOMException {
        super(null, xobd, (short)9);
        this.initConn(conn);
        this.m_parentXML = parxmlt;
        this.m_owner = this;
        this.m_conn = conn;
        if (this.m_xobcstate == 0L) {
            this.m_closed = true;
        }
    }

    private void freeDocument() {
        if (this.m_closed) {
            return;
        }
        if (this.m_parentXML != null) {
            this.m_closed = true;
            return;
        }
        if (this.m_xobcstate != 0L) {
            this.destroyNative(XDBDocument.getGP(this.m_conn), this.m_xobcstate);
            this.m_xobcstate = 0L;
            this.m_closed = true;
        }
    }

    @Override
    public boolean isClosed() {
        return this.m_closed;
    }

    @Override
    public void close() {
        this.freeDocument();
    }

    @Override
    public void finalize() throws Throwable {
    }

    public static long getGP(Connection conn) {
        long gpcstate;
        String prottype = null;
        if (conn != null) {
            prottype = ((OracleConnection)conn).getProtocolType();
        }
        if (conn == null || prottype.equals("kprb")) {
            gpcstate = XDBResource.getServerEnv();
        } else {
            OracleConnection oconn = ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin();
            if (prottype.equals("oci") || prottype.equals("oci8")) {
                try {
                    Properties prop = oconn.getOCIHandles();
                    gpcstate = XDBDocument.getEnvNative(Long.parseLong(prop.getProperty("OCIEnvHandle")));
                }
                catch (SQLException e) {
                    gpcstate = 0L;
                }
            } else {
                gpcstate = 0L;
            }
        }
        return gpcstate;
    }

    private void initConn(Connection conn) {
        if (conn == null) {
            return;
        }
        OracleConnection local_conn = ((oracle.jdbc.OracleConnection)conn).physicalConnectionWithin();
        if (local_conn.getProtocolType().equals("oci8") || local_conn.getProtocolType().equals("oci")) {
            try {
                String osName = System.getProperty("os.name");
                if (osName != null && osName.toUpperCase().startsWith("WINDOWS")) {
                    System.loadLibrary("orageneric12");
                } else if (osName.equalsIgnoreCase("Mac OS X")) {
                    System.loadLibrary("clntsh");
                }
            }
            catch (Exception ex) {
                throw new XDBDOMException(9, "unable to load library: orageneric12");
            }
        }
    }

    @Override
    public Node renameNode(Node n, String namespaceURI, String qualifiedName) throws DOMException {
        return null;
    }

    @Override
    public DOMConfiguration getDomConfig() {
        return null;
    }

    @Override
    public void normalizeDocument() {
    }

    @Override
    public boolean getStrictErrorChecking() {
        return false;
    }

    @Override
    public void setStrictErrorChecking(boolean strictErrorChecking) {
    }

    @Override
    public String getDocumentURI() {
        return null;
    }

    @Override
    public void setDocumentURI(String documentURI) {
    }

    @Override
    public Node adoptNode(Node source) throws DOMException {
        return null;
    }

    @Override
    public String getInputEncoding() {
        return null;
    }

    @Override
    public String getXmlEncoding() {
        return null;
    }

    @Override
    public boolean getXmlStandalone() {
        return false;
    }

    @Override
    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
    }

    @Override
    public String getXmlVersion() {
        return null;
    }

    @Override
    public void setXmlVersion(String xmlVersion) throws DOMException {
    }
}

