/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.preferences;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditorDescriptor;
import org.jkiss.dbeaver.ui.editors.entity.EntityEditorsRegistry;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.NavigatorPreferences;
import org.jkiss.dbeaver.ui.preferences.AbstractPrefPage;
import org.jkiss.dbeaver.ui.preferences.PreferenceStoreDelegate;
import org.jkiss.dbeaver.utils.PrefUtils;
import org.jkiss.utils.CommonUtils;

public class PrefPageDatabaseNavigator
extends AbstractPrefPage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    public static final String PAGE_ID = "org.jkiss.dbeaver.preferences.navigator";
    private Button expandOnConnectCheck;
    private Text restoreStateDepthText;
    private Button sortCaseInsensitiveCheck;
    private Button sortFoldersFirstCheck;
    private Button showConnectionHostCheck;
    private Button showStatisticsCheck;
    private Button showNodeActionsCheck;
    private Button colorAllNodesCheck;
    private Button showObjectTipsCheck;
    private Button showToolTipsCheck;
    private Button showContentsInToolTipsContents;
    private Button showResourceFolderPlaceholdersCheck;
    private Button groupByDriverCheck;
    private Text longListFetchSizeText;
    private Combo dsDoubleClickBehavior;
    private Combo objDoubleClickBehavior;
    private Combo defaultEditorPageCombo;

    public PrefPageDatabaseNavigator() {
        this.setPreferenceStore((IPreferenceStore)new PreferenceStoreDelegate(DBWorkbench.getPlatform().getPreferenceStore()));
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)2, (int)5);
        Group navigatorGroup = UIUtils.createControlGroup((Composite)composite, (String)UINavigatorMessages.pref_page_database_general_group_navigator, (int)2, (int)0, (int)0);
        ((GridData)navigatorGroup.getLayoutData()).verticalSpan = 2;
        this.showConnectionHostCheck = UIUtils.createCheckbox((Composite)navigatorGroup, (String)UINavigatorMessages.pref_page_database_general_label_show_host_name, (String)UINavigatorMessages.pref_page_database_general_label_show_host_name_tip, (boolean)false, (int)2);
        this.showStatisticsCheck = UIUtils.createCheckbox((Composite)navigatorGroup, (String)UINavigatorMessages.pref_page_database_general_label_show_statistics, (String)UINavigatorMessages.pref_page_database_general_label_show_statistics_tip, (boolean)false, (int)2);
        this.showNodeActionsCheck = UIUtils.createCheckbox((Composite)navigatorGroup, (String)UINavigatorMessages.pref_page_database_general_label_show_node_actions, (String)UINavigatorMessages.pref_page_database_general_label_show_node_actions_tip, (boolean)false, (int)2);
        this.showResourceFolderPlaceholdersCheck = UIUtils.createCheckbox((Composite)navigatorGroup, (String)UINavigatorMessages.pref_page_database_general_label_show_folder_placeholders, (String)UINavigatorMessages.pref_page_database_general_label_show_folder_placeholders_tip, (boolean)false, (int)2);
        this.sortFoldersFirstCheck = UIUtils.createCheckbox((Composite)navigatorGroup, (String)UINavigatorMessages.pref_page_database_general_label_folders_first, (String)UINavigatorMessages.pref_page_database_general_label_folders_first_tip, (boolean)false, (int)2);
        this.groupByDriverCheck = UIUtils.createCheckbox((Composite)navigatorGroup, (String)UINavigatorMessages.pref_page_database_general_label_group_database_by_driver, (String)"", (boolean)false, (int)2);
        this.groupByDriverCheck.setEnabled(false);
        this.sortCaseInsensitiveCheck = UIUtils.createCheckbox((Composite)navigatorGroup, (String)UINavigatorMessages.pref_page_database_general_label_order_elements_alphabetically, (String)"", (boolean)false, (int)2);
        this.colorAllNodesCheck = UIUtils.createCheckbox((Composite)navigatorGroup, (String)UINavigatorMessages.pref_page_database_general_label_color_all_nodes, (String)UINavigatorMessages.pref_page_database_general_label_color_all_nodes_tip, (boolean)false, (int)2);
        this.showObjectTipsCheck = UIUtils.createCheckbox((Composite)navigatorGroup, (String)UINavigatorMessages.pref_page_database_general_label_show_tips_in_tree, (String)UINavigatorMessages.pref_page_database_general_label_show_tips_in_tree_tip, (boolean)false, (int)2);
        this.showToolTipsCheck = UIUtils.createCheckbox((Composite)navigatorGroup, (String)UINavigatorMessages.pref_page_database_general_label_show_tooltips, (String)UINavigatorMessages.pref_page_database_general_label_show_tooltips_tip, (boolean)false, (int)2);
        this.showContentsInToolTipsContents = UIUtils.createCheckbox((Composite)navigatorGroup, (String)UINavigatorMessages.pref_page_database_general_label_show_contents_in_tooltips, (String)UINavigatorMessages.pref_page_database_general_label_show_contents_in_tooltips_tip, (boolean)false, (int)2);
        Group behaviorGroup = UIUtils.createControlGroup((Composite)composite, (String)UINavigatorMessages.pref_page_database_navigator_group_behavior, (int)2, (int)2, (int)0);
        this.objDoubleClickBehavior = UIUtils.createLabelCombo((Composite)behaviorGroup, (String)UINavigatorMessages.pref_page_database_general_label_double_click_node, (int)12);
        this.objDoubleClickBehavior.add(UINavigatorMessages.pref_page_database_general_label_double_click_node_open_properties, 0);
        this.objDoubleClickBehavior.add(UINavigatorMessages.pref_page_database_general_label_double_click_node_expand_collapse, 1);
        this.dsDoubleClickBehavior = UIUtils.createLabelCombo((Composite)behaviorGroup, (String)UINavigatorMessages.pref_page_database_general_label_double_click_connection, (int)12);
        this.dsDoubleClickBehavior.add(UINavigatorMessages.pref_page_database_general_label_double_click_connection_open_properties, NavigatorPreferences.DoubleClickBehavior.EDIT.ordinal());
        this.dsDoubleClickBehavior.add(UINavigatorMessages.pref_page_database_general_label_double_click_connection_conn_disconn, NavigatorPreferences.DoubleClickBehavior.CONNECT.ordinal());
        this.dsDoubleClickBehavior.add(UINavigatorMessages.pref_page_database_general_label_double_click_connection_open_sqleditor, NavigatorPreferences.DoubleClickBehavior.SQL_EDITOR.ordinal());
        this.dsDoubleClickBehavior.add(UINavigatorMessages.pref_page_database_general_label_double_click_connection_expand_collapse, NavigatorPreferences.DoubleClickBehavior.EXPAND.ordinal());
        this.dsDoubleClickBehavior.add(UINavigatorMessages.pref_page_database_general_label_double_click_connection_open_new_sqleditor, NavigatorPreferences.DoubleClickBehavior.SQL_EDITOR_NEW.ordinal());
        this.defaultEditorPageCombo = UIUtils.createLabelCombo((Composite)behaviorGroup, (String)UINavigatorMessages.pref_page_navigator_default_editor_page_label, (String)UINavigatorMessages.pref_page_navigator_default_editor_page_tip, (int)12);
        Group miscGroup = UIUtils.createControlGroup((Composite)composite, (String)UINavigatorMessages.pref_page_database_navigator_group_misc, (int)2, (int)2, (int)0);
        this.expandOnConnectCheck = UIUtils.createCheckbox((Composite)miscGroup, (String)UINavigatorMessages.pref_page_database_general_label_expand_navigator_tree, (String)"", (boolean)false, (int)2);
        this.longListFetchSizeText = UIUtils.createLabelText((Composite)miscGroup, (String)UINavigatorMessages.pref_page_database_general_label_long_list_fetch_size, (String)"", (int)2048);
        this.longListFetchSizeText.setToolTipText(UINavigatorMessages.pref_page_database_general_label_long_list_fetch_size_tip);
        this.longListFetchSizeText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.restoreStateDepthText = UIUtils.createLabelText((Composite)miscGroup, (String)UINavigatorMessages.pref_page_database_general_label_restore_state_depth, (String)"", (int)2048);
        this.restoreStateDepthText.setToolTipText(UINavigatorMessages.pref_page_database_general_label_restore_state_depth_tip);
        this.restoreStateDepthText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.getDefault()));
        this.performDefaults();
        return composite;
    }

    protected void performDefaults() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        this.expandOnConnectCheck.setSelection(store.getBoolean("navigator.expand.on.connect"));
        this.restoreStateDepthText.setText(store.getString("navigator.restore.state.depth"));
        this.showObjectTipsCheck.setSelection(store.getBoolean("navigator.show.objects.tips"));
        this.showToolTipsCheck.setSelection(store.getBoolean("navigator.show.tooltips"));
        this.showContentsInToolTipsContents.setSelection(store.getBoolean("navigator.show.tooltips.file.contents"));
        this.sortCaseInsensitiveCheck.setSelection(store.getBoolean("navigator.sort.case.insensitive"));
        this.sortFoldersFirstCheck.setSelection(store.getBoolean("navigator.sort.forlers.first"));
        this.showConnectionHostCheck.setSelection(store.getBoolean("navigator.show.connection.host"));
        this.showStatisticsCheck.setSelection(store.getBoolean("navigator.show.statistics.info"));
        this.showNodeActionsCheck.setSelection(store.getBoolean("navigator.show.node.actions"));
        this.colorAllNodesCheck.setSelection(store.getBoolean("navigator.color.nodes.all"));
        this.showResourceFolderPlaceholdersCheck.setSelection(store.getBoolean("navigator.show.folder.placeholders"));
        this.groupByDriverCheck.setSelection(store.getBoolean("navigator.group.by.driver"));
        this.longListFetchSizeText.setText(store.getString("navigator.long.list.fetch.size"));
        NavigatorPreferences.DoubleClickBehavior objDCB = (NavigatorPreferences.DoubleClickBehavior)CommonUtils.valueOf(NavigatorPreferences.DoubleClickBehavior.class, (String)store.getString("navigator.object.doubleClick"));
        this.objDoubleClickBehavior.select(objDCB == NavigatorPreferences.DoubleClickBehavior.EXPAND ? 1 : 0);
        this.dsDoubleClickBehavior.select(((NavigatorPreferences.DoubleClickBehavior)CommonUtils.valueOf(NavigatorPreferences.DoubleClickBehavior.class, (String)store.getString("navigator.connection.doubleClick"), (Enum)NavigatorPreferences.DoubleClickBehavior.EDIT)).ordinal());
        String defEditorPage = store.getString("navigator.object.defaultEditorPage");
        List<EntityEditorDescriptor> entityEditors = this.getAvailableEditorPages();
        this.defaultEditorPageCombo.removeAll();
        this.defaultEditorPageCombo.add(UINavigatorMessages.pref_page_navigator_default_editor_page_last);
        this.defaultEditorPageCombo.select(0);
        for (EntityEditorDescriptor eed : entityEditors) {
            this.defaultEditorPageCombo.add(eed.getName());
            if (!eed.getId().equals(defEditorPage)) continue;
            this.defaultEditorPageCombo.select(this.defaultEditorPageCombo.getItemCount() - 1);
        }
    }

    public boolean performOk() {
        DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
        store.setValue("navigator.expand.on.connect", this.expandOnConnectCheck.getSelection());
        store.setValue("navigator.restore.state.depth", this.restoreStateDepthText.getText());
        store.setValue("navigator.show.objects.tips", this.showObjectTipsCheck.getSelection());
        store.setValue("navigator.show.tooltips", this.showToolTipsCheck.getSelection());
        store.setValue("navigator.show.tooltips.file.contents", this.showContentsInToolTipsContents.getSelection());
        store.setValue("navigator.sort.case.insensitive", this.sortCaseInsensitiveCheck.getSelection());
        store.setValue("navigator.sort.forlers.first", this.sortFoldersFirstCheck.getSelection());
        store.setValue("navigator.show.connection.host", this.showConnectionHostCheck.getSelection());
        store.setValue("navigator.show.statistics.info", this.showStatisticsCheck.getSelection());
        store.setValue("navigator.show.node.actions", this.showNodeActionsCheck.getSelection());
        store.setValue("navigator.color.nodes.all", this.colorAllNodesCheck.getSelection());
        store.setValue("navigator.show.folder.placeholders", this.showResourceFolderPlaceholdersCheck.getSelection());
        store.setValue("navigator.group.by.driver", this.groupByDriverCheck.getSelection());
        store.setValue("navigator.long.list.fetch.size", this.longListFetchSizeText.getText());
        NavigatorPreferences.DoubleClickBehavior objDCB = NavigatorPreferences.DoubleClickBehavior.EXPAND;
        if (this.objDoubleClickBehavior.getSelectionIndex() == 0) {
            objDCB = NavigatorPreferences.DoubleClickBehavior.EDIT;
        }
        store.setValue("navigator.object.doubleClick", objDCB.name());
        store.setValue("navigator.connection.doubleClick", ((NavigatorPreferences.DoubleClickBehavior)CommonUtils.fromOrdinal(NavigatorPreferences.DoubleClickBehavior.class, (int)this.dsDoubleClickBehavior.getSelectionIndex())).name());
        List<EntityEditorDescriptor> entityEditors = this.getAvailableEditorPages();
        int defEditorIndex = this.defaultEditorPageCombo.getSelectionIndex();
        store.setValue("navigator.object.defaultEditorPage", defEditorIndex <= 0 ? "" : entityEditors.get(defEditorIndex - 1).getId());
        PrefUtils.savePreferenceStore((DBPPreferenceStore)store);
        return true;
    }

    private List<EntityEditorDescriptor> getAvailableEditorPages() {
        EntityEditorsRegistry editorsRegistry = EntityEditorsRegistry.getInstance();
        ArrayList<EntityEditorDescriptor> editors = new ArrayList<EntityEditorDescriptor>(editorsRegistry.getEntityEditors());
        editors.removeIf(editor -> {
            if (editor.getType() != EntityEditorDescriptor.Type.editor) {
                return true;
            }
            AbstractDescriptor.ObjectType[] objectTypeArray = editor.getObjectTypes();
            int n = objectTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractDescriptor.ObjectType ot = objectTypeArray[n2];
                if (!(DBSDataContainer.class.getName().equals(ot.getImplName()) || DBSObjectContainer.class.getName().equals(ot.getImplName()) || DBSEntity.class.getName().equals(ot.getImplName()) || DBSTable.class.getName().equals(ot.getImplName()))) {
                    return true;
                }
                ++n2;
            }
            return false;
        });
        editors.sort(Comparator.comparing(editor -> {
            switch (editor.getPosition()) {
                case "additions_props": {
                    return -2;
                }
                case "additions_start": {
                    return -1;
                }
                case "additions_end": {
                    return 1;
                }
            }
            return 0;
        }));
        editors.add(0, editorsRegistry.getDefaultEditor());
        return editors;
    }

    public void applyData(Object data) {
        super.applyData(data);
    }

    @Nullable
    public IAdaptable getElement() {
        return null;
    }

    public void setElement(IAdaptable element) {
    }
}

