/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.Trace;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.Serializable;

public class DataQueueAttributes
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    private String authority_ = "*LIBCRTAUT";
    private String description_ = "";
    private int entryLength_ = 1000;
    private boolean FIFO_ = true;
    private boolean forceToAuxiliaryStorage_ = false;
    private int keyLength_ = 0;
    private boolean saveSenderInfo_ = false;
    private transient PropertyChangeSupport propertyChangeListeners_ = null;
    private transient VetoableChangeSupport vetoableChangeListeners_ = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding property change listener.");
        }
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        DataQueueAttributes dataQueueAttributes = this;
        synchronized (dataQueueAttributes) {
            if (this.propertyChangeListeners_ == null) {
                this.propertyChangeListeners_ = new PropertyChangeSupport(this);
            }
            this.propertyChangeListeners_.addPropertyChangeListener(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Adding vetoable change listener.");
        }
        if (vetoableChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        DataQueueAttributes dataQueueAttributes = this;
        synchronized (dataQueueAttributes) {
            if (this.vetoableChangeListeners_ == null) {
                this.vetoableChangeListeners_ = new VetoableChangeSupport(this);
            }
            this.vetoableChangeListeners_.addVetoableChangeListener(vetoableChangeListener);
        }
    }

    public String getAuthority() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting authority: " + this.authority_);
        }
        return this.authority_;
    }

    public String getDescription() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting description: " + this.description_);
        }
        return this.description_;
    }

    public int getEntryLength() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting max entry length:", this.entryLength_);
        }
        return this.entryLength_;
    }

    public int getKeyLength() {
        if (Trace.traceOn_) {
            Trace.log(1, "Getting key length:", this.keyLength_);
        }
        return this.keyLength_;
    }

    public boolean isFIFO() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if is FIFO:", this.FIFO_);
        }
        return this.FIFO_;
    }

    public boolean isForceToAuxiliaryStorage() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if force to auxiliary storage:", this.forceToAuxiliaryStorage_);
        }
        return this.forceToAuxiliaryStorage_;
    }

    public boolean isSaveSenderInfo() {
        if (Trace.traceOn_) {
            Trace.log(1, "Checking if save sender information:", this.saveSenderInfo_);
        }
        return this.saveSenderInfo_;
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing property change listener.");
        }
        if (propertyChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.propertyChangeListeners_ != null) {
            this.propertyChangeListeners_.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (Trace.traceOn_) {
            Trace.log(1, "Removing vetoable change listener.");
        }
        if (vetoableChangeListener == null) {
            Trace.log(2, "Parameter 'listener' is null.");
            throw new NullPointerException("listener");
        }
        if (this.vetoableChangeListeners_ != null) {
            this.vetoableChangeListeners_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void setAuthority(String string) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting authority: " + string);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'authority' is null.");
            throw new NullPointerException("authority");
        }
        if (!((string = string.toUpperCase().trim()).equals("*ALL") || string.equals("*CHANGE") || string.equals("*EXCLUDE") || string.equals("*USE") || string.equals("*LIBCRTAUT"))) {
            Trace.log(2, "Value of parameter 'authority' is not valid: " + string);
            throw new ExtendedIllegalArgumentException("authority (" + string + ")", 2);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.authority_ = string;
        } else {
            String string2 = this.authority_;
            String string3 = string;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("authority", string2, string3);
            }
            this.authority_ = string;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("authority", string2, string3);
            }
        }
    }

    public void setDescription(String string) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting description: " + string);
        }
        if (string == null) {
            Trace.log(2, "Parameter 'description' is null.");
            throw new NullPointerException("description");
        }
        if (string.length() > 50) {
            Trace.log(2, "Length of parameter 'description' is not valid: " + string);
            throw new ExtendedIllegalArgumentException("description (" + string + ")", 1);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.description_ = string;
        } else {
            String string2 = this.description_;
            String string3 = string;
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("description", string2, string3);
            }
            this.description_ = string;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("description", string2, string3);
            }
        }
    }

    public void setEntryLength(int n) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting max entry length:", n);
        }
        if (n < 1 || n > 64512) {
            Trace.log(2, "Value of parameter 'entryLength' is not valid:", n);
            throw new ExtendedIllegalArgumentException("entryLength (" + n + ")", 4);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.entryLength_ = n;
        } else {
            Integer n2 = new Integer(this.entryLength_);
            Integer n3 = new Integer(n);
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("entryLength", n2, n3);
            }
            this.entryLength_ = n;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("entryLength", n2, n3);
            }
        }
    }

    public void setFIFO(boolean bl) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting FIFO:", bl);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.FIFO_ = bl;
        } else {
            Boolean bl2 = new Boolean(this.FIFO_);
            Boolean bl3 = new Boolean(bl);
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("FIFO", bl2, bl3);
            }
            this.FIFO_ = bl;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("FIFO", bl2, bl3);
            }
        }
    }

    public void setForceToAuxiliaryStorage(boolean bl) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting force to auxiliary storage:", bl);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.forceToAuxiliaryStorage_ = bl;
        } else {
            Boolean bl2 = new Boolean(this.forceToAuxiliaryStorage_);
            Boolean bl3 = new Boolean(bl);
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("forceToAuxiliaryStorage", bl2, bl3);
            }
            this.forceToAuxiliaryStorage_ = bl;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("forceToAuxiliaryStorage", bl2, bl3);
            }
        }
    }

    public void setKeyLength(int n) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting key length:", n);
        }
        if (n < 1 || n > 256) {
            Trace.log(2, "Value of parameter 'keyLength' is not valid:", n);
            throw new ExtendedIllegalArgumentException("keyLength (" + n + ")", 4);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.keyLength_ = n;
        } else {
            Integer n2 = new Integer(this.keyLength_);
            Integer n3 = new Integer(n);
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("keyLength", n2, n3);
            }
            this.keyLength_ = n;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("keyLength", n2, n3);
            }
        }
    }

    public void setSaveSenderInfo(boolean bl) throws PropertyVetoException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting save sender information:", bl);
        }
        if (this.propertyChangeListeners_ == null && this.vetoableChangeListeners_ == null) {
            this.saveSenderInfo_ = bl;
        } else {
            Boolean bl2 = new Boolean(this.saveSenderInfo_);
            Boolean bl3 = new Boolean(bl);
            if (this.vetoableChangeListeners_ != null) {
                this.vetoableChangeListeners_.fireVetoableChange("saveSenderInfo", bl2, bl3);
            }
            this.saveSenderInfo_ = bl;
            if (this.propertyChangeListeners_ != null) {
                this.propertyChangeListeners_.firePropertyChange("saveSenderInfo", bl2, bl3);
            }
        }
    }
}

