/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.JDError;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;

class DBColumnDescriptorsDataFormat {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private byte[] baseColumnName_;
    private byte[] baseTableName_;
    private byte[] baseTableSchemaName_;
    private String columnLabel_;
    private int jobCCSID_;

    DBColumnDescriptorsDataFormat() {
    }

    DBColumnDescriptorsDataFormat(int n) {
        this.jobCCSID_ = n;
    }

    void overlay(byte[] byArray, int n, int n2) throws SQLException {
        while (n2 > 0) {
            int n3 = BinaryConverter.byteArrayToInt(byArray, n);
            short s = BinaryConverter.byteArrayToShort(byArray, n + 4);
            switch (s) {
                case 14592: {
                    this.baseColumnName_ = new byte[n3 - 6];
                    System.arraycopy(byArray, n + 6, this.baseColumnName_, 0, n3 - 6);
                    break;
                }
                case 14593: {
                    this.baseTableName_ = new byte[n3 - 6];
                    System.arraycopy(byArray, n + 6, this.baseTableName_, 0, n3 - 6);
                    break;
                }
                case 14594: {
                    int n4 = BinaryConverter.byteArrayToShort(byArray, n + 6);
                    if (n4 == -1) {
                        n4 = this.jobCCSID_;
                    }
                    try {
                        this.columnLabel_ = ConvTable.getTable(n4, null).byteArrayToString(byArray, n + 8, n3 - 8);
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        JDError.throwSQLException("HY000", unsupportedEncodingException);
                    }
                    break;
                }
                case 14596: {
                    this.baseTableSchemaName_ = new byte[n3 - 6];
                    System.arraycopy(byArray, n + 6, this.baseTableSchemaName_, 0, n3 - 6);
                }
            }
            n2 -= n3;
            n += n3;
        }
    }

    String getBaseColumnName(ConvTable convTable) {
        if (this.baseColumnName_ != null) {
            return convTable.byteArrayToString(this.baseColumnName_, 0, this.baseColumnName_.length);
        }
        return null;
    }

    String getBaseTableName(ConvTable convTable) {
        if (this.baseTableName_ != null) {
            return convTable.byteArrayToString(this.baseTableName_, 0, this.baseTableName_.length);
        }
        return null;
    }

    String getBaseTableSchemaName(ConvTable convTable) {
        if (this.baseTableSchemaName_ != null) {
            return convTable.byteArrayToString(this.baseTableSchemaName_, 0, this.baseTableSchemaName_.length);
        }
        return null;
    }

    String getColumnLabel(ConvTable convTable) {
        if (this.columnLabel_ != null) {
            return this.columnLabel_;
        }
        return null;
    }
}

