/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400JDBCArray;
import com.ibm.as400.access.AS400JDBCBlob;
import com.ibm.as400.access.AS400JDBCCallableStatement;
import com.ibm.as400.access.AS400JDBCClob;
import com.ibm.as400.access.AS400JDBCDatabaseMetaData;
import com.ibm.as400.access.AS400JDBCDriver;
import com.ibm.as400.access.AS400JDBCPreparedStatement;
import com.ibm.as400.access.AS400JDBCSavepoint;
import com.ibm.as400.access.AS400JDBCStatement;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.ClientAccessDataStream;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConvTable13488;
import com.ibm.as400.access.DBBaseRequestDS;
import com.ibm.as400.access.DBConcatenatedRequestDS;
import com.ibm.as400.access.DBDSPool;
import com.ibm.as400.access.DBDataStreamException;
import com.ibm.as400.access.DBReplyRequestedDS;
import com.ibm.as400.access.DBReplyServerAttributes;
import com.ibm.as400.access.DBSQLAttributesDS;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.JDDataSourceURL;
import com.ibm.as400.access.JDError;
import com.ibm.as400.access.JDLibraryList;
import com.ibm.as400.access.JDPackageManager;
import com.ibm.as400.access.JDProperties;
import com.ibm.as400.access.JDSQLStatement;
import com.ibm.as400.access.JDServerRow;
import com.ibm.as400.access.JDSortSequence;
import com.ibm.as400.access.JDTrace;
import com.ibm.as400.access.JDTransactionManager;
import com.ibm.as400.access.JDUtilities;
import com.ibm.as400.access.ServerTrace;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class AS400JDBCConnection
implements Connection {
    private static final boolean TESTING_THREAD_SAFETY = false;
    private static int DEBUG_COMM_TRACE_ = 0;
    private static final String CLIENT_FUNCTIONAL_LEVEL_ = "V7R1M01   ";
    private static final int DRDA_SCROLLABLE_CUTOFF_ = 129;
    private static final int DRDA_SCROLLABLE_MAX_ = 255;
    private static final int INITIAL_STATEMENT_TABLE_SIZE_ = 256;
    static final int UNICODE_CCSID_ = 13488;
    static final int MAX_STATEMENTS_ = 9999;
    private final boolean[] assigned_ = new boolean[9999];
    static final int DATA_COMPRESSION_NONE_ = 0;
    static final int DATA_COMPRESSION_OLD_ = 1;
    static final int DATA_COMPRESSION_RLE_ = 14386;
    private AS400ImplRemote as400_;
    private AS400 as400PublicClassObj_;
    private boolean cancelling_;
    private CancelLock cancelLock_ = new CancelLock();
    private String catalog_;
    boolean checkStatementHoldability_ = false;
    private boolean closing_;
    private boolean aborted_ = false;
    ConvTable converter_;
    private int dataCompression_ = -1;
    private JDDataSourceURL dataSourceUrl_;
    private boolean drda_;
    private String defaultSchema_;
    private boolean extendedFormats_;
    private Vector heldRequests_;
    private HeldRequestsLock heldRequestsLock_ = new HeldRequestsLock();
    private int holdability_ = -9999;
    private int id_;
    private AS400JDBCDatabaseMetaData metaData_;
    private JDPackageManager packageManager_;
    private JDProperties properties_;
    private boolean readOnly_;
    private AS400Server server_;
    private int serverFunctionalLevel_;
    private String serverJobIdentifier_ = null;
    private SQLWarning sqlWarning_;
    private Vector statements_;
    JDTransactionManager transactionManager_;
    static final ConvTable unicodeConverter_ = new ConvTable13488();
    ConvTable packageCCSID_Converter = null;
    int vrm_;
    private int correlationID_ = 0;
    private int traceServer_ = 0;
    private boolean databaseHostServerTrace_ = false;
    private boolean mustSpecifyForUpdate_ = true;
    private int statementCount_ = 0;
    private boolean thousandStatements_ = false;
    private String qaqqiniLibrary_ = null;
    int newAutoCommitSupport_ = 1;
    private boolean wrappedInsert_ = false;
    static final String applicationNamePropertyName_ = "ApplicationName";
    static final String clientUserPropertyName_ = "ClientUser";
    static final String clientHostnamePropertyName_ = "ClientHostname";
    static final String clientAccountingPropertyName_ = "ClientAccounting";
    static final String clientProgramIDPropertyName_ = "ClientProgramID";
    private String applicationName_ = "";
    private String clientUser_ = "";
    private String clientHostname_ = "";
    private String clientAccounting_ = "";
    private String clientProgramID_ = "";
    private int concurrentAccessResolution_ = 0;
    private boolean doUpdateDeleteBlocking_ = false;
    private int maximumBlockedInputRows_ = 32000;
    protected static final int QUERY_TIMEOUT_QQRYTIMLMT = 0;
    protected static final int QUERY_TIMEOUT_CANCEL = 1;
    private int queryTimeoutMechanism_ = 0;

    AS400JDBCConnection() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void cancel(int var1_1) throws SQLException {
        var2_2 = this.cancelLock_;
        synchronized (var2_2) {
            block22: {
                this.cancelling_ = true;
                var3_3 = null;
                try {
                    if (this.serverJobIdentifier_ != null && this.serverFunctionalLevel_ >= 5) {
                        if (JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "Cancelling statement " + var1_1);
                        }
                        var3_3 = new AS400JDBCConnection();
                        var3_3.setProperties(this.dataSourceUrl_, this.properties_, this.as400_, true);
                        var4_4 = null;
                        var5_5 = null;
                        try {
                            block21: {
                                try {
                                    var4_4 = DBDSPool.getDBSQLRequestDS(6168, this.id_, -2147483648, 0);
                                    var4_4.setJobIdentifier(this.serverJobIdentifier_, this.converter_);
                                    var5_5 = var3_3.sendAndReceive(var4_4);
                                    var6_6 = var5_5.getErrorClass();
                                    var7_8 = var5_5.getReturnCode();
                                    if (var6_6 == 0) break block21;
                                    JDError.throwSQLException(this, this.id_, var6_6, var7_8);
                                }
                                catch (DBDataStreamException var6_7) {
                                    JDError.throwSQLException((Object)this, "HY000", var6_7);
                                    var9_10 = null;
                                    if (var4_4 != null) {
                                        var4_4.returnToPool();
                                        var4_4 = null;
                                    }
                                    if (var5_5 == null) ** GOTO lbl57
                                    var5_5.returnToPool();
                                    var5_5 = null;
                                }
                            }
                            var9_9 = null;
                            if (var4_4 != null) {
                                var4_4.returnToPool();
                                var4_4 = null;
                            }
                            if (var5_5 == null) ** GOTO lbl57
                            var5_5.returnToPool();
                            var5_5 = null;
                        }
                        catch (Throwable var8_12) {
                            var9_11 = null;
                            if (var4_4 != null) {
                                var4_4.returnToPool();
                                var4_4 = null;
                            }
                            if (var5_5 != null) {
                                var5_5.returnToPool();
                                var5_5 = null;
                            }
                            throw var8_12;
                        }
                    } else if (JDTrace.isTraceOn()) {
                        JDTrace.logInformation(this, "Cancel of statement " + var1_1 + " requested, but is not supported by system");
                    }
lbl57:
                    // 7 sources

                    var11_13 = null;
                    if (var3_3 == null) break block22;
                }
                catch (Throwable var10_17) {
                    var11_14 = null;
                    if (var3_3 != null) {
                        try {
                            var3_3.close();
                        }
                        catch (Throwable var12_16) {
                            // empty catch block
                        }
                    }
                    this.cancelling_ = false;
                    this.cancelLock_.notifyAll();
                    throw var10_17;
                }
                try {
                    var3_3.close();
                    break block22;
                }
                catch (Throwable var12_15) {
                    // empty catch block
                }
                {
                }
            }
            this.cancelling_ = false;
            this.cancelLock_.notifyAll();
        }
    }

    void checkAccess(JDSQLStatement jDSQLStatement) throws SQLException {
        String string = this.properties_.getString(0);
        if (string.equalsIgnoreCase("read only") && !jDSQLStatement.isSelect()) {
            JDError.throwSQLException((Object)this, "42505");
        }
        if ((this.readOnly_ || string.equalsIgnoreCase("read call")) && !jDSQLStatement.isSelect() && !jDSQLStatement.isProcedureCall()) {
            JDError.throwSQLException((Object)this, "42505");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCancel() {
        CancelLock cancelLock = this.cancelLock_;
        synchronized (cancelLock) {
            while (this.cancelling_) {
                try {
                    this.cancelLock_.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private boolean checkHoldabilityConstants(int n) {
        return n == 1 || n == 2 || n == -9999;
    }

    void checkOpen() throws SQLException {
        if (this.aborted_ || this.server_ == null) {
            JDError.throwSQLException((Object)this, "08003");
        }
    }

    public void clearWarnings() throws SQLException {
        this.sqlWarning_ = null;
    }

    public void close() throws SQLException {
        if (this.closing_) {
            return;
        }
        this.closing_ = true;
        if (this.isClosed()) {
            return;
        }
        this.pseudoClose();
        if (this.server_ != null) {
            this.as400_.disconnectServer(this.server_);
            this.server_ = null;
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logClose(this);
        }
    }

    void handleAbort() {
        try {
            this.cancel(0);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.closing_ = true;
        try {
            this.pseudoClose();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (this.server_ != null) {
            this.as400_.disconnectServer(this.server_);
            this.server_ = null;
        }
    }

    public void commit() throws SQLException {
        this.checkOpen();
        if (!this.transactionManager_.isLocalTransaction()) {
            JDError.throwSQLException((Object)this, "25000");
        }
        if (this.transactionManager_.getAutoCommit() && this.properties_.getBoolean(75)) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        this.transactionManager_.commit();
        if (this.transactionManager_.getHoldIndicator() == 0 || this.checkStatementHoldability_ && this.getVRM() >= JDUtilities.vrm520) {
            this.markCursorsClosed(false);
        }
        if (!this.getAutoCommit() && this.properties_.getBoolean(63)) {
            this.markStatementsClosed();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "Transaction commit");
        }
    }

    void setCheckStatementHoldability(boolean bl) {
        this.checkStatementHoldability_ = bl;
    }

    private int correctResultSetType(int n, int n2) throws SQLException {
        int n3 = n2 == 1008 ? 1005 : 1004;
        this.postWarning(JDError.getSQLWarning("01S02"));
        return n3;
    }

    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, this.getInternalHoldability());
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        return this.createStatement(n, n2, this.getInternalHoldability());
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        int n4;
        this.checkOpen();
        if (!this.metaData_.supportsResultSetConcurrency(n, n2)) {
            n = this.correctResultSetType(n, n2);
        }
        if (!this.checkHoldabilityConstants(n3)) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        int n5 = this.getUnusedId(n);
        AS400JDBCStatement aS400JDBCStatement = new AS400JDBCStatement(this, n5, this.transactionManager_, this.packageManager_, this.properties_.getString(2), this.properties_.getInt(1), this.properties_.getBoolean(17), this.properties_.getString(30), n, n2, n3, -9999);
        this.statements_.addElement(aS400JDBCStatement);
        ++this.statementCount_;
        if (!this.thousandStatements_ && this.statementCount_ == 1000) {
            this.thousandStatements_ = true;
            this.postWarning(JDError.getSQLWarning("01G00"));
        }
        if (JDTrace.isTraceOn() && (n4 = this.statements_.size()) % 256 == 0) {
            JDTrace.logInformation(this, "Warning: Open handle count now: " + n4);
        }
        return aS400JDBCStatement;
    }

    private void debug(DBBaseRequestDS dBBaseRequestDS) {
        if (DEBUG_COMM_TRACE_ >= 1) {
            System.out.println("Server request: " + Integer.toString(dBBaseRequestDS.getServerID(), 16).toUpperCase() + ":" + Integer.toString(dBBaseRequestDS.getReqRepID(), 16).toUpperCase() + ".");
        }
        if (DEBUG_COMM_TRACE_ >= 2) {
            dBBaseRequestDS.dump(System.out);
        }
    }

    private void debug(DBReplyRequestedDS dBReplyRequestedDS) {
        if (DEBUG_COMM_TRACE_ >= 1) {
            System.out.println("Server reply:   " + Integer.toString(dBReplyRequestedDS.getServerID(), 16).toUpperCase() + ":" + Integer.toString(dBReplyRequestedDS.getReturnDataFunctionId(), 16).toUpperCase() + ".");
        }
        if (DEBUG_COMM_TRACE_ >= 2) {
            dBReplyRequestedDS.dump(System.out);
        }
        if (DEBUG_COMM_TRACE_ >= 1) {
            int n = dBReplyRequestedDS.getReturnCode();
            int n2 = dBReplyRequestedDS.getErrorClass();
            if (n2 != 0 || n != 0) {
                System.out.println("Server error = " + n2 + ":" + n + ".");
            }
        }
    }

    protected void finalize() throws Throwable {
        if (!this.isClosed()) {
            JDTrace.logInformation(this, "WARNING: Finalizer thread closing connection object.");
            this.close();
        }
        super.finalize();
    }

    AS400Impl getAS400() throws SQLException {
        return this.as400_;
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        return this.transactionManager_.getAutoCommit();
    }

    public String getCatalog() throws SQLException {
        this.checkOpen();
        return this.catalog_;
    }

    public int getConcurrentAccessResolution() {
        return this.concurrentAccessResolution_;
    }

    ConvTable getConverter(int n) throws SQLException {
        try {
            if (n == 0 || n == 1 || n == 65535 || n == -1) {
                return this.converter_;
            }
            return ConvTable.getTable(n, null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
            return null;
        }
    }

    int getDataCompression() {
        return this.dataCompression_;
    }

    String getDefaultSchema() throws SQLException {
        return this.defaultSchema_ == null ? "QGPL" : this.defaultSchema_;
    }

    String getDefaultSchema(boolean bl) throws SQLException {
        return bl || this.defaultSchema_ != null ? this.defaultSchema_ : "QGPL";
    }

    public int getHoldability() throws SQLException {
        this.checkOpen();
        if (this.holdability_ == 1 || this.holdability_ == 2) {
            return this.holdability_;
        }
        if (this.transactionManager_.getHoldIndicator() == 1) {
            return 1;
        }
        if (this.transactionManager_.getHoldIndicator() == 0) {
            return 2;
        }
        JDError.throwSQLException((Object)this, "HY000");
        return 1;
    }

    int getID() {
        return this.id_;
    }

    int getInternalHoldability() {
        return this.holdability_;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.metaData_;
    }

    JDProperties getProperties() throws SQLException {
        return this.properties_;
    }

    public String getServerJobIdentifier() {
        return this.serverJobIdentifier_;
    }

    int getServerFunctionalLevel() {
        return this.serverFunctionalLevel_;
    }

    public AS400 getSystem() {
        return this.as400PublicClassObj_;
    }

    public int getTransactionIsolation() throws SQLException {
        this.checkOpen();
        return this.transactionManager_.getIsolation();
    }

    JDTransactionManager getTransactionManager() {
        return this.transactionManager_;
    }

    public Map getTypeMap() throws SQLException {
        JDError.throwSQLException((Object)this, "IM001");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUnusedId(int n) throws SQLException {
        boolean[] blArray = this.assigned_;
        synchronized (this.assigned_) {
            if (this.drda_) {
                if (n == 1003) {
                    for (int i = 1; i < 129; ++i) {
                        if (this.assigned_[i]) continue;
                        this.assigned_[i] = true;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return i;
                    }
                } else {
                    for (int i = 129; i < 255; ++i) {
                        if (this.assigned_[i]) continue;
                        this.assigned_[i] = true;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return i;
                    }
                }
            } else {
                for (int i = 1; i < 9999; ++i) {
                    if (this.assigned_[i]) continue;
                    this.assigned_[i] = true;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return i;
                }
            }
            JDError.throwSQLException((Object)this, "HY014");
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return -1;
        }
    }

    boolean getMustSpecifyForUpdate() {
        return this.mustSpecifyForUpdate_;
    }

    String getURL() throws SQLException {
        return this.dataSourceUrl_.toString();
    }

    String getUserName() throws SQLException {
        return this.as400_.getUserId();
    }

    int getVRM() throws SQLException {
        return this.vrm_;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.sqlWarning_;
    }

    boolean isCursorNameUsed(String string) throws SQLException {
        Vector vector = (Vector)this.statements_.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            try {
                if (!((AS400JDBCStatement)enumeration.nextElement()).getCursorName().equalsIgnoreCase(string)) continue;
                return true;
            }
            catch (Exception exception) {
                if (!JDTrace.isTraceOn()) continue;
                JDTrace.logException(this, "isCursorNameUsed caught exception", exception);
            }
        }
        return false;
    }

    public boolean isClosed() throws SQLException {
        if (this.aborted_) {
            return true;
        }
        if (this.server_ == null) {
            return true;
        }
        if (!this.server_.isConnected()) {
            this.server_ = null;
            return true;
        }
        return false;
    }

    public boolean isReadOnly() throws SQLException {
        this.checkOpen();
        return this.readOnly_ || this.isReadOnlyAccordingToProperties();
    }

    boolean isReadOnlyAccordingToProperties() throws SQLException {
        this.checkOpen();
        return this.properties_.getString(0).equalsIgnoreCase("read only") || this.properties_.getString(0).equalsIgnoreCase("read call");
    }

    void markCursorsClosed(boolean bl) throws SQLException {
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "Testing to see if cursors should be held.");
        }
        Vector vector = (Vector)this.statements_.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            AS400JDBCStatement aS400JDBCStatement = (AS400JDBCStatement)enumeration.nextElement();
            try {
                if (aS400JDBCStatement.isHoldStatement()) continue;
                aS400JDBCStatement.markCursorClosed(bl);
            }
            catch (SQLException sQLException) {
                if (!JDTrace.isTraceOn()) continue;
                JDTrace.logException(this, "markCursorsClosed caught exception", sQLException);
            }
        }
    }

    private void markStatementsClosed() {
        if (!this.statements_.isEmpty()) {
            Vector vector = (Vector)this.statements_.clone();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                AS400JDBCStatement aS400JDBCStatement = (AS400JDBCStatement)enumeration.nextElement();
                try {
                    if (!aS400JDBCStatement.isHoldStatement()) continue;
                    aS400JDBCStatement.setAssociatedWithLocators(false);
                    aS400JDBCStatement.finishClosing();
                }
                catch (SQLException sQLException) {
                    if (!JDTrace.isTraceOn()) continue;
                    JDTrace.logInformation(this, "Closing statement after rollback failed: " + sQLException.getMessage());
                }
            }
        }
    }

    String makeGeneratedKeySelectStatement(String string, int[] nArray, String[] stringArray) throws SQLException {
        StringBuffer stringBuffer;
        if (nArray != null) {
            if (nArray.length == 0) {
                JDError.throwSQLException("HY024");
            }
            stringBuffer = new StringBuffer("SELECT * FROM NEW TABLE(");
            stringBuffer.append(string);
            stringBuffer.append(")");
            PreparedStatement preparedStatement = this.prepareStatement(stringBuffer.toString());
            JDServerRow jDServerRow = ((AS400JDBCPreparedStatement)preparedStatement).getResultRow();
            stringArray = new String[nArray.length];
            try {
                for (int i = 0; i < nArray.length; ++i) {
                    stringArray[i] = jDServerRow.getFieldName(nArray[i]);
                }
            }
            catch (SQLException sQLException) {
                preparedStatement.close();
                JDError.throwSQLException("HY024");
            }
            preparedStatement.close();
        }
        if (stringArray == null || stringArray.length == 0) {
            JDError.throwSQLException("HY024");
            return "";
        }
        stringBuffer = new StringBuffer("SELECT " + stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuffer.append(",");
            stringBuffer.append(stringArray[i]);
        }
        stringBuffer.append(" FROM NEW TABLE(");
        stringBuffer.append(string);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    String makeGeneratedKeySelectStatement(String string) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("SELECT *SQLGENCOLUMNS FROM NEW TABLE(");
        stringBuffer.append(string);
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public String nativeSQL(String string) throws SQLException {
        JDSQLStatement jDSQLStatement = new JDSQLStatement(string, this.properties_.getString(5), true, this.properties_.getString(30), this);
        return jDSQLStatement.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyClose(AS400JDBCStatement aS400JDBCStatement, int n) throws SQLException {
        this.statements_.removeElement(aS400JDBCStatement);
        --this.statementCount_;
        boolean[] blArray = this.assigned_;
        synchronized (this.assigned_) {
            this.assigned_[n] = false;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    void postWarning(SQLWarning sQLWarning) throws SQLException {
        if (this.sqlWarning_ == null) {
            this.sqlWarning_ = sQLWarning;
        } else {
            this.sqlWarning_.setNextWarning(sQLWarning);
        }
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, 1003, 1007, this.getInternalHoldability());
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        return this.prepareCall(string, n, n2, this.getInternalHoldability());
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        int n4;
        this.checkOpen();
        if (!this.metaData_.supportsResultSetConcurrency(n, n2)) {
            n = this.correctResultSetType(n, n2);
        }
        if (!this.checkHoldabilityConstants(n3)) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        JDSQLStatement jDSQLStatement = new JDSQLStatement(string, this.properties_.getString(5), true, this.properties_.getString(30), this);
        int n5 = this.getUnusedId(n);
        AS400JDBCCallableStatement aS400JDBCCallableStatement = new AS400JDBCCallableStatement(this, n5, this.transactionManager_, this.packageManager_, this.properties_.getString(2), this.properties_.getInt(1), jDSQLStatement, this.properties_.getString(30), n, n2, n3, -9999);
        this.statements_.addElement(aS400JDBCCallableStatement);
        ++this.statementCount_;
        if (!this.thousandStatements_ && this.statementCount_ == 1000) {
            this.thousandStatements_ = true;
            this.postWarning(JDError.getSQLWarning("01G00"));
        }
        if (JDTrace.isTraceOn() && (n4 = this.statements_.size()) % 256 == 0) {
            JDTrace.logInformation(this, "Warning: Open handle count now: " + n4);
        }
        return aS400JDBCCallableStatement;
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007, this.getInternalHoldability());
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        int n2;
        if (this.getVRM() < JDUtilities.vrm520) {
            JDError.throwSQLException((Object)this, "IM001");
        }
        this.checkOpen();
        JDSQLStatement jDSQLStatement = new JDSQLStatement(string, this.properties_.getString(5), true, this.properties_.getString(30), this);
        if (this.getVRM() >= JDUtilities.vrm610 && n == 1 && jDSQLStatement.isInsert_) {
            String string2 = this.makeGeneratedKeySelectStatement(string);
            jDSQLStatement = new JDSQLStatement(string2, this.properties_.getString(5), true, this.properties_.getString(30), this);
            this.wrappedInsert_ = true;
        }
        int n3 = this.getUnusedId(1003);
        if (this.wrappedInsert_) {
            jDSQLStatement.setSelectFromInsert(true);
            this.wrappedInsert_ = false;
        }
        AS400JDBCPreparedStatement aS400JDBCPreparedStatement = new AS400JDBCPreparedStatement(this, n3, this.transactionManager_, this.packageManager_, this.properties_.getString(2), this.properties_.getInt(1), this.properties_.getBoolean(17), jDSQLStatement, false, this.properties_.getString(30), 1003, 1007, this.getInternalHoldability(), n);
        this.statements_.addElement(aS400JDBCPreparedStatement);
        ++this.statementCount_;
        if (!this.thousandStatements_ && this.statementCount_ == 1000) {
            this.thousandStatements_ = true;
            this.postWarning(JDError.getSQLWarning("01G00"));
        }
        if (JDTrace.isTraceOn() && (n2 = this.statements_.size()) % 256 == 0) {
            JDTrace.logInformation(this, "Warning: Open handle count now: " + n2);
        }
        return aS400JDBCPreparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return this.prepareStatement(string, n, n2, this.getInternalHoldability());
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        int n4;
        this.checkOpen();
        if (!this.metaData_.supportsResultSetConcurrency(n, n2)) {
            n = this.correctResultSetType(n, n2);
        }
        if (!this.checkHoldabilityConstants(n3)) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        JDSQLStatement jDSQLStatement = new JDSQLStatement(string, this.properties_.getString(5), true, this.properties_.getString(30), this);
        int n5 = this.getUnusedId(n);
        AS400JDBCPreparedStatement aS400JDBCPreparedStatement = new AS400JDBCPreparedStatement(this, n5, this.transactionManager_, this.packageManager_, this.properties_.getString(2), this.properties_.getInt(1), this.properties_.getBoolean(17), jDSQLStatement, false, this.properties_.getString(30), n, n2, n3, -9999);
        this.statements_.addElement(aS400JDBCPreparedStatement);
        ++this.statementCount_;
        if (!this.thousandStatements_ && this.statementCount_ == 1000) {
            this.thousandStatements_ = true;
            this.postWarning(JDError.getSQLWarning("01G00"));
        }
        if (JDTrace.isTraceOn() && (n4 = this.statements_.size()) % 256 == 0) {
            JDTrace.logInformation(this, "Warning: Open handle count now: " + n4);
        }
        return aS400JDBCPreparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        if (this.getVRM() >= JDUtilities.vrm610) {
            this.checkOpen();
            JDSQLStatement jDSQLStatement = new JDSQLStatement(string, this.properties_.getString(5), true, this.properties_.getString(30), this);
            if (jDSQLStatement.isInsert_) {
                this.wrappedInsert_ = true;
                return this.prepareStatement(this.makeGeneratedKeySelectStatement(string, nArray, null), 1);
            }
            return this.prepareStatement(string);
        }
        JDError.throwSQLException((Object)this, "IM001");
        return null;
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        if (this.getVRM() >= JDUtilities.vrm610) {
            this.checkOpen();
            JDSQLStatement jDSQLStatement = new JDSQLStatement(string, this.properties_.getString(5), true, this.properties_.getString(30), this);
            if (jDSQLStatement.isInsert_) {
                this.wrappedInsert_ = true;
                return this.prepareStatement(this.makeGeneratedKeySelectStatement(string, null, stringArray), 1);
            }
            return this.prepareStatement(string);
        }
        JDError.throwSQLException((Object)this, "IM001");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processSavepointRequest(String string) throws SQLException {
        if (this.vrm_ < JDUtilities.vrm520) {
            JDError.throwSQLException((Object)this, "IM001");
        }
        if (!this.transactionManager_.isLocalTransaction()) {
            JDError.throwSQLException((Object)this, "25000");
        }
        if (this.getAutoCommit()) {
            JDError.throwSQLException((Object)this, "25000");
        }
        Statement statement = null;
        try {
            statement = this.createStatement();
            statement.executeUpdate(string);
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    void pseudoClose() throws SQLException {
        Object object;
        if (this.transactionManager_.isLocalTransaction() && this.transactionManager_.isLocalActive()) {
            this.rollback();
        }
        Vector vector = (Vector)this.statements_.clone();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (AS400JDBCStatement)enumeration.nextElement();
            try {
                if (((AS400JDBCStatement)object).isHoldStatement()) {
                    ((AS400JDBCStatement)object).setAssociatedWithLocators(false);
                    ((AS400JDBCStatement)object).finishClosing();
                }
                if (((AS400JDBCStatement)object).isClosed()) continue;
                ((AS400JDBCStatement)object).close();
            }
            catch (SQLException sQLException) {
                if (!JDTrace.isTraceOn()) continue;
                JDTrace.logInformation(this, "Closing statement while closing connection failed: " + sQLException.getMessage());
            }
        }
        if (this.traceServer_ > 0 || this.databaseHostServerTrace_) {
            object = this.getServerJobIdentifier();
            boolean bl = true;
            boolean bl2 = this.properties_.getString(9).equals("sql");
            try {
                bl = this.getVRM() <= JDUtilities.vrm450;
            }
            catch (Exception exception) {
                JDTrace.logDataEvenIfTracingIsOff(this, "Attempt to end server job tracing failed, could not get server VRM");
            }
            boolean bl3 = false;
            if ((this.traceServer_ & 0x10) > 0) {
                try {
                    if (bl) {
                        JDUtilities.runCommand(this, "QSYS/TRCJOB SET(*OFF) OUTPUT(*PRINT)", bl2);
                    } else {
                        JDUtilities.runCommand(this, "QSYS/ENDTRC SSNID(QJT" + ((String)object).substring(20) + ") DTAOPT(*LIB) DTALIB(QUSRSYS) RPLDTA(*YES) PRTTRC(*YES)", bl2);
                        JDUtilities.runCommand(this, "QSYS/DLTTRC DTAMBR(QJT" + ((String)object).substring(20) + ") DTALIB(QUSRSYS)", bl2);
                    }
                    bl3 = true;
                }
                catch (Exception exception) {
                    JDTrace.logDataEvenIfTracingIsOff(this, "Attempt to end server job tracing failed");
                }
            }
            if (this.getVRM() >= JDUtilities.vrm530 && !bl3 && ((this.traceServer_ & 0x40) > 0 || this.databaseHostServerTrace_)) {
                try {
                    JDUtilities.runCommand(this, "QSYS/ENDTRC SSNID(QJT" + ((String)object).substring(20) + ") DTAOPT(*LIB) DTALIB(QUSRSYS) RPLDTA(*YES) PRTTRC(*YES)", bl2);
                    JDUtilities.runCommand(this, "QSYS/DLTTRC DTAMBR(QJT" + ((String)object).substring(20) + ") DTALIB(QUSRSYS)", bl2);
                }
                catch (Exception exception) {
                    JDTrace.logDataEvenIfTracingIsOff(this, "Attempt to end database host server tracing failed.");
                }
            }
            if ((this.traceServer_ & 4) > 0) {
                try {
                    JDUtilities.runCommand(this, "QSYS/ENDDBG", bl2);
                }
                catch (Exception exception) {
                    JDTrace.logDataEvenIfTracingIsOff(this, "Attempt to end server job tracing failed, could not end debug on server job ");
                }
            }
            if ((this.traceServer_ & 2) > 0) {
                try {
                    JDUtilities.runCommand(this, "QSYS/ENDDBMON", bl2);
                }
                catch (Exception exception) {
                    JDTrace.logDataEvenIfTracingIsOff(this, "Attempt to end server job tracing failed, could not end database monitor");
                }
            }
            if ((this.traceServer_ & 0x20) > 0 && !bl) {
                try {
                    JDUtilities.runCommand(this, "QSYS/PRTSQLINF *JOB", bl2);
                }
                catch (Exception exception) {
                    JDTrace.logDataEvenIfTracingIsOff(this, "Attempt to end server job tracing failed, could not print SQL information");
                }
            }
            if ((this.traceServer_ & 8) > 0) {
                try {
                    JDUtilities.runCommand(this, "QSYS/DSPJOBLOG JOB(*) OUTPUT(*PRINT)", bl2);
                }
                catch (Exception exception) {
                    JDTrace.logDataEvenIfTracingIsOff(this, "Attempt to end server job tracing failed, could not save job log");
                }
            }
            if ((this.traceServer_ & 1) > 0) {
                JDTrace.setTraceOn(false);
            }
        }
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (savepoint == null) {
            throw new NullPointerException("savepoint");
        }
        AS400JDBCSavepoint aS400JDBCSavepoint = (AS400JDBCSavepoint)savepoint;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "Releasing savepoint " + aS400JDBCSavepoint.getName());
        }
        if (aS400JDBCSavepoint.getStatus() != 1) {
            JDError.throwSQLException((Object)this, "3B502");
        }
        String string = "RELEASE SAVEPOINT " + aS400JDBCSavepoint.getName();
        this.processSavepointRequest(string);
        aS400JDBCSavepoint.setStatus(2);
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "Savepoint " + aS400JDBCSavepoint.getName() + " released.");
        }
    }

    public void rollback() throws SQLException {
        this.checkOpen();
        if (!this.transactionManager_.isLocalTransaction()) {
            JDError.throwSQLException((Object)this, "25000");
        }
        if (this.transactionManager_.getAutoCommit() && this.properties_.getBoolean(75)) {
            JDError.throwSQLException((Object)this, "HY010");
        }
        if (!this.transactionManager_.getAutoCommit()) {
            this.transactionManager_.rollback();
            this.markCursorsClosed(true);
            if (this.properties_.getBoolean(63)) {
                this.markStatementsClosed();
            }
            if (JDTrace.isTraceOn()) {
                JDTrace.logInformation(this, "Transaction rollback");
            }
        }
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        if (savepoint == null) {
            throw new NullPointerException("savepoint");
        }
        AS400JDBCSavepoint aS400JDBCSavepoint = (AS400JDBCSavepoint)savepoint;
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "Rollback with savepoint " + aS400JDBCSavepoint.getName());
        }
        if (aS400JDBCSavepoint.getStatus() != 1) {
            JDError.throwSQLException((Object)this, "3B502");
        }
        String string = "ROLLBACK TO SAVEPOINT " + aS400JDBCSavepoint.getName();
        this.processSavepointRequest(string);
        aS400JDBCSavepoint.setStatus(2);
        if (this.properties_.getBoolean(63)) {
            this.markStatementsClosed();
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation(this, "Rollback with savepoint " + aS400JDBCSavepoint.getName() + " complete.");
        }
    }

    void send(DBBaseRequestDS dBBaseRequestDS) throws SQLException {
        this.send(dBBaseRequestDS, this.id_, true);
    }

    void send(DBBaseRequestDS dBBaseRequestDS, int n) throws SQLException {
        this.send(dBBaseRequestDS, n, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void send(DBBaseRequestDS dBBaseRequestDS, int n, boolean bl) throws SQLException {
        this.checkCancel();
        this.checkOpen();
        try {
            if (JDTrace.isTraceOn() && dBBaseRequestDS.getOperationResultBitmap() != 0) {
                JDTrace.logInformation(this, "Reply requested but not collected:" + dBBaseRequestDS.getReqRepID());
            }
            dBBaseRequestDS.setBasedOnORSHandle(0);
            if (this.dataCompression_ == 14386) {
                dBBaseRequestDS.addOperationResultBitmap(524288);
                dBBaseRequestDS.addOperationResultBitmap(262144);
                dBBaseRequestDS.compress();
            }
            HeldRequestsLock heldRequestsLock = this.heldRequestsLock_;
            synchronized (heldRequestsLock) {
                ClientAccessDataStream clientAccessDataStream = this.heldRequests_ != null ? new DBConcatenatedRequestDS(this.heldRequests_, dBBaseRequestDS) : dBBaseRequestDS;
                this.heldRequests_ = null;
                this.server_.send(clientAccessDataStream);
            }
            if (DEBUG_COMM_TRACE_ > 0) {
                this.debug(dBBaseRequestDS);
            }
        }
        catch (IOException iOException) {
            this.server_ = null;
            JDError.throwSQLException((Object)this, "08S01", iOException);
        }
        catch (Exception exception) {
            JDError.throwSQLException((Object)this, "HY000", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendAndHold(DBBaseRequestDS dBBaseRequestDS, int n) throws SQLException {
        this.checkCancel();
        this.checkOpen();
        try {
            if (JDTrace.isTraceOn() && dBBaseRequestDS.getOperationResultBitmap() != 0) {
                JDTrace.logInformation(this, "Reply requested but not collected:" + dBBaseRequestDS.getReqRepID());
            }
            dBBaseRequestDS.setBasedOnORSHandle(0);
            if (this.dataCompression_ == 14386) {
                dBBaseRequestDS.addOperationResultBitmap(524288);
                dBBaseRequestDS.addOperationResultBitmap(262144);
                dBBaseRequestDS.compress();
            }
            HeldRequestsLock heldRequestsLock = this.heldRequestsLock_;
            synchronized (heldRequestsLock) {
                if (this.heldRequests_ == null) {
                    this.heldRequests_ = new Vector();
                }
                this.heldRequests_.addElement(dBBaseRequestDS);
            }
            if (DEBUG_COMM_TRACE_ > 0) {
                this.debug(dBBaseRequestDS);
                System.out.println("This request was HELD.");
            }
        }
        catch (Exception exception) {
            JDError.throwSQLException((Object)this, "HY000", exception);
        }
    }

    DBReplyRequestedDS sendAndReceive(DBBaseRequestDS dBBaseRequestDS) throws SQLException {
        return this.sendAndReceive(dBBaseRequestDS, this.id_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DBReplyRequestedDS sendAndReceive(DBBaseRequestDS dBBaseRequestDS, int n) throws SQLException {
        this.checkCancel();
        this.checkOpen();
        DBReplyRequestedDS dBReplyRequestedDS = null;
        try {
            dBBaseRequestDS.setBasedOnORSHandle(0);
            if (this.dataCompression_ == 14386) {
                dBBaseRequestDS.addOperationResultBitmap(524288);
                dBBaseRequestDS.addOperationResultBitmap(262144);
                dBBaseRequestDS.compress();
            }
            HeldRequestsLock heldRequestsLock = this.heldRequestsLock_;
            synchronized (heldRequestsLock) {
                ClientAccessDataStream clientAccessDataStream = this.heldRequests_ != null ? new DBConcatenatedRequestDS(this.heldRequests_, dBBaseRequestDS) : dBBaseRequestDS;
                this.heldRequests_ = null;
                dBReplyRequestedDS = (DBReplyRequestedDS)this.server_.sendAndReceive(clientAccessDataStream);
            }
            dBReplyRequestedDS.parse(this.dataCompression_);
            if (DEBUG_COMM_TRACE_ > 0) {
                this.debug(dBBaseRequestDS);
                this.debug(dBReplyRequestedDS);
            }
        }
        catch (IOException iOException) {
            this.server_ = null;
            JDError.throwSQLException((Object)this, "08S01", iOException);
        }
        catch (Exception exception) {
            JDError.throwSQLException((Object)this, "HY000", exception);
        }
        return dBReplyRequestedDS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DBReplyRequestedDS sendAndMultiReceive(DBBaseRequestDS dBBaseRequestDS) throws SQLException {
        this.checkCancel();
        this.checkOpen();
        DBReplyRequestedDS dBReplyRequestedDS = null;
        try {
            dBBaseRequestDS.setBasedOnORSHandle(0);
            if (this.dataCompression_ == 14386) {
                dBBaseRequestDS.addOperationResultBitmap(524288);
                dBBaseRequestDS.addOperationResultBitmap(262144);
                dBBaseRequestDS.compress();
            }
            HeldRequestsLock heldRequestsLock = this.heldRequestsLock_;
            synchronized (heldRequestsLock) {
                ClientAccessDataStream clientAccessDataStream = this.heldRequests_ != null ? new DBConcatenatedRequestDS(this.heldRequests_, dBBaseRequestDS) : dBBaseRequestDS;
                this.heldRequests_ = null;
                this.correlationID_ = this.server_.send(clientAccessDataStream);
                dBReplyRequestedDS = (DBReplyRequestedDS)this.server_.receive(this.correlationID_);
            }
            dBReplyRequestedDS.parse(this.dataCompression_);
            if (DEBUG_COMM_TRACE_ > 0) {
                this.debug(dBBaseRequestDS);
                this.debug(dBReplyRequestedDS);
            }
        }
        catch (IOException iOException) {
            this.server_ = null;
            JDError.throwSQLException((Object)this, "08S01", iOException);
        }
        catch (Exception exception) {
            JDError.throwSQLException((Object)this, "HY000", exception);
        }
        return dBReplyRequestedDS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DBReplyRequestedDS receiveMoreData() throws SQLException {
        DBReplyRequestedDS dBReplyRequestedDS;
        block5: {
            dBReplyRequestedDS = null;
            try {
                if (this.correlationID_ <= 0) break block5;
                HeldRequestsLock heldRequestsLock = this.heldRequestsLock_;
                synchronized (heldRequestsLock) {
                    dBReplyRequestedDS = (DBReplyRequestedDS)this.server_.receive(this.correlationID_);
                }
                dBReplyRequestedDS.parse(this.dataCompression_);
            }
            catch (Exception exception) {
                JDError.throwSQLException((Object)this, "HY000", exception);
            }
        }
        return dBReplyRequestedDS;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        this.checkOpen();
        this.transactionManager_.setAutoCommit(bl);
        if (JDTrace.isTraceOn()) {
            JDTrace.logProperty((Object)this, "Auto commit", this.transactionManager_.getAutoCommit());
        }
    }

    public void setCatalog(String string) throws SQLException {
        this.checkOpen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConcurrentAccessResolution(int n) throws SQLException {
        DBBaseRequestDS dBBaseRequestDS = null;
        DBReplyRequestedDS dBReplyRequestedDS = null;
        try {
            block10: {
                try {
                    if (this.getVRM() < JDUtilities.vrm710) break block10;
                    dBBaseRequestDS = DBDSPool.getDBSQLAttributesDS(8064, this.id_, -2130706432, 0);
                    int n2 = this.properties_.getInt(79);
                    ((DBSQLAttributesDS)dBBaseRequestDS).setConcurrentAccessResolution(n2);
                    dBReplyRequestedDS = this.sendAndReceive(dBBaseRequestDS);
                    int n3 = dBReplyRequestedDS.getErrorClass();
                    if (n3 == 0) break block10;
                    JDError.throwSQLException(this, this.id_, n3, dBReplyRequestedDS.getReturnCode());
                }
                catch (Exception exception) {
                    JDError.throwSQLException((Object)this, "HY000", exception);
                    Object var7_8 = null;
                    if (dBBaseRequestDS != null) {
                        dBBaseRequestDS.returnToPool();
                        dBBaseRequestDS = null;
                    }
                    if (dBReplyRequestedDS != null) {
                        dBReplyRequestedDS.returnToPool();
                        dBReplyRequestedDS = null;
                    }
                }
            }
            Object var7_7 = null;
            if (dBBaseRequestDS != null) {
                dBBaseRequestDS.returnToPool();
                dBBaseRequestDS = null;
            }
            if (dBReplyRequestedDS != null) {
                dBReplyRequestedDS.returnToPool();
                dBReplyRequestedDS = null;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (dBBaseRequestDS != null) {
                dBBaseRequestDS.returnToPool();
                dBBaseRequestDS = null;
            }
            if (dBReplyRequestedDS != null) {
                dBReplyRequestedDS.returnToPool();
                dBReplyRequestedDS = null;
            }
            throw throwable;
        }
        this.concurrentAccessResolution_ = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDB2eWLMCorrelator(byte[] byArray) throws SQLException {
        if (this.vrm_ >= JDUtilities.vrm530) {
            DBBaseRequestDS dBBaseRequestDS = null;
            DBReplyRequestedDS dBReplyRequestedDS = null;
            try {
                block12: {
                    try {
                        if (byArray == null && JDTrace.isTraceOn()) {
                            JDTrace.logInformation(this, "Correlator is null");
                        }
                        dBBaseRequestDS = DBDSPool.getDBSQLAttributesDS(8064, this.id_, -2130706432, 0);
                        ((DBSQLAttributesDS)dBBaseRequestDS).seteWLMCorrelator(byArray);
                        dBReplyRequestedDS = this.sendAndReceive(dBBaseRequestDS);
                        int n = dBReplyRequestedDS.getErrorClass();
                        if (n == 0) break block12;
                        JDError.throwSQLException(this, this.id_, n, dBReplyRequestedDS.getReturnCode());
                    }
                    catch (DBDataStreamException dBDataStreamException) {
                        JDError.throwSQLException("HY000", dBDataStreamException);
                        Object var6_7 = null;
                        if (dBBaseRequestDS != null) {
                            dBBaseRequestDS.returnToPool();
                            dBBaseRequestDS = null;
                        }
                        if (dBReplyRequestedDS != null) {
                            dBReplyRequestedDS.returnToPool();
                            dBReplyRequestedDS = null;
                        }
                    }
                }
                Object var6_6 = null;
                if (dBBaseRequestDS != null) {
                    dBBaseRequestDS.returnToPool();
                    dBBaseRequestDS = null;
                }
                if (dBReplyRequestedDS != null) {
                    dBReplyRequestedDS.returnToPool();
                    dBReplyRequestedDS = null;
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (dBBaseRequestDS != null) {
                    dBBaseRequestDS.returnToPool();
                    dBBaseRequestDS = null;
                }
                if (dBReplyRequestedDS != null) {
                    dBReplyRequestedDS.returnToPool();
                    dBReplyRequestedDS = null;
                }
                throw throwable;
            }
        }
    }

    void setDRDA(boolean bl) throws SQLException {
        this.drda_ = bl;
        if (JDTrace.isTraceOn()) {
            JDTrace.logProperty((Object)this, "DRDA", this.drda_);
        }
    }

    public void setHoldability(int n) throws SQLException {
        this.checkOpen();
        if (!this.checkHoldabilityConstants(n)) {
            JDError.throwSQLException((Object)this, "HY024");
        }
        this.holdability_ = n;
        if (n == 2) {
            this.transactionManager_.setHoldIndicator("FALSE");
        } else if (n == 1) {
            this.transactionManager_.setHoldIndicator("TRUE");
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logProperty((Object)this, "Holdability", this.holdability_);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setProperties(JDDataSourceURL jDDataSourceURL, JDProperties jDProperties, AS400 aS400) throws SQLException {
        block14: {
            try {
                try {
                    aS400.connectService(4);
                }
                catch (AS400SecurityException aS400SecurityException) {
                    JDError.throwSQLException((Object)this, "08004", aS400SecurityException);
                    Object var6_5 = null;
                    Enumeration<Driver> enumeration2 = DriverManager.getDrivers();
                    Driver driver4 = null;
                    Driver driver5 = null;
                    while (enumeration2.hasMoreElements()) {
                        driver5 = enumeration2.nextElement();
                        if (!(driver5 instanceof AS400JDBCDriver)) continue;
                        if (driver4 == null) {
                            driver4 = driver5;
                            continue;
                        }
                        DriverManager.deregisterDriver(driver5);
                    }
                    break block14;
                }
                catch (IOException iOException) {
                    JDError.throwSQLException((Object)this, "08001", iOException);
                    Object var6_6 = null;
                    Enumeration<Driver> enumeration3 = DriverManager.getDrivers();
                    Driver driver6 = null;
                    Driver driver7 = null;
                    while (enumeration3.hasMoreElements()) {
                        driver7 = enumeration3.nextElement();
                        if (!(driver7 instanceof AS400JDBCDriver)) continue;
                        if (driver6 == null) {
                            driver6 = driver7;
                            continue;
                        }
                        DriverManager.deregisterDriver(driver7);
                    }
                    break block14;
                }
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                Enumeration<Driver> enumeration = DriverManager.getDrivers();
                Driver driver = null;
                Driver driver2 = null;
                while (true) {
                    if (!enumeration.hasMoreElements()) {
                        throw throwable;
                    }
                    driver2 = enumeration.nextElement();
                    if (!(driver2 instanceof AS400JDBCDriver)) continue;
                    if (driver == null) {
                        driver = driver2;
                        continue;
                    }
                    DriverManager.deregisterDriver(driver2);
                }
            }
            Enumeration<Driver> enumeration = DriverManager.getDrivers();
            Driver driver = null;
            Driver driver3 = null;
            while (enumeration.hasMoreElements()) {
                driver3 = enumeration.nextElement();
                if (!(driver3 instanceof AS400JDBCDriver)) continue;
                if (driver == null) {
                    driver = driver3;
                    continue;
                }
                DriverManager.deregisterDriver(driver3);
            }
        }
        this.setProperties(jDDataSourceURL, jDProperties, aS400.getImpl());
    }

    void setProperties(JDDataSourceURL jDDataSourceURL, JDProperties jDProperties, AS400Impl aS400Impl) throws SQLException {
        this.setProperties(jDDataSourceURL, jDProperties, aS400Impl, false);
    }

    void setProperties(JDDataSourceURL jDDataSourceURL, JDProperties jDProperties, AS400Impl aS400Impl, boolean bl) throws SQLException {
        String string;
        this.as400_ = (AS400ImplRemote)aS400Impl;
        this.dataSourceUrl_ = jDDataSourceURL;
        this.extendedFormats_ = false;
        this.properties_ = jDProperties;
        if (this.properties_.getString(72).equals("-1")) {
            if (this.as400_.getVRM() < JDUtilities.vrm710) {
                this.properties_.setString(72, "0");
            } else {
                this.properties_.setString(72, "1");
            }
        }
        this.statements_ = new Vector(256);
        this.newAutoCommitSupport_ = this.as400_.getVRM() <= JDUtilities.vrm520 ? 0 : (!this.properties_.getBoolean(59) ? 1 : 2);
        if (this.as400_.getVRM() >= JDUtilities.vrm710) {
            this.doUpdateDeleteBlocking_ = this.properties_.getBoolean(82);
        }
        this.maximumBlockedInputRows_ = this.properties_.getInt(83);
        if (this.maximumBlockedInputRows_ > 32000) {
            this.maximumBlockedInputRows_ = 32000;
        }
        if (this.maximumBlockedInputRows_ < 1) {
            this.maximumBlockedInputRows_ = 1;
        }
        if (this.dataSourceUrl_.isExtraPathSpecified()) {
            this.postWarning(JDError.getSQLWarning("01H10"));
        }
        if (this.dataSourceUrl_.isPortSpecified()) {
            this.postWarning(JDError.getSQLWarning("01H10"));
        }
        if (jDProperties.isExtraPropertySpecified()) {
            this.postWarning(JDError.getSQLWarning("01H20"));
        }
        if ((string = this.dataSourceUrl_.getSchema()) == null) {
            JDError.throwSQLException((Object)this, "01H13");
        }
        JDLibraryList jDLibraryList = new JDLibraryList(this.properties_.getString(8), string, this.properties_.getString(9));
        this.defaultSchema_ = jDLibraryList.getDefaultSchema();
        this.transactionManager_ = new JDTransactionManager(this, this.id_, this.properties_.getString(27), this.properties_.getBoolean(76));
        this.transactionManager_.setHoldIndicator(this.properties_.getString(39));
        if (this.properties_.getString(39) != null) {
            if (this.transactionManager_.getHoldIndicator() == 1) {
                this.holdability_ = 1;
            } else if (this.transactionManager_.getHoldIndicator() == 0) {
                this.holdability_ = 2;
            }
        }
        this.readOnly_ = this.properties_.equals(0, "read only");
        this.traceServer_ = this.properties_.getInt(46) | ServerTrace.getJDBCServerTraceCategories();
        this.qaqqiniLibrary_ = this.properties_.getString(57);
        String string2 = this.properties_.getString(84);
        if (string2 != null) {
            this.queryTimeoutMechanism_ = (string2 = string2.trim().toLowerCase()).equals("cancel") ? 1 : 0;
        }
        if (JDTrace.isTraceOn()) {
            JDTrace.logInformation("Toolbox for Java - Open Source Software, JTOpen 7.10, codebase 5770-SS1 V7R1M0.10 built=20130602 @I2");
            JDTrace.logInformation("JDBC Level: " + JDUtilities.JDBCLevel_);
        }
        try {
            this.server_ = this.as400_.getConnection(4, bl);
        }
        catch (AS400SecurityException aS400SecurityException) {
            JDError.throwSQLException((Object)this, "08004", aS400SecurityException);
        }
        catch (IOException iOException) {
            JDError.throwSQLException((Object)this, "08001", iOException);
        }
        this.catalog_ = jDDataSourceURL.getServerName();
        if (this.catalog_.length() == 0) {
            this.catalog_ = this.as400_.getSystemName().toUpperCase();
        }
        this.setServerAttributes();
        jDLibraryList.addOnServer(this, this.id_);
        this.metaData_ = new AS400JDBCDatabaseMetaData(this, this.id_);
        if (this.newAutoCommitSupport_ == 0) {
            this.transactionManager_.setAutoCommit(true);
        }
        this.packageManager_ = new JDPackageManager(this, this.id_, this.properties_, this.transactionManager_.getCommitMode());
        if (JDTrace.isTraceOn()) {
            JDTrace.logOpen(this, null);
            JDTrace.logProperty((Object)this, "Auto commit", this.transactionManager_.getAutoCommit());
            JDTrace.logProperty((Object)this, "Read only", this.readOnly_);
            JDTrace.logProperty((Object)this, "Transaction isolation", this.transactionManager_.getIsolation());
            if (this.packageManager_.isEnabled()) {
                JDTrace.logInformation(this, "SQL package = " + this.packageManager_.getLibraryName() + "/" + this.packageManager_.getName());
            }
        }
        if (this.traceServer_ > 0) {
            boolean bl2;
            String string3 = this.getServerJobIdentifier();
            String string4 = string3.substring(20).trim() + "/" + string3.substring(10, 19).trim() + "/" + string3.substring(0, 10).trim();
            JDTrace.logDataEvenIfTracingIsOff(this, "Open Source Software, JTOpen 7.10, codebase 5770-SS1 V7R1M0.10 built=20130602 @I2");
            JDTrace.logDataEvenIfTracingIsOff(this, string4);
            JDTrace.logDataEvenIfTracingIsOff(this, "Server functional level:  " + this.getServerFunctionalLevel());
            boolean bl3 = true;
            boolean bl4 = this.properties_.getString(9).equals("sql");
            try {
                bl3 = this.getVRM() <= JDUtilities.vrm450;
            }
            catch (Exception exception) {
                JDTrace.logDataEvenIfTracingIsOff(this, "Attempt to start server job tracing failed, could not get server VRM");
            }
            if ((this.traceServer_ & 1) > 0 && !JDTrace.isTraceOn()) {
                JDTrace.setTraceOn(true);
            }
            try {
                JDUtilities.runCommand(this, "QSYS/CHGJOB LOG(4 00 *SECLVL) LOGCLPGM(*YES)", bl4);
            }
            catch (Exception exception) {
                JDTrace.logDataEvenIfTracingIsOff(this, "Attempt to start server job tracing failed, could not change log level");
            }
            if ((this.traceServer_ & 4) > 0) {
                try {
                    JDUtilities.runCommand(this, "QSYS/STRDBG UPDPROD(*YES)", bl4);
                }
                catch (Exception exception) {
                    JDTrace.logDataEvenIfTracingIsOff(this, "Attempt to start server job tracing failed, could not start debug on server job ");
                }
            }
            if ((this.traceServer_ & 2) > 0) {
                try {
                    JDUtilities.runCommand(this, "QSYS/STRDBMON OUTFILE(QUSRSYS/QJT" + string3.substring(20) + ") JOB(*) TYPE(*DETAIL)", bl4);
                }
                catch (Exception exception) {
                    JDTrace.logDataEvenIfTracingIsOff(this, "Attempt to start server job tracing failed, could not start database monitor");
                }
            }
            boolean bl5 = (this.traceServer_ & 0x10) > 0;
            boolean bl6 = bl2 = this.getVRM() >= JDUtilities.vrm530 && (this.traceServer_ & 0x40) > 0;
            if (bl5 || bl2) {
                try {
                    if (bl3 && bl5) {
                        JDUtilities.runCommand(this, "QSYS/TRCJOB MAXSTG(16000)", bl4);
                    } else if (!bl2) {
                        JDUtilities.runCommand(this, "QSYS/STRTRC SSNID(QJT" + string3.substring(20) + ") JOB(*) MAXSTG(128000)", bl4);
                    } else if (!bl5) {
                        if (this.getVRM() == JDUtilities.vrm530) {
                            JDUtilities.runCommand(this, "QSYS/STRTRC SSNID(QJT" + string3.substring(20) + ") JOB(*) MAXSTG(128000) JOBTRCTYPE(*TRCTYPE) " + "TRCTYPE((TESTA *INFO))", bl4);
                        } else {
                            JDUtilities.runCommand(this, "QSYS/STRTRC SSNID(QJT" + string3.substring(20) + ") JOB(*) MAXSTG(128000) JOBTRCTYPE(*TRCTYPE) " + "TRCTYPE((*DBHSVR *INFO))", bl4);
                        }
                    } else if (this.getVRM() == JDUtilities.vrm530) {
                        JDUtilities.runCommand(this, "QSYS/STRTRC SSNID(QJT" + string3.substring(20) + ") JOB(*) MAXSTG(128000) JOBTRCTYPE(*ALL) " + "TRCTYPE((TESTA *INFO))", bl4);
                    } else {
                        JDUtilities.runCommand(this, "QSYS/STRTRC SSNID(QJT" + string3.substring(20) + ") JOB(*) MAXSTG(128000) JOBTRCTYPE(*ALL) " + "TRCTYPE((*DBHSVR *INFO))", bl4);
                    }
                }
                catch (Exception exception) {
                    if (bl5 && !bl2) {
                        JDTrace.logDataEvenIfTracingIsOff(this, "Attempt to start server job tracing failed, could not trace server job");
                    }
                    if (bl2 && !bl5) {
                        JDTrace.logDataEvenIfTracingIsOff(this, "Attempt to start database host server tracing failed, could not trace server job");
                    }
                    JDTrace.logDataEvenIfTracingIsOff(this, "Attempt to start server job and database host server tracing failed, could not trace server job");
                }
            }
        }
        if (this.qaqqiniLibrary_.length() > 0 && !this.qaqqiniLibrary_.equals("null")) {
            boolean bl7 = this.properties_.getString(9).equals("sql");
            try {
                JDUtilities.runCommand(this, "CHGQRYA QRYOPTLIB(" + this.qaqqiniLibrary_ + ")", bl7);
            }
            catch (Exception exception) {
                JDTrace.logDataEvenIfTracingIsOff(this, "Attempt to issue Change Query Attributes command using QAQQINI Library name failed.");
            }
        }
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.checkOpen();
        if (this.transactionManager_.isLocalActive() || this.transactionManager_.isGlobalActive()) {
            JDError.throwSQLException((Object)this, "25000");
        }
        if (!bl && (this.properties_.getString(0).equalsIgnoreCase("read only") || this.properties_.getString(0).equalsIgnoreCase("read call"))) {
            JDError.throwSQLException((Object)this, "42505");
        }
        this.readOnly_ = bl;
        if (JDTrace.isTraceOn()) {
            JDTrace.logProperty((Object)this, "Read only", this.readOnly_);
        }
    }

    public Savepoint setSavepoint() throws SQLException {
        return this.setSavepoint(null, AS400JDBCSavepoint.getNextId());
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        return this.setSavepoint(string, 0);
    }

    private Savepoint setSavepoint(String string, int n) throws SQLException {
        if (n > 0) {
            string = "T_JDBCINTERNAL_" + n;
        }
        this.processSavepointRequest("SAVEPOINT " + string + " ON ROLLBACK RETAIN CURSORS");
        return new AS400JDBCSavepoint(string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setServerAttributes() throws SQLException {
        block160: {
            DBReplyRequestedDS dBReplyRequestedDS = null;
            try {
                block159: {
                    try {
                        String string;
                        int n;
                        int n2;
                        int n3;
                        int n4;
                        int n5;
                        CharSequence charSequence;
                        int n6;
                        int n7;
                        String string2;
                        this.vrm_ = this.as400_.getVRM();
                        DBSQLAttributesDS dBSQLAttributesDS = null;
                        DBReplyServerAttributes dBReplyServerAttributes = null;
                        try {
                            int n8;
                            Object object;
                            int n9;
                            dBSQLAttributesDS = DBDSPool.getDBSQLAttributesDS(8064, this.id_, -2130706432, 0);
                            ConvTable convTable = ConvTable.getTable(this.as400_.getCcsid(), null);
                            string2 = this.properties_.getString(51);
                            n7 = this.getSystem() == null ? 37 : this.getSystem().getCcsid();
                            n6 = Integer.parseInt("13488");
                            if (string2.equalsIgnoreCase("system")) {
                                n9 = n7;
                            } else {
                                try {
                                    n9 = Integer.valueOf(string2);
                                    if (n9 <= 0) {
                                        n9 = n6;
                                    }
                                    if (this.vrm_ < JDUtilities.vrm530 && n9 == 1200) {
                                        n9 = n6;
                                    }
                                }
                                catch (Exception exception) {
                                    n9 = n6;
                                }
                            }
                            this.packageCCSID_Converter = ConvTable.getTable(n9, null);
                            this.properties_.setString(51, new Integer(n9).toString());
                            dBSQLAttributesDS.setClientCCSID(n9);
                            if (JDTrace.isTraceOn()) {
                                JDTrace.logInformation(this, "Client CCSID = " + n9);
                            }
                            charSequence = this.as400_.getNLV();
                            dBSQLAttributesDS.setLanguageFeatureCode((String)charSequence);
                            if (JDTrace.isTraceOn()) {
                                JDTrace.logInformation(this, "Setting server NLV = " + (String)charSequence);
                            }
                            dBSQLAttributesDS.setClientFunctionalLevel(CLIENT_FUNCTIONAL_LEVEL_);
                            if (JDTrace.isTraceOn()) {
                                JDTrace.logInformation(this, "Client functional level = V7R1M01   ");
                            }
                            if (!this.properties_.equals(20, "hex")) {
                                object = new JDSortSequence(this.properties_.getString(20), this.properties_.getString(21), this.properties_.getString(22), this.properties_.getString(23));
                                dBSQLAttributesDS.setNLSSortSequence(((JDSortSequence)object).getType(), ((JDSortSequence)object).getTableFile(), ((JDSortSequence)object).getTableLibrary(), ((JDSortSequence)object).getLanguageId(), convTable);
                            }
                            dBSQLAttributesDS.setTranslateIndicator(240);
                            dBSQLAttributesDS.setDRDAPackageSize(1);
                            if (this.newAutoCommitSupport_ != 0) {
                                if (this.properties_.getBoolean(76)) {
                                    dBSQLAttributesDS.setAutoCommit(232);
                                } else {
                                    dBSQLAttributesDS.setAutoCommit(213);
                                }
                            }
                            if (this.newAutoCommitSupport_ == 1 && this.properties_.getBoolean(76)) {
                                dBSQLAttributesDS.setCommitmentControlLevelParserOption(0);
                            } else {
                                dBSQLAttributesDS.setCommitmentControlLevelParserOption(this.transactionManager_.getCommitMode());
                            }
                            n5 = this.properties_.getIndex(3);
                            if (n5 != -1) {
                                dBSQLAttributesDS.setDateFormatParserOption(n5);
                            }
                            if ((n4 = this.properties_.getIndex(4)) != -1) {
                                dBSQLAttributesDS.setDateSeparatorParserOption(n4);
                            }
                            if ((n3 = this.properties_.getIndex(24)) != -1) {
                                dBSQLAttributesDS.setTimeFormatParserOption(n3);
                            }
                            if ((n2 = this.properties_.getIndex(25)) != -1) {
                                dBSQLAttributesDS.setTimeSeparatorParserOption(n2);
                            }
                            if ((n = this.properties_.getIndex(5)) != -1) {
                                dBSQLAttributesDS.setDecimalSeparatorParserOption(n);
                            }
                            dBSQLAttributesDS.setNamingConventionParserOption(this.properties_.getIndex(9));
                            int n10 = this.properties_.getIndex(86);
                            if (n10 != -1) {
                                dBSQLAttributesDS.setIgnoreDecimalDataErrorParserOption(n10);
                            }
                            if (this.properties_.getBoolean(36)) {
                                if (this.vrm_ >= JDUtilities.vrm510) {
                                    this.dataCompression_ = 14386;
                                    dBSQLAttributesDS.setDataCompressionOption(0);
                                    if (JDTrace.isTraceOn()) {
                                        JDTrace.logInformation(this, "Data compression = RLE");
                                    }
                                } else {
                                    this.dataCompression_ = 1;
                                    dBSQLAttributesDS.setDataCompressionOption(1);
                                    if (JDTrace.isTraceOn()) {
                                        JDTrace.logInformation(this, "Data compression = old");
                                    }
                                }
                            } else {
                                this.dataCompression_ = 0;
                                dBSQLAttributesDS.setDataCompressionOption(0);
                                if (JDTrace.isTraceOn()) {
                                    JDTrace.logInformation(this, "Data compression = none");
                                }
                            }
                            if (this.defaultSchema_ != null) {
                                dBSQLAttributesDS.setDefaultSQLLibraryName(this.defaultSchema_, convTable);
                            }
                            dBSQLAttributesDS.setPackageAddStatementAllowed(this.properties_.getBoolean(11) ? 1 : 0);
                            if (this.vrm_ >= JDUtilities.vrm440) {
                                if (this.vrm_ >= JDUtilities.vrm540) {
                                    dBSQLAttributesDS.setUseExtendedFormatsIndicator(242);
                                } else {
                                    dBSQLAttributesDS.setUseExtendedFormatsIndicator(241);
                                }
                                int n11 = this.properties_.getInt(31);
                                if (n11 <= 0) {
                                    dBSQLAttributesDS.setLOBFieldThreshold(0);
                                } else if (n11 >= 0xF00000) {
                                    dBSQLAttributesDS.setLOBFieldThreshold(0xF00000);
                                } else {
                                    dBSQLAttributesDS.setLOBFieldThreshold(n11);
                                }
                                this.extendedFormats_ = true;
                            }
                            if (this.vrm_ >= JDUtilities.vrm520) {
                                dBSQLAttributesDS.setAmbiguousSelectOption(1);
                                this.mustSpecifyForUpdate_ = false;
                                if (this.vrm_ >= JDUtilities.vrm710) {
                                    dBSQLAttributesDS.setClientSupportInformation(-268435456);
                                    if (JDTrace.isTraceOn()) {
                                        JDTrace.logInformation(this, "ROWID supported = true");
                                        JDTrace.logInformation(this, "True auto-commit supported = true");
                                        JDTrace.logInformation(this, "128 byte column names supported = true");
                                        JDTrace.logInformation(this, "128 length schema names supported = true");
                                    }
                                } else if (this.vrm_ >= JDUtilities.vrm540) {
                                    dBSQLAttributesDS.setClientSupportInformation(-536870912);
                                    if (JDTrace.isTraceOn()) {
                                        JDTrace.logInformation(this, "ROWID supported = true");
                                        JDTrace.logInformation(this, "True auto-commit supported = true");
                                        JDTrace.logInformation(this, "128 byte column names supported = true");
                                    }
                                } else if (this.vrm_ >= JDUtilities.vrm530) {
                                    dBSQLAttributesDS.setClientSupportInformation(-1073741824);
                                    if (JDTrace.isTraceOn()) {
                                        JDTrace.logInformation(this, "ROWID supported = true");
                                        JDTrace.logInformation(this, "True auto-commit supported = true");
                                    }
                                } else {
                                    dBSQLAttributesDS.setClientSupportInformation(Integer.MIN_VALUE);
                                    if (JDTrace.isTraceOn()) {
                                        JDTrace.logInformation(this, "ROWID supported = true");
                                    }
                                }
                            }
                            if (this.vrm_ >= JDUtilities.vrm530) {
                                boolean bl;
                                int n12;
                                int n13 = this.properties_.getInt(53);
                                n8 = this.properties_.getInt(54);
                                int n14 = this.properties_.getInt(52);
                                if (n8 > 31) {
                                    n13 = 63;
                                }
                                dBSQLAttributesDS.setDecimalPrecisionIndicators(n13, n8, n14);
                                if (JDTrace.isTraceOn()) {
                                    JDTrace.logInformation(this, "Maximum decimal precision = " + n13);
                                    JDTrace.logInformation(this, "Maximum decimal scale = " + n8);
                                    JDTrace.logInformation(this, "Minimum divide scale = " + n14);
                                }
                                if ((n12 = this.properties_.getIndex(55)) != -1) {
                                    dBSQLAttributesDS.setHexConstantParserOption(n12);
                                    if (JDTrace.isTraceOn()) {
                                        String string3 = n12 == 0 ? "Translate hex = character" : "Translate hex = binary";
                                        JDTrace.logInformation(this, string3);
                                    }
                                }
                                if (!(bl = this.properties_.getBoolean(62))) {
                                    dBSQLAttributesDS.setInputLocatorType(213);
                                    if (JDTrace.isTraceOn()) {
                                        JDTrace.logInformation(this, "Hold Locators = " + bl);
                                    }
                                }
                                dBSQLAttributesDS.setLocatorPersistence(1);
                            }
                            if (this.vrm_ >= JDUtilities.vrm540) {
                                int n15 = this.properties_.getInt(66);
                                if (n15 != 0) {
                                    if (n15 == 1) {
                                        dBSQLAttributesDS.setQueryOptimizeGoal(198);
                                    } else if (n15 == 2) {
                                        dBSQLAttributesDS.setQueryOptimizeGoal(193);
                                    }
                                }
                                if (JDTrace.isTraceOn()) {
                                    JDTrace.logInformation(this, "query optimize goal = " + n15);
                                }
                            }
                            if (this.vrm_ >= JDUtilities.vrm610) {
                                int n16 = this.properties_.getInt(73);
                                if (n16 != -1) {
                                    if (n16 < -1) {
                                        dBSQLAttributesDS.setQueryStorageLimit(-1);
                                    } else if (n16 > 2147352578) {
                                        dBSQLAttributesDS.setQueryStorageLimit(2147352578);
                                    } else {
                                        dBSQLAttributesDS.setQueryStorageLimit(n16);
                                    }
                                }
                                if (JDTrace.isTraceOn()) {
                                    JDTrace.logInformation(this, "query storage limit = " + n16);
                                }
                            }
                            if (JDTrace.isTraceOn()) {
                                if (this.extendedFormats_) {
                                    JDTrace.logInformation(this, "Using extended datastreams");
                                } else {
                                    JDTrace.logInformation(this, "Using original datastreams");
                                }
                            }
                            if (this.vrm_ >= JDUtilities.vrm520 && ((StringBuffer)(object = new StringBuffer(this.properties_.getString(47)))).length() > 0) {
                                ((StringBuffer)object).append("                  ");
                                ((StringBuffer)object).setLength(18);
                                dBSQLAttributesDS.setRDBName(((StringBuffer)object).toString().toUpperCase(), convTable);
                                if (JDTrace.isTraceOn()) {
                                    JDTrace.logInformation(this, "RDB Name = -->" + object + "<--");
                                }
                            }
                            if (this.vrm_ >= JDUtilities.vrm610) {
                                dBSQLAttributesDS.setInterfaceType("JDBC", convTable);
                                dBSQLAttributesDS.setInterfaceName("IBM Toolbox for Java", convTable);
                                dBSQLAttributesDS.setInterfaceLevel("07010011", convTable);
                                int n17 = 0;
                                String string4 = this.properties_.getString(74);
                                if (string4.equals("half even")) {
                                    n17 = 0;
                                } else if (string4.equals("up")) {
                                    n17 = 6;
                                } else if (string4.equals("down")) {
                                    n17 = 2;
                                } else if (string4.equals("ceiling")) {
                                    n17 = 3;
                                } else if (string4.equals("floor")) {
                                    n17 = 4;
                                } else if (string4.equals("half up")) {
                                    n17 = 1;
                                } else if (string4.equals("half down")) {
                                    n17 = 5;
                                }
                                if (n17 != 0) {
                                    dBSQLAttributesDS.setDecfloatRoundingMode((short)n17);
                                }
                                dBSQLAttributesDS.setCloseEOF(232);
                            }
                            if (this.vrm_ >= JDUtilities.vrm710) {
                                int n18 = this.properties_.getInt(79);
                                if (!this.properties_.getString(79).equals("0")) {
                                    dBSQLAttributesDS.setConcurrentAccessResolution(n18);
                                    this.concurrentAccessResolution_ = n18;
                                }
                            }
                            dBReplyRequestedDS = this.sendAndReceive(dBSQLAttributesDS);
                            int n19 = dBReplyRequestedDS.getErrorClass();
                            n8 = dBReplyRequestedDS.getReturnCode();
                            if (n19 == 7 && (n8 == 301 || n8 == 303)) {
                                this.postWarning(JDError.getSQLWarning(this, this.id_, n19, n8));
                            } else if (n19 == 7 && n8 == 304) {
                                this.postWarning(JDError.getSQLWarning(this, this.id_, n19, n8));
                            } else if (n19 == 7 && n8 == -704) {
                                try {
                                    this.close();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                JDError.throwSQLException((Object)this, "42705");
                            } else if (n19 != 0) {
                                JDError.throwSQLException(this, this, this.id_, n19, n8);
                            }
                            dBReplyServerAttributes = dBReplyRequestedDS.getServerAttributes();
                            Object var22_38 = null;
                            if (dBSQLAttributesDS != null) {
                                dBSQLAttributesDS.returnToPool();
                                dBSQLAttributesDS = null;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var22_39 = null;
                            if (dBSQLAttributesDS != null) {
                                dBSQLAttributesDS.returnToPool();
                                dBSQLAttributesDS = null;
                            }
                            throw throwable;
                        }
                        int n20 = dBReplyServerAttributes.getServerCCSID();
                        this.converter_ = ConvTable.getTable(n20, null);
                        string2 = dBReplyServerAttributes.getServerFunctionalLevel(this.converter_);
                        try {
                            this.serverFunctionalLevel_ = Integer.parseInt(string2.substring(6));
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.serverFunctionalLevel_ = 0;
                        }
                        if (this.serverFunctionalLevel_ >= 5) {
                            this.serverJobIdentifier_ = dBReplyServerAttributes.getServerJobIdentifier(this.converter_);
                        }
                        if (this.vrm_ == JDUtilities.vrm510 && this.serverFunctionalLevel_ >= 10) {
                            this.mustSpecifyForUpdate_ = false;
                        }
                        if (JDTrace.isTraceOn()) {
                            int n21 = (this.vrm_ & 0xFFFF0000) >>> 16;
                            n7 = (this.vrm_ & 0xFF00) >>> 8;
                            n6 = this.vrm_ & 0xFF;
                            JDTrace.logInformation(this, "JDBC driver major version = 9");
                            if (n21 == 5 && n7 >= 3 || n21 > 5) {
                                JDTrace.logInformation(this, "IBM i VRM = V" + n21 + "R" + n7 + "M" + n6);
                            } else {
                                JDTrace.logInformation(this, "OS/400 VRM = V" + n21 + "R" + n7 + "M" + n6);
                            }
                            JDTrace.logInformation(this, "Server CCSID = " + n20);
                            JDTrace.logInformation(this, "Server functional level = " + string2 + " (" + this.serverFunctionalLevel_ + ")");
                            charSequence = new StringBuffer();
                            if (this.serverJobIdentifier_ == null) {
                                ((StringBuffer)charSequence).append("Not available");
                            } else {
                                ((StringBuffer)charSequence).append(this.serverJobIdentifier_.substring(20, 26).trim());
                                ((StringBuffer)charSequence).append('/');
                                ((StringBuffer)charSequence).append(this.serverJobIdentifier_.substring(10, 20).trim());
                                ((StringBuffer)charSequence).append('/');
                                ((StringBuffer)charSequence).append(this.serverJobIdentifier_.substring(0, 10).trim());
                            }
                            JDTrace.logInformation(this, "Server job identifier = " + charSequence);
                        }
                        if ((string = dBReplyServerAttributes.getRelationalDBName(this.converter_).trim()).length() > 0 && !string.equalsIgnoreCase("*N")) {
                            this.catalog_ = string;
                        }
                        if (n == -1) {
                            switch (dBReplyServerAttributes.getDecimalSeparatorPO()) {
                                case 0: {
                                    this.properties_.setString(5, ".");
                                    break;
                                }
                                case 1: {
                                    this.properties_.setString(5, ",");
                                }
                            }
                        }
                        if (n5 == -1) {
                            switch (dBReplyServerAttributes.getDateFormatPO()) {
                                case 0: {
                                    this.properties_.setString(3, "julian");
                                    break;
                                }
                                case 1: {
                                    this.properties_.setString(3, "mdy");
                                    break;
                                }
                                case 2: {
                                    this.properties_.setString(3, "dmy");
                                    break;
                                }
                                case 3: {
                                    this.properties_.setString(3, "ymd");
                                    break;
                                }
                                case 4: {
                                    this.properties_.setString(3, "usa");
                                    break;
                                }
                                case 5: {
                                    this.properties_.setString(3, "iso");
                                    break;
                                }
                                case 6: {
                                    this.properties_.setString(3, "eur");
                                    break;
                                }
                                case 7: {
                                    this.properties_.setString(3, "jis");
                                }
                            }
                        }
                        if (n4 == -1) {
                            switch (dBReplyServerAttributes.getDateSeparatorPO()) {
                                case 0: {
                                    this.properties_.setString(4, "/");
                                    break;
                                }
                                case 1: {
                                    this.properties_.setString(4, "-");
                                    break;
                                }
                                case 2: {
                                    this.properties_.setString(4, ".");
                                    break;
                                }
                                case 3: {
                                    this.properties_.setString(4, ",");
                                    break;
                                }
                                case 4: {
                                    this.properties_.setString(4, "b");
                                }
                            }
                        }
                        if (n3 == -1) {
                            switch (dBReplyServerAttributes.getTimeFormatPO()) {
                                case 0: {
                                    this.properties_.setString(24, "hms");
                                    break;
                                }
                                case 1: {
                                    this.properties_.setString(24, "usa");
                                    break;
                                }
                                case 2: {
                                    this.properties_.setString(24, "iso");
                                    break;
                                }
                                case 3: {
                                    this.properties_.setString(24, "eur");
                                    break;
                                }
                                case 4: {
                                    this.properties_.setString(24, "jis");
                                }
                            }
                        }
                        if (n2 != -1) break block159;
                        switch (dBReplyServerAttributes.getTimeSeparatorPO()) {
                            case 0: {
                                this.properties_.setString(25, ":");
                                break;
                            }
                            case 1: {
                                this.properties_.setString(25, ".");
                                break;
                            }
                            case 2: {
                                this.properties_.setString(25, ",");
                                break;
                            }
                            case 3: {
                                this.properties_.setString(25, "b");
                            }
                        }
                    }
                    catch (DBDataStreamException dBDataStreamException) {
                        JDError.throwSQLException((Object)this, "HY000", dBDataStreamException);
                        Object var24_42 = null;
                        if (dBReplyRequestedDS != null) {
                            dBReplyRequestedDS.returnToPool();
                            dBReplyRequestedDS = null;
                        }
                        break block160;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        JDError.throwSQLException((Object)this, "HY000", unsupportedEncodingException);
                        Object var24_43 = null;
                        if (dBReplyRequestedDS != null) {
                            dBReplyRequestedDS.returnToPool();
                            dBReplyRequestedDS = null;
                        }
                    }
                }
                Object var24_41 = null;
                if (dBReplyRequestedDS != null) {
                    dBReplyRequestedDS.returnToPool();
                    dBReplyRequestedDS = null;
                }
            }
            catch (Throwable throwable) {
                Object var24_44 = null;
                if (dBReplyRequestedDS != null) {
                    dBReplyRequestedDS.returnToPool();
                    dBReplyRequestedDS = null;
                }
                throw throwable;
            }
        }
    }

    void setSystem(AS400 aS400) throws SQLException {
        this.as400PublicClassObj_ = aS400;
    }

    public void setTransactionIsolation(int n) throws SQLException {
        this.checkOpen();
        this.transactionManager_.setIsolation(n);
        if (JDTrace.isTraceOn()) {
            JDTrace.logProperty((Object)this, "Transaction isolation", this.transactionManager_.getIsolation());
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        JDError.throwSQLException((Object)this, "IM001");
    }

    public String toString() {
        return this.catalog_;
    }

    boolean useExtendedFormats() throws SQLException {
        return this.extendedFormats_;
    }

    protected String[] getValidWrappedList() {
        return new String[]{"com.ibm.as400.access.AS400JDBCConnection", "java.sql.Connection"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClientInfo(String string, String string2) throws SQLException {
        DBBaseRequestDS dBBaseRequestDS = null;
        DBReplyRequestedDS dBReplyRequestedDS = null;
        ConvTable convTable = null;
        String string3 = null;
        if (string2 == null) {
            string2 = "";
        }
        try {
            block36: {
                try {
                    int n;
                    if (this.getVRM() >= JDUtilities.vrm610) {
                        dBBaseRequestDS = DBDSPool.getDBSQLAttributesDS(8064, this.id_, -2130706432, 0);
                        convTable = ConvTable.getTable(this.as400_.getCcsid(), null);
                    }
                    if (string.equals(applicationNamePropertyName_)) {
                        string3 = this.applicationName_;
                        this.applicationName_ = string2;
                        if (dBBaseRequestDS != null) {
                            ((DBSQLAttributesDS)dBBaseRequestDS).setClientInfoApplicationName(string2, convTable);
                        }
                    } else if (string.equals(clientUserPropertyName_)) {
                        string3 = this.clientUser_;
                        this.clientUser_ = string2;
                        if (dBBaseRequestDS != null) {
                            ((DBSQLAttributesDS)dBBaseRequestDS).setClientInfoClientUser(string2, convTable);
                        }
                    } else if (string.equals(clientAccountingPropertyName_)) {
                        string3 = this.clientAccounting_;
                        this.clientAccounting_ = string2;
                        if (dBBaseRequestDS != null) {
                            ((DBSQLAttributesDS)dBBaseRequestDS).setClientInfoClientAccounting(string2, convTable);
                        }
                    } else if (string.equals(clientHostnamePropertyName_)) {
                        string3 = this.clientHostname_;
                        this.clientHostname_ = string2;
                        if (dBBaseRequestDS != null) {
                            ((DBSQLAttributesDS)dBBaseRequestDS).setClientInfoClientHostname(string2, convTable);
                        }
                    } else if (string.equals(clientProgramIDPropertyName_)) {
                        string3 = this.clientProgramID_;
                        this.clientProgramID_ = string2;
                        if (dBBaseRequestDS != null) {
                            ((DBSQLAttributesDS)dBBaseRequestDS).setClientInfoProgramID(string2, convTable);
                        }
                    } else {
                        string3 = null;
                        this.postWarning(JDError.getSQLWarning("42601"));
                    }
                    if (this.getVRM() < JDUtilities.vrm610 || string3 == null || (n = (dBReplyRequestedDS = this.sendAndReceive(dBBaseRequestDS)).getErrorClass()) == 0) break block36;
                    JDError.throwSQLException(this, this.id_, n, dBReplyRequestedDS.getReturnCode());
                }
                catch (Exception exception) {
                    if (string.equals(applicationNamePropertyName_)) {
                        this.applicationName_ = string3;
                    } else if (string.equals(clientUserPropertyName_)) {
                        this.clientUser_ = string3;
                    } else if (string.equals(clientAccountingPropertyName_)) {
                        this.clientAccounting_ = string3;
                    } else if (string.equals(clientHostnamePropertyName_)) {
                        this.clientHostname_ = string3;
                    } else if (string.equals(clientProgramIDPropertyName_)) {
                        this.clientProgramID_ = string3;
                    }
                    JDError.throwSQLException((Object)this, "HY000", exception);
                    Object var9_10 = null;
                    if (dBBaseRequestDS != null) {
                        dBBaseRequestDS.returnToPool();
                        dBBaseRequestDS = null;
                    }
                    if (dBReplyRequestedDS != null) {
                        dBReplyRequestedDS.returnToPool();
                        dBReplyRequestedDS = null;
                    }
                }
            }
            Object var9_9 = null;
            if (dBBaseRequestDS != null) {
                dBBaseRequestDS.returnToPool();
                dBBaseRequestDS = null;
            }
            if (dBReplyRequestedDS != null) {
                dBReplyRequestedDS.returnToPool();
                dBReplyRequestedDS = null;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (dBBaseRequestDS != null) {
                dBBaseRequestDS.returnToPool();
                dBBaseRequestDS = null;
            }
            if (dBReplyRequestedDS != null) {
                dBReplyRequestedDS.returnToPool();
                dBReplyRequestedDS = null;
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClientInfo(Properties properties) throws SQLException {
        String string = properties.getProperty(applicationNamePropertyName_);
        String string2 = properties.getProperty(clientHostnamePropertyName_);
        String string3 = properties.getProperty(clientUserPropertyName_);
        String string4 = properties.getProperty(clientAccountingPropertyName_);
        String string5 = properties.getProperty(clientProgramIDPropertyName_);
        if (string == null) {
            string = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        if (string4 == null) {
            string4 = "";
        }
        if (string5 == null) {
            string5 = "";
        }
        DBBaseRequestDS dBBaseRequestDS = null;
        DBReplyRequestedDS dBReplyRequestedDS = null;
        ConvTable convTable = null;
        try {
            try {
                if (this.getVRM() >= JDUtilities.vrm610) {
                    dBBaseRequestDS = DBDSPool.getDBSQLAttributesDS(8064, this.id_, -2130706432, 0);
                    convTable = ConvTable.getTable(this.as400_.getCcsid(), null);
                    ((DBSQLAttributesDS)dBBaseRequestDS).setClientInfoApplicationName(string, convTable);
                    ((DBSQLAttributesDS)dBBaseRequestDS).setClientInfoClientUser(string3, convTable);
                    ((DBSQLAttributesDS)dBBaseRequestDS).setClientInfoClientAccounting(string4, convTable);
                    ((DBSQLAttributesDS)dBBaseRequestDS).setClientInfoClientHostname(string2, convTable);
                    ((DBSQLAttributesDS)dBBaseRequestDS).setClientInfoProgramID(string5, convTable);
                    dBReplyRequestedDS = this.sendAndReceive(dBBaseRequestDS);
                    int n = dBReplyRequestedDS.getErrorClass();
                    if (n != 0) {
                        JDError.throwSQLException(this, this.id_, n, dBReplyRequestedDS.getReturnCode());
                    }
                }
                this.applicationName_ = string;
                this.clientHostname_ = string2;
                this.clientUser_ = string3;
                this.clientAccounting_ = string4;
                this.clientProgramID_ = string5;
            }
            catch (Exception exception) {
                JDError.throwSQLException((Object)this, "HY000", exception);
                Object var12_13 = null;
                if (dBBaseRequestDS != null) {
                    dBBaseRequestDS.returnToPool();
                    dBBaseRequestDS = null;
                }
                if (dBReplyRequestedDS != null) {
                    dBReplyRequestedDS.returnToPool();
                    dBReplyRequestedDS = null;
                }
            }
            Object var12_12 = null;
            if (dBBaseRequestDS != null) {
                dBBaseRequestDS.returnToPool();
                dBBaseRequestDS = null;
            }
            if (dBReplyRequestedDS != null) {
                dBReplyRequestedDS.returnToPool();
                dBReplyRequestedDS = null;
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (dBBaseRequestDS != null) {
                dBBaseRequestDS.returnToPool();
                dBBaseRequestDS = null;
            }
            if (dBReplyRequestedDS != null) {
                dBReplyRequestedDS.returnToPool();
                dBReplyRequestedDS = null;
            }
            throw throwable;
        }
    }

    public String getClientInfo(String string) throws SQLException {
        if (string.equals(applicationNamePropertyName_)) {
            return this.applicationName_;
        }
        if (string.equals(clientUserPropertyName_)) {
            return this.clientUser_;
        }
        if (string.equals(clientAccountingPropertyName_)) {
            return this.clientAccounting_;
        }
        if (string.equals(clientHostnamePropertyName_)) {
            return this.clientHostname_;
        }
        if (string.equals(clientProgramIDPropertyName_)) {
            return this.clientProgramID_;
        }
        this.postWarning(JDError.getSQLWarning("42601"));
        return null;
    }

    public Properties getClientInfo() throws SQLException {
        Properties properties = new Properties();
        properties.setProperty(applicationNamePropertyName_, this.applicationName_);
        properties.setProperty(clientAccountingPropertyName_, this.clientAccounting_);
        properties.setProperty(clientHostnamePropertyName_, this.clientHostname_);
        properties.setProperty(clientUserPropertyName_, this.clientUser_);
        properties.setProperty(clientProgramIDPropertyName_, this.clientProgramID_);
        return properties;
    }

    public Clob createClob() throws SQLException {
        return new AS400JDBCClob("", Integer.MAX_VALUE);
    }

    public Blob createBlob() throws SQLException {
        return new AS400JDBCBlob(new byte[0], Integer.MAX_VALUE);
    }

    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        return new AS400JDBCArray(string, objectArray, this.vrm_, this);
    }

    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        JDError.throwSQLException((Object)this, "IM001");
        return null;
    }

    public void setDBHostServerTrace(boolean bl) {
        block13: {
            try {
                if (this.getVRM() >= JDUtilities.vrm530) {
                    boolean bl2 = (this.traceServer_ & 0x10) > 0;
                    boolean bl3 = (this.traceServer_ & 0x40) > 0;
                    String string = this.getServerJobIdentifier();
                    boolean bl4 = this.properties_.getString(9).equals("sql");
                    if (!bl3) {
                        if (bl) {
                            try {
                                if (this.getVRM() == JDUtilities.vrm530) {
                                    JDUtilities.runCommand(this, "QSYS/STRTRC SSNID(QJT" + string.substring(20) + ") JOB(*) MAXSTG(128000) JOBTRCTYPE(*TRCTYPE) " + "TRCTYPE((TESTA *INFO))", bl4);
                                } else {
                                    JDUtilities.runCommand(this, "QSYS/STRTRC SSNID(QJT" + string.substring(20) + ") JOB(*) MAXSTG(128000) JOBTRCTYPE(*TRCTYPE) " + "TRCTYPE((*DBHSVR *INFO))", bl4);
                                }
                                this.databaseHostServerTrace_ = true;
                            }
                            catch (Exception exception) {
                                JDTrace.logDataEvenIfTracingIsOff(this, "Attempt to start database host server tracing failed, could not trace server job");
                            }
                        } else if (!bl2) {
                            try {
                                JDUtilities.runCommand(this, "QSYS/ENDTRC SSNID(QJT" + string.substring(20) + ") DTAOPT(*LIB) DTALIB(QUSRSYS) RPLDTA(*YES) PRTTRC(*YES)", bl4);
                                JDUtilities.runCommand(this, "QSYS/DLTTRC DTAMBR(QJT" + string.substring(20) + ") DTALIB(QUSRSYS)", bl4);
                                this.databaseHostServerTrace_ = false;
                            }
                            catch (Exception exception) {
                                JDTrace.logDataEvenIfTracingIsOff(this, "Attempt to end database host server tracing failed.");
                            }
                        }
                    }
                }
            }
            catch (SQLException sQLException) {
                if (!JDTrace.isTraceOn()) break block13;
                JDTrace.logInformation(this, "Attempt to start/stop database host server tracing failed.");
            }
        }
    }

    public boolean doUpdateDeleteBlocking() {
        return this.doUpdateDeleteBlocking_;
    }

    public int getMaximumBlockedInputRows() {
        return this.maximumBlockedInputRows_;
    }

    public String getSchema() throws SQLException {
        Statement statement = this.createStatement();
        boolean bl = this.properties_.getString(9).equals("sql");
        String string = bl ? "SELECT CURRENT SCHEMA FROM SYSIBM.SYSDUMMY1" : "SELECT CURRENT SCHEMA FROM SYSIBM/SYSDUMMY1";
        ResultSet resultSet = statement.executeQuery(string);
        resultSet.next();
        String string2 = resultSet.getString(1);
        resultSet.close();
        statement.close();
        return string2;
    }

    public void setNetworkTimeout(int n) throws SQLException {
        String string = this.properties_.getString(38);
        if (string == null) {
            if (n > 0) {
                JDError.throwSQLException("IM001");
            }
        } else if (string.equalsIgnoreCase("true") && n > 0) {
            JDError.throwSQLException("IM001");
        }
        if (n < 0) {
            JDError.throwSQLException("HY105");
        }
        this.checkOpen();
        try {
            this.server_.setSoTimeout(n);
        }
        catch (SocketException socketException) {
            JDError.throwSQLException("08S01", socketException);
        }
    }

    public int getNetworkTimeout() throws SQLException {
        this.checkOpen();
        try {
            return this.server_.getSoTimeout();
        }
        catch (SocketException socketException) {
            JDError.throwSQLException("08S01", socketException);
            return 0;
        }
    }

    public void setSchema(String string) throws SQLException {
        this.checkOpen();
        PreparedStatement preparedStatement = this.prepareStatement("SET CURRENT SCHEMA ? ");
        if (string.length() <= 0 || string.charAt(0) != '\"') {
            string = string.toUpperCase();
        }
        preparedStatement.setString(1, string);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    protected boolean isQueryTimeoutMechanismCancel() {
        return this.queryTimeoutMechanism_ == 1;
    }

    static {
        AS400Server.addReplyStream((DataStream)DBDSPool.getDBReplyRequestedDS(), 4);
    }

    private class HeldRequestsLock {
        private HeldRequestsLock() {
        }
    }

    private class CancelLock {
        private CancelLock() {
        }
    }
}

