/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchbase.data;

import com.couchbase.client.java.document.json.JsonObject;
import com.dbeaver.db.couchbase.data.CouchbaseDocument;
import com.dbeaver.db.couchbase.model.CouchbaseDataSource;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBValueFormatting;
import org.jkiss.dbeaver.model.data.DBDDisplayFormat;
import org.jkiss.dbeaver.model.data.DBDValue;
import org.jkiss.dbeaver.model.data.DBDValueHandlerComposite;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class CouchbaseDocumentValueHandler
implements DBDValueHandlerComposite {
    public static final CouchbaseDocumentValueHandler INSTANCE = new CouchbaseDocumentValueHandler();

    @NotNull
    public Class<Object> getValueObjectType(@NotNull DBSTypedObject attribute) {
        return Object.class;
    }

    @NotNull
    public String getValueContentType(@NotNull DBSTypedObject attribute) {
        return "text/json";
    }

    @NotNull
    public String getValueDisplayString(@NotNull DBSTypedObject column, Object value, @NotNull DBDDisplayFormat format) {
        if (value instanceof Map || value instanceof DBDValue) {
            return value.toString();
        }
        return DBValueFormatting.getDefaultValueDisplayString((Object)value, (DBDDisplayFormat)format);
    }

    public Object getValueFromObject(@NotNull DBCSession session, @NotNull DBSTypedObject type, Object object, boolean copy, boolean validateValue) throws DBCException {
        if (object == null) {
            return new CouchbaseDocument((CouchbaseDataSource)session.getDataSource(), JsonObject.create());
        }
        if (object instanceof Map) {
            return new CouchbaseDocument((CouchbaseDataSource)session.getDataSource(), JsonObject.from((Map)((Map)object)));
        }
        if (object instanceof CouchbaseDocument) {
            CouchbaseDocument srcDocument = (CouchbaseDocument)((Object)object);
            return copy ? srcDocument.copy() : srcDocument;
        }
        throw new DBCException("Unsupported struct type: " + object.getClass().getName());
    }

    public Object createNewValueObject(@NotNull DBCSession session, @NotNull DBSTypedObject type) throws DBCException {
        return new CouchbaseDocument((CouchbaseDataSource)session.getDataSource(), JsonObject.create());
    }

    public void releaseValueObject(Object value) {
    }

    @NotNull
    public DBCLogicalOperator[] getSupportedOperators(@NotNull DBSTypedObject attribute) {
        return new DBCLogicalOperator[]{DBCLogicalOperator.EQUALS, DBCLogicalOperator.NOT_EQUALS, DBCLogicalOperator.LESS, DBCLogicalOperator.GREATER};
    }

    public final Object fetchValueObject(@NotNull DBCSession session, @NotNull DBCResultSet resultSet, @NotNull DBSTypedObject type, int index) throws DBCException {
        Object attributeValue = resultSet.getAttributeValue(0);
        return this.getValueFromObject(session, type, attributeValue, false, false);
    }

    public void bindValueObject(@NotNull DBCSession session, @NotNull DBCStatement statement, @NotNull DBSTypedObject type, int index, Object value) throws DBCException {
    }
}

