/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.util.draw2dl;

import org.eclipse.draw2dl.Cursors;
import org.eclipse.draw2dl.Graphics;
import org.eclipse.draw2dl.geometry.Dimension;
import org.eclipse.draw2dl.geometry.Rectangle;
import org.eclipse.gef3.DragTracker;
import org.eclipse.gef3.EditPart;
import org.eclipse.gef3.GraphicalEditPart;
import org.eclipse.gef3.handles.AbstractHandle;
import org.eclipse.gef3.tools.DragEditPartsTracker;
import org.eclipse.gef3.tools.ResizeTracker;
import org.eclipse.graphiti.tb.IShapeSelectionInfo;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProviderInternal;
import org.eclipse.graphiti.ui.internal.figures.GFFigureUtil;
import org.eclipse.graphiti.ui.internal.util.DataTypeTransformation;
import org.eclipse.graphiti.ui.internal.util.draw2dl.GFHandleHelper;
import org.eclipse.graphiti.ui.internal.util.draw2dl.ZoomingRelativeHandleLocator;
import org.eclipse.graphiti.util.IColorConstant;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;

public class GFCornerHandle
extends AbstractHandle {
    private static int LINE_WIDTH = 1;
    private static Dimension HANDLE_DIMENSION = new Dimension(5, 5);
    private static Dimension HANDLE_INSETS = new Dimension(3, 3);
    private static Color FG_COLOR_PRIMARY_RESIZABLE;
    private static Color FG_COLOR_SECONDARY_RESIZABLE;
    private static Color FG_COLOR_NOT_RESIZABLE;
    private static Color BG_COLOR_PRIMARY_RESIZABLE;
    private static Color BG_COLOR_SECONDARY_RESIZABLE;
    private static Color BG_COLOR_PRIMARY_NOT_RESIZABLE;
    private static Color BG_COLOR_SECONDARY_NOT_RESIZABLE;
    private IConfigurationProviderInternal configurationProvider;
    private int resizeDirection;
    private boolean movable;
    private IShapeSelectionInfo shapeSelectionInfo;

    public GFCornerHandle(GraphicalEditPart owner, IConfigurationProviderInternal configurationProvider, int location, int supportedResizeDirections, boolean movable, IShapeSelectionInfo shapeSelectionInfo) {
        this.configurationProvider = configurationProvider;
        this.resizeDirection = supportedResizeDirections & location;
        this.movable = movable;
        this.shapeSelectionInfo = shapeSelectionInfo;
        this.setOwner(owner);
        this.setLocator(new ZoomingRelativeHandleLocator(owner.getFigure(), configurationProvider, location, HANDLE_DIMENSION, HANDLE_INSETS));
        this.setOpaque(false);
        if (this.isResizable()) {
            this.setCursor(Cursors.getDirectionalCursor((int)this.resizeDirection, (boolean)owner.getFigure().isMirrored()));
        } else if (movable) {
            this.setCursor(Cursors.SIZEALL);
        } else {
            this.setCursor(null);
        }
    }

    public Color getFG_COLOR_PRIMARY_RESIZABLE() {
        IColorConstant color;
        if (this.shapeSelectionInfo != null && (color = this.shapeSelectionInfo.getPrimarySelectionHandleForegroundColor()) != null) {
            Color swtColor = DataTypeTransformation.toSwtColor(this.configurationProvider.getResourceRegistry(), color);
            return swtColor;
        }
        if (FG_COLOR_PRIMARY_RESIZABLE == null || FG_COLOR_PRIMARY_RESIZABLE.isDisposed()) {
            FG_COLOR_PRIMARY_RESIZABLE = this.configurationProvider.getResourceRegistry().getSwtColor("f17d00");
        }
        return FG_COLOR_PRIMARY_RESIZABLE;
    }

    public Color getFG_COLOR_SECONDARY_RESIZABLE() {
        IColorConstant color;
        if (this.shapeSelectionInfo != null && (color = this.shapeSelectionInfo.getSecondarySelectionHandleForegroundColor()) != null) {
            Color swtColor = DataTypeTransformation.toSwtColor(this.configurationProvider.getResourceRegistry(), color);
            return swtColor;
        }
        if (FG_COLOR_SECONDARY_RESIZABLE == null || FG_COLOR_SECONDARY_RESIZABLE.isDisposed()) {
            FG_COLOR_SECONDARY_RESIZABLE = this.configurationProvider.getResourceRegistry().getSwtColor("f17d00");
        }
        return FG_COLOR_SECONDARY_RESIZABLE;
    }

    public Color getFG_COLOR_NOT_RESIZABLE() {
        if (FG_COLOR_NOT_RESIZABLE == null || FG_COLOR_NOT_RESIZABLE.isDisposed()) {
            FG_COLOR_NOT_RESIZABLE = this.configurationProvider.getResourceRegistry().getSwtColor("b3b6bb");
        }
        return FG_COLOR_NOT_RESIZABLE;
    }

    public Color getBG_COLOR_PRIMARY_RESIZABLE() {
        IColorConstant color;
        if (this.shapeSelectionInfo != null && (color = this.shapeSelectionInfo.getPrimarySelectionHandleBackgroundColor()) != null) {
            Color swtColor = DataTypeTransformation.toSwtColor(this.configurationProvider.getResourceRegistry(), color);
            return swtColor;
        }
        if (BG_COLOR_PRIMARY_RESIZABLE == null || BG_COLOR_PRIMARY_RESIZABLE.isDisposed()) {
            BG_COLOR_PRIMARY_RESIZABLE = this.configurationProvider.getResourceRegistry().getSwtColor("ff8400");
        }
        return BG_COLOR_PRIMARY_RESIZABLE;
    }

    public Color getBG_COLOR_SECONDARY_RESIZABLE() {
        IColorConstant color;
        if (this.shapeSelectionInfo != null && (color = this.shapeSelectionInfo.getSecondarySelectionHandleBackgroundColor()) != null) {
            Color swtColor = DataTypeTransformation.toSwtColor(this.configurationProvider.getResourceRegistry(), color);
            return swtColor;
        }
        if (BG_COLOR_SECONDARY_RESIZABLE == null || BG_COLOR_SECONDARY_RESIZABLE.isDisposed()) {
            BG_COLOR_SECONDARY_RESIZABLE = this.configurationProvider.getResourceRegistry().getSwtColor("ffffff");
        }
        return BG_COLOR_SECONDARY_RESIZABLE;
    }

    public Color getBG_COLOR_PRIMARY_NOT_RESIZABLE() {
        if (BG_COLOR_PRIMARY_NOT_RESIZABLE == null || BG_COLOR_PRIMARY_NOT_RESIZABLE.isDisposed()) {
            BG_COLOR_PRIMARY_NOT_RESIZABLE = this.configurationProvider.getResourceRegistry().getSwtColor("b3b6bb");
        }
        return BG_COLOR_PRIMARY_NOT_RESIZABLE;
    }

    public Color getBG_COLOR_SECONDARY_NOT_RESIZABLE() {
        if (BG_COLOR_SECONDARY_NOT_RESIZABLE == null || BG_COLOR_SECONDARY_NOT_RESIZABLE.isDisposed()) {
            BG_COLOR_SECONDARY_NOT_RESIZABLE = this.configurationProvider.getResourceRegistry().getSwtColor("edf4ff");
        }
        return BG_COLOR_SECONDARY_NOT_RESIZABLE;
    }

    protected DragTracker createDragTracker() {
        if (this.isResizable()) {
            return new ResizeTracker(this.getOwner(), this.resizeDirection);
        }
        if (this.movable) {
            DragEditPartsTracker tracker = new DragEditPartsTracker((EditPart)this.getOwner());
            tracker.setDefaultCursor(this.getCursor());
            return tracker;
        }
        return null;
    }

    private boolean isPrimarySelected() {
        return this.getOwner().getSelected() == 2;
    }

    public void paintFigure(Graphics g) {
        Color bg;
        Color fg;
        g.setAntialias(1);
        g.setLineWidth(this.getLineWidth());
        boolean primary = this.isPrimarySelected();
        if (primary && this.isResizable()) {
            fg = this.getFG_COLOR_PRIMARY_RESIZABLE();
            bg = this.getBG_COLOR_PRIMARY_RESIZABLE();
        } else if (primary && !this.isResizable()) {
            fg = this.getFG_COLOR_NOT_RESIZABLE();
            bg = this.getBG_COLOR_PRIMARY_NOT_RESIZABLE();
        } else if (!primary && this.isResizable()) {
            fg = this.getFG_COLOR_SECONDARY_RESIZABLE();
            bg = this.getBG_COLOR_SECONDARY_RESIZABLE();
        } else {
            fg = this.getFG_COLOR_NOT_RESIZABLE();
            bg = this.getBG_COLOR_SECONDARY_NOT_RESIZABLE();
        }
        if (fg != null) {
            g.setForegroundColor(this.convertColorForHighContrastMode(fg, 21));
        }
        if (bg != null) {
            g.setBackgroundColor(this.convertColorForHighContrastMode(bg, 22));
        }
        Rectangle r = GFFigureUtil.getAdjustedRectangle(this.getBounds(), 1.0, this.getLineWidth());
        g.fillRectangle(r);
        g.drawRectangle(r);
    }

    private Color convertColorForHighContrastMode(Color color, int colorType) {
        Color result = null;
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        Color highContrastClr = null;
        try {
            if (display.getHighContrast()) {
                highContrastClr = display.getSystemColor(colorType);
            }
        }
        catch (SWTException e) {
            highContrastClr = null;
        }
        result = highContrastClr == null ? color : highContrastClr;
        return result;
    }

    private int getLineWidth() {
        double zoom = GFHandleHelper.getZoomLevel(this.configurationProvider);
        return Math.max(1, (int)(zoom * (double)LINE_WIDTH));
    }

    private boolean isResizable() {
        return this.resizeDirection != 0;
    }
}

