/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.services.impl;

import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.gef3.commands.CompoundCommand;
import org.eclipse.graphiti.IExecutionInfo;
import org.eclipse.graphiti.features.IContextHolder;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureAndContext;
import org.eclipse.graphiti.features.IFeatureHolder;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.internal.DefaultFeatureAndContext;
import org.eclipse.graphiti.internal.command.CommandContainer;
import org.eclipse.graphiti.internal.command.DefaultExecutionInfo;
import org.eclipse.graphiti.internal.command.GFPreparableCommand2;
import org.eclipse.graphiti.internal.command.ICommand;
import org.eclipse.graphiti.tb.IContextEntry;
import org.eclipse.graphiti.ui.internal.command.AddModelObjectCommand;
import org.eclipse.graphiti.ui.internal.command.ContextEntryCommand;
import org.eclipse.graphiti.ui.internal.command.CreateConnectionCommand;
import org.eclipse.graphiti.ui.internal.command.GFCommand;
import org.eclipse.graphiti.ui.internal.command.GefCommandWrapper;
import org.eclipse.graphiti.ui.internal.command.ReconnectCommand;
import org.eclipse.graphiti.ui.internal.editor.EmfOnGefCommand;
import org.eclipse.graphiti.ui.internal.editor.GefOnEmfCommand;
import org.eclipse.graphiti.ui.internal.services.ICommandService;

public class CommandService
implements ICommandService {
    @Override
    public Command transformFromGefToEmfCommand(org.eclipse.gef3.commands.Command gefCommand) {
        if (gefCommand instanceof GefOnEmfCommand) {
            GefOnEmfCommand gefOnEmfCommand = (GefOnEmfCommand)gefCommand;
            return gefOnEmfCommand.getEmfCommand();
        }
        return new EmfOnGefCommand(gefCommand);
    }

    @Override
    public org.eclipse.gef3.commands.Command transformFromEmfToGefCommand(Command emfCommand) {
        if (emfCommand instanceof EmfOnGefCommand) {
            EmfOnGefCommand emfOnGefCommand = (EmfOnGefCommand)emfCommand;
            return emfOnGefCommand.getGefCommand();
        }
        if (emfCommand instanceof GFPreparableCommand2) {
            Command command = ((GFPreparableCommand2)emfCommand).getCommand();
            return this.transformFromEmfToGefCommand(command);
        }
        return new GefOnEmfCommand(emfCommand);
    }

    @Override
    public DefaultExecutionInfo completeExecutionInfo(DefaultExecutionInfo executionInfo, org.eclipse.gef3.commands.Command gefCommand) {
        IFeatureAndContext feature;
        int n;
        IFeatureAndContext[] iFeatureAndContextArray;
        IFeatureAndContext[] features;
        if (gefCommand instanceof CompoundCommand) {
            CompoundCommand compoundCommand = (CompoundCommand)gefCommand;
            List commands = compoundCommand.getCommands();
            for (org.eclipse.gef3.commands.Command childCommand : commands) {
                this.completeExecutionInfo(executionInfo, childCommand);
            }
        }
        if (gefCommand instanceof CreateConnectionCommand) {
            CreateConnectionCommand createConnectionCommand = (CreateConnectionCommand)gefCommand;
            iFeatureAndContextArray = features = createConnectionCommand.getFeaturesAndContexts();
            n = features.length;
            int n2 = 0;
            while (n2 < n) {
                feature = iFeatureAndContextArray[n2];
                executionInfo.addFeatureAndContext(feature);
                ++n2;
            }
        }
        if (gefCommand instanceof ReconnectCommand) {
            ReconnectCommand reconnectCommand = (ReconnectCommand)gefCommand;
            executionInfo.addFeatureAndContext((IFeatureAndContext)new DefaultFeatureAndContext(reconnectCommand.getFeature(), reconnectCommand.getContext()));
        }
        if (gefCommand instanceof GefCommandWrapper) {
            GefCommandWrapper gefCommandWrapper = (GefCommandWrapper)gefCommand;
            ICommand graphitiCommand = gefCommandWrapper.getCommand();
            this.completeExecutionInfo(executionInfo, graphitiCommand);
        }
        if (gefCommand instanceof GFCommand) {
            GFCommand gfCommand = (GFCommand)gefCommand;
            executionInfo.addFeatureAndContext((IFeatureAndContext)new DefaultFeatureAndContext(gfCommand.getFeature(), gfCommand.getContext()));
        }
        if (gefCommand instanceof ContextEntryCommand) {
            ContextEntryCommand cec = (ContextEntryCommand)gefCommand;
            IContextEntry contextEntry = cec.getContextEntry();
            executionInfo.addFeatureAndContext((IFeatureAndContext)new DefaultFeatureAndContext(contextEntry.getFeature(), contextEntry.getContext()));
        }
        if (gefCommand instanceof AddModelObjectCommand) {
            AddModelObjectCommand addModelObjectCommand = (AddModelObjectCommand)gefCommand;
            iFeatureAndContextArray = features = addModelObjectCommand.getFeaturesAndContexts();
            n = features.length;
            int n3 = 0;
            while (n3 < n) {
                feature = iFeatureAndContextArray[n3];
                executionInfo.addFeatureAndContext(feature);
                ++n3;
            }
        }
        return executionInfo;
    }

    @Override
    public DefaultExecutionInfo completeExecutionInfo(DefaultExecutionInfo executionInfo, ICommand gfCommand) {
        if (gfCommand instanceof CommandContainer) {
            CommandContainer cc = (CommandContainer)gfCommand;
            ICommand[] childCommands = cc.getCommands();
            int i = 0;
            while (i < childCommands.length) {
                ICommand childCommand = childCommands[i];
                this.completeExecutionInfo(executionInfo, childCommand);
                ++i;
            }
        } else {
            IContext context = null;
            IFeature feature = null;
            if (gfCommand instanceof IFeatureHolder) {
                IFeatureHolder featureHolder = (IFeatureHolder)gfCommand;
                feature = featureHolder.getFeature();
            }
            if (gfCommand instanceof IContextHolder) {
                IContextHolder contextHolder = (IContextHolder)gfCommand;
                context = contextHolder.getContext();
            }
            executionInfo.addFeatureAndContext((IFeatureAndContext)new DefaultFeatureAndContext(feature, context));
        }
        return executionInfo;
    }

    @Override
    public IExecutionInfo removeFeaturesWithoutChanges(IExecutionInfo executionInfo) {
        DefaultExecutionInfo result = new DefaultExecutionInfo();
        IFeatureAndContext[] iFeatureAndContextArray = executionInfo.getExecutionList();
        int n = iFeatureAndContextArray.length;
        int n2 = 0;
        while (n2 < n) {
            IFeatureAndContext featureAndContext = iFeatureAndContextArray[n2];
            if (featureAndContext.getFeature().hasDoneChanges()) {
                result.addFeatureAndContext(featureAndContext);
            }
            ++n2;
        }
        return result;
    }
}

