/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.parts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2dl.Border;
import org.eclipse.draw2dl.ConnectionAnchor;
import org.eclipse.draw2dl.ConnectionLayer;
import org.eclipse.draw2dl.FreeformLayer;
import org.eclipse.draw2dl.Graphics;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.LayoutManager;
import org.eclipse.draw2dl.MarginBorder;
import org.eclipse.draw2dl.XYLayout;
import org.eclipse.draw2dl.geometry.Point;
import org.eclipse.draw2dl.geometry.Translatable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef3.DragTracker;
import org.eclipse.gef3.Request;
import org.eclipse.gef3.requests.SelectionRequest;
import org.eclipse.gef3.tools.MarqueeDragTracker;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProviderInternal;
import org.eclipse.graphiti.ui.internal.parts.ContainerShapeEditPart;
import org.eclipse.graphiti.ui.internal.parts.IDiagramEditPart;
import org.eclipse.graphiti.ui.internal.util.DataTypeTransformation;

public class DiagramEditPart
extends ContainerShapeEditPart
implements IDiagramEditPart {
    public DiagramEditPart(IConfigurationProviderInternal configurationProvider, Diagram diagram) {
        super(configurationProvider, (ContainerShape)diagram);
    }

    @Override
    protected IFigure createFigure() {
        FreeformLayer f = new FreeformLayer(){

            protected void paintFigure(Graphics graphics) {
                graphics.setAntialias(1);
                super.paintFigure(graphics);
            }
        };
        GraphicsAlgorithm graphicsAlgorithm = this.getPictogramElement().getGraphicsAlgorithm();
        f.setBackgroundColor(DataTypeTransformation.toSwtColor(this.getConfigurationProvider().getResourceRegistry(), Graphiti.getGaService().getBackgroundColor(graphicsAlgorithm, true)));
        f.setBorder((Border)new MarginBorder(5));
        f.setLayoutManager((LayoutManager)new XYLayout(){

            public Point getOrigin(IFigure parent) {
                return new Point();
            }
        });
        ConnectionLayer cLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        cLayer.setAntialias(1);
        return f;
    }

    @Override
    public DragTracker getDragTracker(Request request) {
        if (request instanceof SelectionRequest) {
            SelectionRequest casted = (SelectionRequest)request;
            if (casted.getLastButtonPressed() == 3) {
                return super.getDragTracker(request);
            }
            Point location = casted.getLocation().getCopy();
            this.getContentPane().translateToRelative((Translatable)location);
            if (this.getContentPane().getClientArea().contains(location)) {
                return new MarqueeDragTracker();
            }
        }
        return super.getDragTracker(request);
    }

    @Override
    public List<PictogramElement> getModelChildren() {
        ArrayList<PictogramElement> result = new ArrayList<PictogramElement>();
        result.addAll(super.getModelChildren());
        EList connections = this.getDiagram().getConnections();
        for (Connection connection : connections) {
            EList connectionDecorators = connection.getConnectionDecorators();
            for (ConnectionDecorator connectionDecorator : connectionDecorators) {
                if (!connectionDecorator.isActive() || connectionDecorator.getGraphicsAlgorithm() == null) continue;
                result.add((PictogramElement)connectionDecorator);
            }
        }
        return result;
    }

    private Diagram getDiagram() {
        return (Diagram)this.getModel();
    }

    @Override
    public void refresh() {
        DiagramBehavior diagramBehavior = this.getConfigurationProvider().getDiagramBehavior();
        diagramBehavior.getRefreshBehavior().initRefresh();
        super.refresh();
    }

    @Override
    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return null;
    }
}

