/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.figures;

import org.eclipse.draw2dl.Graphics;
import org.eclipse.draw2dl.geometry.Point;
import org.eclipse.draw2dl.geometry.Rectangle;
import org.eclipse.draw2dl.text.TextFlow;
import org.eclipse.draw2dl.text.TextFragmentBox;
import org.eclipse.graphiti.mm.algorithms.AbstractText;
import org.eclipse.graphiti.mm.algorithms.MultiText;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.ui.internal.config.IConfigurationProviderInternal;
import org.eclipse.graphiti.ui.internal.figures.GFFigureUtil;

public class GFTextFlow
extends TextFlow {
    private MultiText multiText;
    private boolean suppressText = false;
    private int currentOffset;
    private IConfigurationProviderInternal configurationProvider;

    public GFTextFlow(MultiText multiText, IConfigurationProviderInternal configurationProvider) {
        this.multiText = multiText;
        this.configurationProvider = configurationProvider;
    }

    public void paint(Graphics graphics) {
        double angle = 0.0;
        angle = Graphiti.getGaService().getRotation((AbstractText)this.multiText, true);
        if (angle != 0.0) {
            if (this.getLocalBackgroundColor() != null) {
                graphics.setBackgroundColor(this.getLocalBackgroundColor());
            }
            if (this.getLocalForegroundColor() != null) {
                graphics.setForegroundColor(this.getLocalForegroundColor());
            }
            if (this.getLocalFont() != null) {
                graphics.setFont(this.getLocalFont());
            }
            graphics.pushState();
            try {
                Rectangle flowPageFigureBounds = this.getParent().getBounds();
                Rectangle multiTextBounds = this.getParent().getParent().getBounds();
                Point clipLocation = new Point(multiTextBounds.x - flowPageFigureBounds.x, multiTextBounds.y - flowPageFigureBounds.y);
                Rectangle clip = new Rectangle(clipLocation, multiTextBounds.getSize());
                graphics.setClip(clip);
                this.paintFigure(graphics);
                graphics.restoreState();
                this.paintClientArea(graphics);
                this.paintBorder(graphics);
            }
            finally {
                graphics.popState();
            }
        } else {
            super.paint(graphics);
        }
    }

    protected String getBidiSubstring(TextFragmentBox box, int index) {
        this.currentOffset = box.offset;
        return super.getBidiSubstring(box, index);
    }

    protected void paintText(Graphics g, String draw, int x, int y, int bidiLevel) {
        if (this.suppressText) {
            return;
        }
        double angle = 0.0;
        angle = Graphiti.getGaService().getRotation((AbstractText)this.multiText, true);
        if (bidiLevel == -1 && angle != 0.0) {
            g.pushState();
            int xOff = this.getParent().getBounds().width() / 2;
            int yOff = this.getBounds().height() / 2;
            g.translate(xOff, yOff);
            g.rotate(new Double(angle).floatValue());
            if (this.multiText.getStyleRegions().isEmpty()) {
                g.drawText(draw, x - xOff, y - yOff);
            } else {
                GFFigureUtil.drawRichText(g, draw, x - xOff, y - yOff, bidiLevel, this.isMirrored(), this.currentOffset, this.configurationProvider, (AbstractText)this.multiText);
            }
            g.popState();
        } else if (this.multiText.getStyleRegions().isEmpty()) {
            super.paintText(g, draw, x, y, bidiLevel);
        } else {
            GFFigureUtil.drawRichText(g, draw, x, y, bidiLevel, this.isMirrored(), this.currentOffset, this.configurationProvider, (AbstractText)this.multiText);
        }
    }

    public void setSuppressText(boolean suppressText) {
        this.suppressText = suppressText;
        this.repaint();
    }
}

