/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.editor;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.draw2dl.geometry.Point;
import org.eclipse.gef3.EditPart;
import org.eclipse.gef3.EditPartViewer;
import org.eclipse.gef3.Request;
import org.eclipse.gef3.commands.Command;
import org.eclipse.gef3.requests.CreateConnectionRequest;
import org.eclipse.gef3.tools.ConnectionDragCreationTool;
import org.eclipse.graphiti.features.ICreateConnectionFeature;
import org.eclipse.graphiti.features.IFeatureAndContext;
import org.eclipse.graphiti.features.context.ICreateConnectionContext;
import org.eclipse.graphiti.tb.ContextButtonEntry;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;
import org.eclipse.graphiti.ui.internal.command.CreateConnectionCommand;
import org.eclipse.graphiti.ui.internal.requests.ContextButtonDragRequest;

public class GFDragConnectionTool
extends ConnectionDragCreationTool {
    private DiagramBehavior diagramBehavior;
    private ContextButtonEntry contextButtonEntry;

    public GFDragConnectionTool(DiagramBehavior diagramBehavior, ContextButtonEntry contextButtonEntry) {
        this.diagramBehavior = diagramBehavior;
        this.contextButtonEntry = contextButtonEntry;
    }

    protected boolean handleCreateConnection() {
        Command endCommand = this.getCommand();
        this.setCurrentCommand(endCommand);
        if (endCommand == null || !endCommand.canExecute()) {
            for (IFeatureAndContext ifac : this.getCreateConnectionFeaturesAndContext()) {
                ICreateConnectionFeature ccf = (ICreateConnectionFeature)ifac.getFeature();
                ccf.canceledAttaching((ICreateConnectionContext)ifac.getContext());
            }
        }
        this.executeCurrentCommand();
        this.eraseSourceFeedback();
        return true;
    }

    protected boolean handleButtonUp(int button) {
        boolean b = super.handleButtonUp(button);
        this.setViewer((EditPartViewer)this.diagramBehavior.getDiagramContainer().getGraphicalViewer());
        this.diagramBehavior.getEditDomain().setActiveTool(this.diagramBehavior.getEditDomain().getDefaultTool());
        return b;
    }

    protected void handleFinished() {
        for (IFeatureAndContext ifac : this.getCreateConnectionFeaturesAndContext()) {
            ICreateConnectionFeature ccf = (ICreateConnectionFeature)ifac.getFeature();
            ccf.endConnecting();
        }
        super.handleFinished();
    }

    protected Request createTargetRequest() {
        ContextButtonDragRequest request = new ContextButtonDragRequest();
        request.setType(this.getCommandName());
        request.setContextButtonEntry(this.contextButtonEntry);
        return request;
    }

    public void continueConnection(EditPart targetEditPart, EditPart targetTargetEditPart) {
        this.setConnectionSource(targetEditPart);
        this.lockTargetEditPart(targetEditPart);
        CreateConnectionRequest createConnectionRequest = (CreateConnectionRequest)this.getTargetRequest();
        createConnectionRequest.setSourceEditPart(targetEditPart);
        createConnectionRequest.setTargetEditPart(targetTargetEditPart);
        Command command = this.getCommand();
        if (command != null) {
            this.setCurrentCommand(command);
            if (this.stateTransition(1, 64)) {
                for (IFeatureAndContext ifac : this.getCreateConnectionFeaturesAndContext()) {
                    ICreateConnectionFeature ccf = (ICreateConnectionFeature)ifac.getFeature();
                    ccf.startConnecting();
                    ccf.attachedToSource((ICreateConnectionContext)ifac.getContext());
                }
            }
        }
        this.setViewer((EditPartViewer)this.diagramBehavior.getDiagramContainer().getGraphicalViewer());
        this.handleDrag();
        this.unlockTargetEditPart();
    }

    private Iterable<IFeatureAndContext> getCreateConnectionFeaturesAndContext() {
        if (this.getTargetRequest() instanceof CreateConnectionRequest) {
            ArrayList<IFeatureAndContext> ret = new ArrayList<IFeatureAndContext>();
            CreateConnectionRequest r = (CreateConnectionRequest)this.getTargetRequest();
            if (r.getStartCommand() instanceof CreateConnectionCommand) {
                CreateConnectionCommand cmd = (CreateConnectionCommand)r.getStartCommand();
                IFeatureAndContext[] iFeatureAndContextArray = cmd.getFeaturesAndContexts();
                int n = iFeatureAndContextArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IFeatureAndContext ifac = iFeatureAndContextArray[n2];
                    if (ifac.getFeature() instanceof ICreateConnectionFeature) {
                        ret.add(ifac);
                    }
                    ++n2;
                }
            }
            return ret;
        }
        return Collections.emptyList();
    }

    protected boolean handleMove() {
        if (this.isInState(97)) {
            this.updateTargetRequest();
            this.updateTargetUnderMouse();
            this.showSourceFeedback();
            this.showTargetFeedback();
            this.setCurrentCommand(this.getCommand());
        }
        return true;
    }

    protected Point getLocation() {
        Point absoluteMousePosition = this.diagramBehavior.getMouseLocation();
        return absoluteMousePosition;
    }
}

