/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.action;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef3.EditPart;
import org.eclipse.gef3.commands.Command;
import org.eclipse.gef3.commands.CommandStack;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.impl.CustomContext;
import org.eclipse.graphiti.features.custom.ICustomFeature;
import org.eclipse.graphiti.internal.command.GenericFeatureCommandWithContext;
import org.eclipse.graphiti.internal.command.ICommand;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.tb.IToolBehaviorProvider;
import org.eclipse.graphiti.ui.internal.command.GefCommandWrapper;
import org.eclipse.graphiti.ui.platform.IConfigurationProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class FeatureExecutionHandler
extends AbstractHandler {
    public static final String COMMAND_ID = "org.eclipse.graphiti.ui.featureExecutionCommand";
    private static final String HINT_PARAMETER_ID = "org.eclipse.graphiti.ui.featureHint";
    private IConfigurationProvider configurationProvider;

    public FeatureExecutionHandler(IConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
    }

    protected PictogramElement[] getSelectedPictogramElements(ExecutionEvent event) {
        ISelection selectedObjects = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        ArrayList<Object> list = new ArrayList<Object>();
        if (selectedObjects instanceof IStructuredSelection) {
            for (Object o : (IStructuredSelection)selectedObjects) {
                EditPart editPart;
                if (!(o instanceof EditPart) || !((editPart = (EditPart)o).getModel() instanceof PictogramElement)) continue;
                list.add(editPart.getModel());
            }
        }
        return list.toArray(new PictogramElement[0]);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        PictogramElement[] pes;
        CustomContext context;
        IToolBehaviorProvider featureProvider = this.getToolBehaviorProvider();
        ICustomFeature feature = featureProvider.getCommandFeature(context = new CustomContext(pes = this.getSelectedPictogramElements(event)), event.getParameter(HINT_PARAMETER_ID));
        if (feature != null && feature.canExecute((IContext)context)) {
            this.executeOnCommandStack((ICommand)new GenericFeatureCommandWithContext((IFeature)feature, (IContext)context));
        }
        return null;
    }

    private IToolBehaviorProvider getToolBehaviorProvider() {
        return this.getConfigurationProvider().getDiagramTypeProvider().getCurrentToolBehaviorProvider();
    }

    protected IConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }

    protected void executeOnCommandStack(ICommand command) {
        CommandStack commandStack = this.getConfigurationProvider().getDiagramContainer().getEditDomain().getCommandStack();
        commandStack.execute((Command)new GefCommandWrapper(command, this.getConfigurationProvider().getDiagramBehavior().getEditingDomain()));
    }
}

