/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.ui.palette.customize;

import org.eclipse.draw2dl.FigureUtilities;
import org.eclipse.gef3.palette.PaletteEntry;
import org.eclipse.gef3.palette.PaletteSeparator;
import org.eclipse.gef3.ui.palette.PaletteMessages;
import org.eclipse.gef3.ui.palette.customize.EntryPage;
import org.eclipse.gef3.ui.palette.customize.EntryPageContainer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DefaultEntryPage
implements EntryPage {
    private EntryPageContainer container;
    private Composite panel;
    private PaletteEntry entry;

    @Override
    public final void apply() {
    }

    @Override
    public void createControl(Composite parent, PaletteEntry entry) {
        this.entry = entry;
        this.panel = new Composite(parent, 0);
        this.panel.setFont(parent.getFont());
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.panel.setLayout((Layout)gridLayout);
        Control[] tablist = new Control[3];
        this.createLabel(this.panel, 0, PaletteMessages.NAME_LABEL);
        tablist[0] = this.createNameText(this.panel);
        this.createLabel(this.panel, 0, PaletteMessages.DESCRIPTION_LABEL);
        tablist[1] = this.createDescText(this.panel);
        tablist[2] = this.createHiddenCheckBox(this.panel);
        this.panel.setTabList(tablist);
    }

    protected Text createDescText(Composite panel) {
        String desc = this.entry.getDescription();
        Text description = this.createText(panel, 2626, desc);
        GridData data = new GridData(768);
        data.widthHint = 150;
        data.heightHint = description.computeTrim((int)0, (int)0, (int)10, (int)(FigureUtilities.getFontMetrics((Font)description.getFont()).getHeight() * 2)).height;
        description.setLayoutData((Object)data);
        if (this.getPermission() >= 7) {
            description.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    DefaultEntryPage.this.handleDescriptionChanged(((Text)e.getSource()).getText());
                }
            });
        }
        return description;
    }

    protected Button createHiddenCheckBox(Composite panel) {
        Button hidden = new Button(panel, 32);
        hidden.setFont(panel.getFont());
        hidden.setText(PaletteMessages.HIDDEN_LABEL);
        hidden.setSelection(!this.entry.isVisible());
        if (this.getPermission() == 1) {
            hidden.setEnabled(false);
        } else {
            hidden.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DefaultEntryPage.this.handleHiddenSelected(((Button)e.getSource()).getSelection());
                }
            });
        }
        return hidden;
    }

    protected Label createLabel(Composite panel, int style, String text) {
        Label label = new Label(panel, style);
        label.setFont(panel.getFont());
        label.setText(text);
        return label;
    }

    protected Text createNameText(Composite panel) {
        Text name = this.createText(panel, 2052, this.entry.getLabel());
        if (this.getPermission() >= 7) {
            name.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    DefaultEntryPage.this.handleNameChanged(((Text)e.getSource()).getText());
                }
            });
        }
        name.setVisible(true);
        return name;
    }

    protected Text createText(Composite panel, int style, String text) {
        if (this.getEntry() instanceof PaletteSeparator || this.getPermission() < 7) {
            style |= 8;
        }
        Text textBox = new Text(panel, style);
        textBox.setFont(panel.getFont());
        if (text != null) {
            textBox.setText(text);
        }
        GridData data = new GridData(768);
        data.widthHint = 200;
        textBox.setLayoutData((Object)data);
        return textBox;
    }

    @Override
    public Control getControl() {
        return this.panel;
    }

    protected PaletteEntry getEntry() {
        return this.entry;
    }

    protected String getMessage() {
        return "";
    }

    protected EntryPageContainer getPageContainer() {
        return this.container;
    }

    protected void handleDescriptionChanged(String text) {
        this.getEntry().setDescription(text.trim());
    }

    protected void handleHiddenSelected(boolean isChecked) {
        this.getEntry().setVisible(!isChecked);
    }

    protected void handleNameChanged(String text) {
        this.getEntry().setLabel(text.trim());
    }

    protected int getPermission() {
        return this.getEntry().getUserModificationPermission();
    }

    @Override
    public void setPageContainer(EntryPageContainer pageContainer) {
        this.container = pageContainer;
    }
}

