/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.editpolicies;

import java.util.List;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.OrderedLayout;
import org.eclipse.gef3.EditPart;
import org.eclipse.gef3.EditPolicy;
import org.eclipse.gef3.Request;
import org.eclipse.gef3.commands.Command;
import org.eclipse.gef3.commands.CompoundCommand;
import org.eclipse.gef3.editpolicies.LayoutEditPolicy;
import org.eclipse.gef3.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef3.requests.ChangeBoundsRequest;

public abstract class OrderedLayoutEditPolicy
extends LayoutEditPolicy {
    protected abstract Command createAddCommand(EditPart var1, EditPart var2);

    @Override
    protected EditPolicy createChildEditPolicy(EditPart child) {
        return new NonResizableEditPolicy();
    }

    protected abstract Command createMoveChildCommand(EditPart var1, EditPart var2);

    @Override
    protected Command getAddCommand(Request req) {
        ChangeBoundsRequest request = (ChangeBoundsRequest)req;
        List editParts = request.getEditParts();
        CompoundCommand command = new CompoundCommand();
        int i = 0;
        while (i < editParts.size()) {
            EditPart child = (EditPart)editParts.get(i);
            command.add(this.createAddCommand(child, this.getInsertionReference(request)));
            ++i;
        }
        return command.unwrap();
    }

    protected abstract EditPart getInsertionReference(Request var1);

    @Override
    protected Command getMoveChildrenCommand(Request request) {
        CompoundCommand command = new CompoundCommand();
        List editParts = ((ChangeBoundsRequest)request).getEditParts();
        EditPart insertionReference = this.getInsertionReference(request);
        int i = 0;
        while (i < editParts.size()) {
            EditPart child = (EditPart)editParts.get(i);
            command.add(this.createMoveChildCommand(child, insertionReference));
            ++i;
        }
        return command.unwrap();
    }

    protected boolean isLayoutHorizontal() {
        IFigure figure = this.getLayoutContainer();
        return ((OrderedLayout)figure.getLayoutManager()).isHorizontal();
    }
}

