/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef3.editpolicies;

import org.eclipse.draw2dl.Connection;
import org.eclipse.draw2dl.ConnectionAnchor;
import org.eclipse.draw2dl.ConnectionLayer;
import org.eclipse.draw2dl.ConnectionRouter;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.PolylineConnection;
import org.eclipse.draw2dl.geometry.Point;
import org.eclipse.gef3.EditPart;
import org.eclipse.gef3.NodeEditPart;
import org.eclipse.gef3.Request;
import org.eclipse.gef3.commands.Command;
import org.eclipse.gef3.editpolicies.FeedbackHelper;
import org.eclipse.gef3.editpolicies.GraphicalEditPolicy;
import org.eclipse.gef3.requests.CreateConnectionRequest;
import org.eclipse.gef3.requests.DropRequest;
import org.eclipse.gef3.requests.ReconnectRequest;

public abstract class GraphicalNodeEditPolicy
extends GraphicalEditPolicy {
    protected FeedbackHelper feedbackHelper;
    protected Connection connectionFeedback;

    protected Connection createDummyConnection(Request req) {
        return new PolylineConnection();
    }

    @Override
    public void deactivate() {
        if (this.connectionFeedback != null) {
            this.removeFeedback((IFigure)this.connectionFeedback);
            this.feedbackHelper = null;
            this.connectionFeedback = null;
        }
        super.deactivate();
    }

    protected void eraseCreationFeedback(CreateConnectionRequest request) {
        if (this.connectionFeedback != null) {
            this.removeFeedback((IFigure)this.connectionFeedback);
            this.feedbackHelper = null;
            this.connectionFeedback = null;
        }
    }

    @Override
    public void eraseSourceFeedback(Request request) {
        if ("connection end".equals(request.getType())) {
            this.eraseCreationFeedback((CreateConnectionRequest)request);
        }
    }

    protected void eraseTargetConnectionFeedback(DropRequest request) {
    }

    @Override
    public void eraseTargetFeedback(Request request) {
        if ("connection start".equals(request.getType()) || "connection end".equals(request.getType()) || "Reconnection source".equals(request.getType()) || "Reconnection target".equals(request.getType())) {
            this.eraseTargetConnectionFeedback((DropRequest)((Object)request));
        }
    }

    @Override
    public Command getCommand(Request request) {
        if ("connection start".equals(request.getType())) {
            return this.getConnectionCreateCommand((CreateConnectionRequest)request);
        }
        if ("connection end".equals(request.getType())) {
            return this.getConnectionCompleteCommand((CreateConnectionRequest)request);
        }
        if ("Reconnection target".equals(request.getType())) {
            return this.getReconnectTargetCommand((ReconnectRequest)request);
        }
        if ("Reconnection source".equals(request.getType())) {
            return this.getReconnectSourceCommand((ReconnectRequest)request);
        }
        return null;
    }

    protected abstract Command getConnectionCompleteCommand(CreateConnectionRequest var1);

    protected abstract Command getConnectionCreateCommand(CreateConnectionRequest var1);

    protected ConnectionRouter getDummyConnectionRouter(CreateConnectionRequest request) {
        return ((ConnectionLayer)this.getLayer("Connection Layer")).getConnectionRouter();
    }

    protected FeedbackHelper getFeedbackHelper(CreateConnectionRequest request) {
        if (this.feedbackHelper == null) {
            this.feedbackHelper = new FeedbackHelper();
            Point p = request.getLocation();
            this.connectionFeedback = this.createDummyConnection(request);
            this.connectionFeedback.setConnectionRouter(this.getDummyConnectionRouter(request));
            this.connectionFeedback.setSourceAnchor(this.getSourceConnectionAnchor(request));
            this.feedbackHelper.setConnection(this.connectionFeedback);
            this.addFeedback((IFigure)this.connectionFeedback);
            this.feedbackHelper.update(null, p);
        }
        return this.feedbackHelper;
    }

    protected abstract Command getReconnectTargetCommand(ReconnectRequest var1);

    protected abstract Command getReconnectSourceCommand(ReconnectRequest var1);

    protected ConnectionAnchor getSourceConnectionAnchor(CreateConnectionRequest request) {
        EditPart source = request.getSourceEditPart();
        return source instanceof NodeEditPart ? ((NodeEditPart)source).getSourceConnectionAnchor(request) : null;
    }

    protected ConnectionAnchor getTargetConnectionAnchor(CreateConnectionRequest request) {
        EditPart target = request.getTargetEditPart();
        return target instanceof NodeEditPart ? ((NodeEditPart)target).getTargetConnectionAnchor(request) : null;
    }

    @Override
    public EditPart getTargetEditPart(Request request) {
        if ("connection start".equals(request.getType()) || "connection end".equals(request.getType()) || "Reconnection source".equals(request.getType()) || "Reconnection target".equals(request.getType())) {
            return this.getHost();
        }
        return null;
    }

    protected void showCreationFeedback(CreateConnectionRequest request) {
        FeedbackHelper helper = this.getFeedbackHelper(request);
        Point p = new Point(request.getLocation());
        helper.update(this.getTargetConnectionAnchor(request), p);
    }

    @Override
    public void showSourceFeedback(Request request) {
        if ("connection end".equals(request.getType())) {
            this.showCreationFeedback((CreateConnectionRequest)request);
        }
    }

    protected void showTargetConnectionFeedback(DropRequest request) {
    }

    @Override
    public void showTargetFeedback(Request request) {
        if ("connection start".equals(request.getType()) || "connection end".equals(request.getType()) || "Reconnection source".equals(request.getType()) || "Reconnection target".equals(request.getType())) {
            this.showTargetConnectionFeedback((DropRequest)((Object)request));
        }
    }
}

