/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iam.model.StatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceSpecificCredentialMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceSpecificCredentialMetadata> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserName").getter(ServiceSpecificCredentialMetadata.getter(ServiceSpecificCredentialMetadata::userName)).setter(ServiceSpecificCredentialMetadata.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(ServiceSpecificCredentialMetadata.getter(ServiceSpecificCredentialMetadata::statusAsString)).setter(ServiceSpecificCredentialMetadata.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> SERVICE_USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceUserName").getter(ServiceSpecificCredentialMetadata.getter(ServiceSpecificCredentialMetadata::serviceUserName)).setter(ServiceSpecificCredentialMetadata.setter(Builder::serviceUserName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUserName").build()}).build();
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateDate").getter(ServiceSpecificCredentialMetadata.getter(ServiceSpecificCredentialMetadata::createDate)).setter(ServiceSpecificCredentialMetadata.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()}).build();
    private static final SdkField<String> SERVICE_SPECIFIC_CREDENTIAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceSpecificCredentialId").getter(ServiceSpecificCredentialMetadata.getter(ServiceSpecificCredentialMetadata::serviceSpecificCredentialId)).setter(ServiceSpecificCredentialMetadata.setter(Builder::serviceSpecificCredentialId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceSpecificCredentialId").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceName").getter(ServiceSpecificCredentialMetadata.getter(ServiceSpecificCredentialMetadata::serviceName)).setter(ServiceSpecificCredentialMetadata.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD, STATUS_FIELD, SERVICE_USER_NAME_FIELD, CREATE_DATE_FIELD, SERVICE_SPECIFIC_CREDENTIAL_ID_FIELD, SERVICE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String userName;
    private final String status;
    private final String serviceUserName;
    private final Instant createDate;
    private final String serviceSpecificCredentialId;
    private final String serviceName;

    private ServiceSpecificCredentialMetadata(BuilderImpl builder) {
        this.userName = builder.userName;
        this.status = builder.status;
        this.serviceUserName = builder.serviceUserName;
        this.createDate = builder.createDate;
        this.serviceSpecificCredentialId = builder.serviceSpecificCredentialId;
        this.serviceName = builder.serviceName;
    }

    public final String userName() {
        return this.userName;
    }

    public final StatusType status() {
        return StatusType.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String serviceUserName() {
        return this.serviceUserName;
    }

    public final Instant createDate() {
        return this.createDate;
    }

    public final String serviceSpecificCredentialId() {
        return this.serviceSpecificCredentialId;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceUserName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceSpecificCredentialId());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceSpecificCredentialMetadata)) {
            return false;
        }
        ServiceSpecificCredentialMetadata other = (ServiceSpecificCredentialMetadata)obj;
        return Objects.equals(this.userName(), other.userName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.serviceUserName(), other.serviceUserName()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.serviceSpecificCredentialId(), other.serviceSpecificCredentialId()) && Objects.equals(this.serviceName(), other.serviceName());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceSpecificCredentialMetadata").add("UserName", (Object)this.userName()).add("Status", (Object)this.statusAsString()).add("ServiceUserName", (Object)this.serviceUserName()).add("CreateDate", (Object)this.createDate()).add("ServiceSpecificCredentialId", (Object)this.serviceSpecificCredentialId()).add("ServiceName", (Object)this.serviceName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "ServiceUserName": {
                return Optional.ofNullable(clazz.cast(this.serviceUserName()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
            case "ServiceSpecificCredentialId": {
                return Optional.ofNullable(clazz.cast(this.serviceSpecificCredentialId()));
            }
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceSpecificCredentialMetadata, T> g) {
        return obj -> g.apply((ServiceSpecificCredentialMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String userName;
        private String status;
        private String serviceUserName;
        private Instant createDate;
        private String serviceSpecificCredentialId;
        private String serviceName;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceSpecificCredentialMetadata model) {
            this.userName(model.userName);
            this.status(model.status);
            this.serviceUserName(model.serviceUserName);
            this.createDate(model.createDate);
            this.serviceSpecificCredentialId(model.serviceSpecificCredentialId);
            this.serviceName(model.serviceName);
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getServiceUserName() {
            return this.serviceUserName;
        }

        @Override
        public final Builder serviceUserName(String serviceUserName) {
            this.serviceUserName = serviceUserName;
            return this;
        }

        public final void setServiceUserName(String serviceUserName) {
            this.serviceUserName = serviceUserName;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final String getServiceSpecificCredentialId() {
            return this.serviceSpecificCredentialId;
        }

        @Override
        public final Builder serviceSpecificCredentialId(String serviceSpecificCredentialId) {
            this.serviceSpecificCredentialId = serviceSpecificCredentialId;
            return this;
        }

        public final void setServiceSpecificCredentialId(String serviceSpecificCredentialId) {
            this.serviceSpecificCredentialId = serviceSpecificCredentialId;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public ServiceSpecificCredentialMetadata build() {
            return new ServiceSpecificCredentialMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceSpecificCredentialMetadata> {
        public Builder userName(String var1);

        public Builder status(String var1);

        public Builder status(StatusType var1);

        public Builder serviceUserName(String var1);

        public Builder createDate(Instant var1);

        public Builder serviceSpecificCredentialId(String var1);

        public Builder serviceName(String var1);
    }
}

