/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.services.iam.model.PolicyVersion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPolicyVersionResponse
extends IamResponse
implements ToCopyableBuilder<Builder, GetPolicyVersionResponse> {
    private static final SdkField<PolicyVersion> POLICY_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PolicyVersion").getter(GetPolicyVersionResponse.getter(GetPolicyVersionResponse::policyVersion)).setter(GetPolicyVersionResponse.setter(Builder::policyVersion)).constructor(PolicyVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_VERSION_FIELD));
    private final PolicyVersion policyVersion;

    private GetPolicyVersionResponse(BuilderImpl builder) {
        super(builder);
        this.policyVersion = builder.policyVersion;
    }

    public final PolicyVersion policyVersion() {
        return this.policyVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPolicyVersionResponse)) {
            return false;
        }
        GetPolicyVersionResponse other = (GetPolicyVersionResponse)((Object)obj);
        return Objects.equals(this.policyVersion(), other.policyVersion());
    }

    public final String toString() {
        return ToString.builder((String)"GetPolicyVersionResponse").add("PolicyVersion", (Object)this.policyVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyVersion": {
                return Optional.ofNullable(clazz.cast(this.policyVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPolicyVersionResponse, T> g) {
        return obj -> g.apply((GetPolicyVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private PolicyVersion policyVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPolicyVersionResponse model) {
            super(model);
            this.policyVersion(model.policyVersion);
        }

        public final PolicyVersion.Builder getPolicyVersion() {
            return this.policyVersion != null ? this.policyVersion.toBuilder() : null;
        }

        @Override
        public final Builder policyVersion(PolicyVersion policyVersion) {
            this.policyVersion = policyVersion;
            return this;
        }

        public final void setPolicyVersion(PolicyVersion.BuilderImpl policyVersion) {
            this.policyVersion = policyVersion != null ? policyVersion.build() : null;
        }

        @Override
        public GetPolicyVersionResponse build() {
            return new GetPolicyVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPolicyVersionResponse> {
        public Builder policyVersion(PolicyVersion var1);

        default public Builder policyVersion(Consumer<PolicyVersion.Builder> policyVersion) {
            return this.policyVersion((PolicyVersion)((PolicyVersion.Builder)PolicyVersion.builder().applyMutation(policyVersion)).build());
        }
    }
}

