/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.logging;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.netezza.Driver;
import org.netezza.internal.NzDriverExpiration;
import org.netezza.logging.BaseLogger;
import org.netezza.logging.LogLevel;

class HtmlLogger
extends BaseLogger {
    private RandomAccessFile file;
    private static final String HTML_START = "<html>";
    private static final String BODY_START = "<body>";
    private static final String TITLE_START = "<title>";
    private static final String TITLE_END = "</title>";
    private static final String HEAD_START = "<head>";
    private static final String HEAD_END = "</head>";
    private static final String STYLE_START = "<style type=\"text/css\">";
    private static final String STYLE_END = "</style>";
    private static final String TD_CLASS_PROPERTIES = "td.p{height:15px; background-color:#ffffff; text-align: left; font-size:12pt}";
    private static final String TD_CLASS_HEADER = "td.h{height:15px; color:#ffffff; background-color:#336633;text-align: center; font-size:12pt;}";
    private static final String TD_NORMAL = "td{height:15px; text-align: center; font-size:11pt}";
    private static final String TD_CLASS_MESSAGE_RIGHT = "td.r{height:15px;text-align: right;font-size:11pt}";
    private static final String TD_CLASS_MESSAGE_LEFT = "td.l{height:15px;text-align: left;font-size:11pt}";
    public Object writeLock;
    private long currentPointer = 0L;
    private static final String TAIL = "</table>" + LINE_SEPARATOR + "</body>" + LINE_SEPARATOR + "</html>";

    HtmlLogger(LogLevel level, String logDirPath) {
        super(level, logDirPath);
    }

    @Override
    protected String getExtension() {
        return "html";
    }

    @Override
    public void init() {
        if (this.fileName == null || this.fileName.trim().length() == 0) {
            this.generateFileName(null);
        }
        this.writeLock = new Object();
        try {
            this.file = new RandomAccessFile(this.fileName, "rw");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.startFile();
    }

    private void writeHTMLlog(Class klass, String method, String logType, String message) throws IOException {
        this.file.writeBytes("<tr>" + LINE_SEPARATOR);
        this.file.writeBytes("<td>" + this.timeStamp() + "</td>" + LINE_SEPARATOR);
        this.file.writeBytes("<td>[" + Thread.currentThread().hashCode() + "]" + "</td>" + LINE_SEPARATOR);
        this.file.writeBytes("<td>" + klass.getSimpleName() + "</td>" + LINE_SEPARATOR);
        this.file.writeBytes("<td>" + method + "</td>" + LINE_SEPARATOR);
        this.file.writeBytes("<td>" + logType + "</td>" + LINE_SEPARATOR);
        this.file.writeBytes("<td class=\"l\">" + message + "</td>" + LINE_SEPARATOR);
        this.file.writeBytes("</tr>" + LINE_SEPARATOR);
        this.currentPointer = this.file.getFilePointer();
        this.file.writeBytes(TAIL);
        this.file.seek(this.currentPointer);
    }

    @Override
    public void entry(Class klass, String method) {
        this.entry(klass, method, new Object[]{null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void entry(Class klass, String method, Object ... params) {
        if (LogLevel.ENTRY_EXIT.greaterThanEqualTo(this.level) && this.file != null) {
            Object object = this.writeLock;
            synchronized (object) {
                try {
                    String message = this.getParameterString(params);
                    this.writeHTMLlog(klass, method, "ENTRY", message);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void debug(Class klass, String method, Object message) {
        if (LogLevel.DEBUG.greaterThanEqualTo(this.level) && this.file != null) {
            Object object = this.writeLock;
            synchronized (object) {
                try {
                    this.writeHTMLlog(klass, method, "DEBUG", String.valueOf(message));
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void info(Class klass, String method, Object message) {
        if (LogLevel.INFO.greaterThanEqualTo(this.level) && this.file != null) {
            Object object = this.writeLock;
            synchronized (object) {
                try {
                    this.writeHTMLlog(klass, method, "INFO", String.valueOf(message));
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fatal(Class klass, String method, Object message) {
        if (LogLevel.FATAL.greaterThanEqualTo(this.level) && this.file != null) {
            Object object = this.writeLock;
            synchronized (object) {
                try {
                    this.writeHTMLlog(klass, method, "FATAL", String.valueOf(message));
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fatal(Class klass, String method, Throwable throwable) {
        if (LogLevel.FATAL.greaterThanEqualTo(this.level) && this.file != null) {
            Object object = this.writeLock;
            synchronized (object) {
                try {
                    this.writeHTMLlog(klass, method, "FATAL", this.getTable(throwable));
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exit(Class klass, String method) {
        if (LogLevel.ENTRY_EXIT.greaterThanEqualTo(this.level) && this.file != null) {
            Object object = this.writeLock;
            synchronized (object) {
                try {
                    this.writeHTMLlog(klass, method, "EXIT", "");
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exit(Class klass, String method, Object returnParam) {
        if (LogLevel.ENTRY_EXIT.greaterThanEqualTo(this.level) && this.file != null) {
            Object object = this.writeLock;
            synchronized (object) {
                try {
                    this.writeHTMLlog(klass, method, "EXIT", returnParam == null ? "" : returnParam.toString());
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public void close() {
        try {
            this.file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startFile() {
        if (this.file == null) {
            return;
        }
        Object object = this.writeLock;
        synchronized (object) {
            try {
                this.file.writeBytes(HTML_START + LINE_SEPARATOR);
                this.file.writeBytes(HEAD_START + LINE_SEPARATOR);
                this.file.writeBytes(STYLE_START + LINE_SEPARATOR);
                this.file.writeBytes(TD_CLASS_HEADER + LINE_SEPARATOR);
                this.file.writeBytes(TD_CLASS_PROPERTIES + LINE_SEPARATOR);
                this.file.writeBytes(TD_NORMAL + LINE_SEPARATOR);
                this.file.writeBytes(TD_CLASS_MESSAGE_RIGHT + LINE_SEPARATOR);
                this.file.writeBytes(TD_CLASS_MESSAGE_LEFT + LINE_SEPARATOR);
                this.file.writeBytes(STYLE_END + LINE_SEPARATOR);
                this.file.writeBytes(TITLE_START + LINE_SEPARATOR);
                this.file.writeBytes("Netezza JDBC Log File" + LINE_SEPARATOR);
                this.file.writeBytes(TITLE_END + LINE_SEPARATOR);
                this.file.writeBytes(HEAD_END + LINE_SEPARATOR);
                this.file.writeBytes(BODY_START + LINE_SEPARATOR);
                this.file.writeBytes("<table width='100%'>" + LINE_SEPARATOR);
                this.file.writeBytes("<tr><td class='p'>Operating System: " + OS + "</td></tr>" + LINE_SEPARATOR);
                this.file.writeBytes("<tr><td class='p'>Machine Architecture: " + MACHINE_ARCH + "</td></tr>" + LINE_SEPARATOR);
                this.file.writeBytes("<tr><td class='p'>OS version: " + OS_VERSION + "</td></tr>" + LINE_SEPARATOR);
                this.file.writeBytes("<tr><td class='p'>JRE version: " + JRE_VERSION + "</td></tr>" + LINE_SEPARATOR);
                this.file.writeBytes("<tr><td class='p'>Driver version: " + Driver.getVersion() + "</td></tr>" + LINE_SEPARATOR);
                if (NzDriverExpiration.willDriverExpire()) {
                    this.file.writeBytes("<tr><td class='p'>Driver set to expire on: null</td></tr>" + LINE_SEPARATOR);
                }
                this.file.writeBytes("<tr><td class='p'>CLASSPATH: '" + System.getenv("CLASSPATH") + "'</td></tr>" + LINE_SEPARATOR);
                this.file.writeBytes("<tr><td class='p'>JAVA_HOME: '" + System.getenv("JAVA_HOME") + "'</td></tr>" + LINE_SEPARATOR);
                this.file.writeBytes("<table>" + LINE_SEPARATOR);
                this.file.writeBytes("<table width='100%' border='1' bordercolor='#336633'>" + LINE_SEPARATOR);
                this.file.writeBytes("<tr>" + LINE_SEPARATOR);
                this.file.writeBytes("<td width='12%' class='h'><b>Time Stamp</b></td>" + LINE_SEPARATOR);
                this.file.writeBytes("<td width='5%' class='h'><b>Thread ID</b></td>" + LINE_SEPARATOR);
                this.file.writeBytes("<td width='9%' class='h'><b>Class</b></td>" + LINE_SEPARATOR);
                this.file.writeBytes("<td width='8%' class='h'><b>Method</b></td>" + LINE_SEPARATOR);
                this.file.writeBytes("<td width='6%' class='h'><b>Level</b></td>" + LINE_SEPARATOR);
                this.file.writeBytes("<td width='60%' class='h'><b>Message</b></td>" + LINE_SEPARATOR);
                this.file.writeBytes("</tr>" + LINE_SEPARATOR);
                this.currentPointer = this.file.getFilePointer();
                this.file.writeBytes(TAIL);
                this.file.seek(this.currentPointer);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String getTable(Throwable th) {
        if (th == null) {
            return "";
        }
        StringBuffer buff = new StringBuffer("<table height='100%' width='100%' align='center' border='0'>");
        StackTraceElement[] elements = th.getStackTrace();
        buff.append(this.row(th.getMessage()));
        for (int i = 0; i < elements.length; ++i) {
            buff.append(this.row(elements[i].toString()));
        }
        buff.append("</table>");
        return buff.toString();
    }

    private String row(String message) {
        return "<tr align='left'><td class='l'>" + message + "</td></tr>";
    }
}

