/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.auth.iam;

import com.dbeaver.net.auth.iam.AuthModelIAMAbstract;
import com.dbeaver.net.auth.iam.IAMAuthType;
import com.dbeaver.ui.auth.iam.AuthModelIAMMessages;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.auth.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.DatabaseNativeAuthModelConfigurator;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.dbeaver.utils.HelpUtils;
import org.jkiss.utils.CommonUtils;
import software.amazon.awssdk.profiles.Profile;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.regions.Region;

public class AuthModelIAMConfigurator
extends DatabaseNativeAuthModelConfigurator {
    private static final Log log = Log.getLog(AuthModelIAMConfigurator.class);
    private Label regionLabel;
    private Combo regionCombo;
    private Label authTypeLabel;
    private Composite authTypeGroup;
    private Combo authTypeCombo;
    private final List<IAMAuthType> authTypes = new ArrayList<IAMAuthType>();
    private Label awsAccessKeyLabel;
    private Text awsAccessKeyText;
    private Label awsSecretKeyLabel;
    private Text awsSecretKeyText;
    private Button awsSaveKeysCheck;
    private Label awsProfileNameLabel;
    private Combo awsProfileNameCombo;
    private Control awsProfileFiller;
    private Button iamSSOCheckbox;
    private Link ssoDocsLink;
    private Button use3rdPartyAccessCheckbox;
    private Label iamAccountIdLabel;
    private Text iamAccountIdText;
    private Label iamRoleNameLabel;
    private Text iamRoleNameText;
    protected IAMAuthType curConfigType = IAMAuthType.DEFAULT;
    protected boolean isCloudProvided;
    private Label authTypeFiller;

    public boolean isCloudProvided() {
        return this.isCloudProvided;
    }

    public void setCloudProvided(boolean cloudProvided) {
        this.isCloudProvided = cloudProvided;
    }

    protected IAMAuthType[] getSupportedAuthTypes() {
        return new IAMAuthType[]{IAMAuthType.DEFAULT, IAMAuthType.PROFILE, IAMAuthType.KEY};
    }

    protected boolean isPasswordApplicable() {
        return false;
    }

    protected boolean isSavePasswordLocally() {
        return true;
    }

    public void createControl(Composite parent, Runnable propertyChangeListener) {
        Composite iamGroup = parent;
        Composite authGroup = UIUtils.createComposite((Composite)iamGroup, (int)4);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        authGroup.setLayoutData((Object)gd);
        this.createIAMAuthControls(authGroup, propertyChangeListener, true);
    }

    public void createIAMAuthControls(Composite iamGroup, final Runnable propertyChangeListener, boolean databaseConfig) {
        GridData gd;
        SelectionAdapter selChangelistener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                propertyChangeListener.run();
            }
        };
        boolean isWide = this.isWide(iamGroup);
        this.authTypeLabel = UIUtils.createControlLabel((Composite)iamGroup, (String)AuthModelIAMMessages.model_iam_auth_type);
        this.authTypeGroup = UIUtils.createComposite((Composite)iamGroup, (int)2);
        this.authTypeGroup.setLayoutData((Object)new GridData(768));
        this.authTypeCombo = new Combo(this.authTypeGroup, 12);
        this.authTypeCombo.setLayoutData((Object)new GridData(768));
        this.authTypeCombo.setToolTipText(AuthModelIAMMessages.model_iam_auth_type_tip);
        this.authTypeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IAMAuthType ct = (IAMAuthType)AuthModelIAMConfigurator.this.authTypes.get(AuthModelIAMConfigurator.this.authTypeCombo.getSelectionIndex());
                AuthModelIAMConfigurator.this.changeAuthType(ct);
                propertyChangeListener.run();
            }
        });
        Link awsCredDocsLink = new Link(this.authTypeGroup, 0);
        awsCredDocsLink.setText("<a>Details</a>");
        awsCredDocsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)"AWS-Credentials"));
            }
        });
        if (isWide) {
            this.authTypeFiller = new Label(iamGroup, 0);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            this.authTypeFiller.setLayoutData((Object)gd);
        }
        this.awsProfileNameLabel = UIUtils.createControlLabel((Composite)iamGroup, (String)AuthModelIAMMessages.model_iam_aws_profile_name);
        this.awsProfileNameCombo = new Combo(iamGroup, 12);
        GridData gd2 = new GridData(768);
        this.awsProfileNameCombo.setLayoutData((Object)gd2);
        this.awsProfileNameCombo.setToolTipText(AuthModelIAMMessages.model_iam_aws_profile_name_tip);
        for (Profile profile : ProfileFile.defaultProfileFile().profiles().values()) {
            this.awsProfileNameCombo.add(profile.name());
        }
        this.awsProfileNameCombo.addSelectionListener((SelectionListener)selChangelistener);
        if (isWide) {
            this.awsProfileFiller = UIUtils.createEmptyLabel((Composite)iamGroup, (int)2, (int)1);
        }
        this.createExtraIAMAuthSelectors(iamGroup, propertyChangeListener, isWide);
        if (databaseConfig) {
            this.usernameLabel = UIUtils.createControlLabel((Composite)iamGroup, (String)AuthModelIAMMessages.model_iam_database_username);
            this.usernameLabel.setLayoutData((Object)new GridData(32));
            this.createUserNameControls(iamGroup, propertyChangeListener);
            gd2 = new GridData(768);
            this.usernameText.setLayoutData((Object)gd2);
            this.usernameText.setToolTipText(AuthModelIAMMessages.model_iam_database_username_tip);
            this.regionLabel = new Label(iamGroup, 16384);
            this.regionLabel.setText(String.valueOf(AuthModelIAMMessages.model_iam_region) + ":");
            gd2 = new GridData(32);
            this.regionLabel.setLayoutData((Object)gd2);
            this.regionCombo = new Combo(iamGroup, 4);
            gd2 = new GridData(768);
            this.regionCombo.setLayoutData((Object)gd2);
            this.regionCombo.setToolTipText(AuthModelIAMMessages.model_iam_region_help);
        }
        this.createPasswordControls(iamGroup, propertyChangeListener);
        if (this.isWide(iamGroup)) {
            ((GridData)this.passPlaceholder.getLayoutData()).horizontalSpan = 3;
        }
        this.awsAccessKeyLabel = UIUtils.createControlLabel((Composite)iamGroup, (String)AuthModelIAMMessages.model_iam_aws_access_key);
        this.awsAccessKeyText = new Text(iamGroup, 2048);
        gd2 = new GridData(768);
        this.awsAccessKeyText.setLayoutData((Object)gd2);
        this.awsAccessKeyText.setToolTipText(AuthModelIAMMessages.model_iam_aws_access_key_help);
        this.awsAccessKeyText.addModifyListener(e -> propertyChangeListener.run());
        this.awsSecretKeyLabel = UIUtils.createControlLabel((Composite)iamGroup, (String)AuthModelIAMMessages.model_iam_aws_secret_key);
        ((GridData)this.awsSecretKeyLabel.getLayoutData()).horizontalAlignment = 3;
        this.awsSecretKeyText = new Text(iamGroup, 0x400800);
        gd2 = new GridData(768);
        this.awsSecretKeyText.setLayoutData((Object)gd2);
        this.awsSecretKeyText.setToolTipText(AuthModelIAMMessages.model_iam_aws_secret_key_help);
        this.awsSecretKeyText.addModifyListener(e -> propertyChangeListener.run());
        this.awsSaveKeysCheck = UIUtils.createCheckbox((Composite)iamGroup, (String)"Save credentials locally", (String)"Save access/secret keys in local secured storage", (this.dataSource == null || this.dataSource.isSavePassword() ? 1 : 0) != 0, (int)(isWide ? 4 : 2));
        this.awsSaveKeysCheck.setToolTipText(UIConnectionMessages.dialog_connection_wizard_final_checkbox_save_password_locally);
        this.awsSaveKeysCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuthModelIAMConfigurator.this.enableAccessControls();
            }
        });
        this.createExtraIAMAuthControls(iamGroup, propertyChangeListener, isWide);
        Composite optionsGroup = UIUtils.createComposite((Composite)iamGroup, (int)2);
        gd = new GridData(768);
        gd.horizontalSpan = isWide ? 4 : 2;
        optionsGroup.setLayoutData((Object)gd);
        this.iamSSOCheckbox = UIUtils.createCheckbox((Composite)optionsGroup, (String)"Enable SSO", (String)"Enable Single Sign On (SSO) authorization using AWS CLI", (boolean)false, (int)1);
        this.iamSSOCheckbox.addSelectionListener((SelectionListener)selChangelistener);
        this.ssoDocsLink = new Link(optionsGroup, 0);
        this.ssoDocsLink.setText("<a>Instructions</a>");
        this.ssoDocsLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIUtils.launchProgram((String)HelpUtils.getHelpExternalReference((String)"AWS-SSO"));
            }
        });
        this.use3rdPartyAccessCheckbox = UIUtils.createCheckbox((Composite)optionsGroup, (String)AuthModelIAMMessages.model_iam_use_cross_account, (String)AuthModelIAMMessages.model_iam_use_cross_account_tip, (boolean)false, (int)2);
        this.use3rdPartyAccessCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuthModelIAMConfigurator.this.updateIAMSettingsVisibility();
            }
        });
        this.iamAccountIdLabel = UIUtils.createControlLabel((Composite)iamGroup, (String)AuthModelIAMMessages.model_iam_aws_account_id);
        this.iamAccountIdText = new Text(iamGroup, 2048);
        gd2 = new GridData(768);
        this.iamAccountIdText.setLayoutData((Object)gd2);
        this.iamAccountIdText.setToolTipText(AuthModelIAMMessages.model_iam_aws_account_id_tip);
        this.iamRoleNameLabel = UIUtils.createControlLabel((Composite)iamGroup, (String)AuthModelIAMMessages.model_iam_aws_role_name);
        ((GridData)this.iamRoleNameLabel.getLayoutData()).horizontalAlignment = 3;
        this.iamRoleNameText = new Text(iamGroup, 2048);
        gd2 = new GridData(768);
        this.iamRoleNameText.setLayoutData((Object)gd2);
        this.iamRoleNameText.setToolTipText(AuthModelIAMMessages.model_iam_aws_role_name_tip);
        this.changeAuthType(this.curConfigType);
    }

    public boolean isWide(Composite iamGroup) {
        return ((GridLayout)iamGroup.getLayout()).numColumns > 2;
    }

    protected void createExtraIAMAuthSelectors(Composite iamGroup, Runnable propertyChangeListener, boolean isWide) {
    }

    protected void createExtraIAMAuthControls(Composite iamGroup, Runnable propertyChangeListener, boolean isWide) {
    }

    private void enableAccessControls() {
        this.awsAccessKeyText.setEnabled(this.awsSaveKeysCheck.getSelection());
        this.awsSecretKeyText.setEnabled(this.awsSaveKeysCheck.getSelection());
    }

    private void changeAuthType(IAMAuthType ct) {
        this.curConfigType = ct;
        this.updateIAMSettingsVisibility();
    }

    protected void updateIAMSettingsVisibility() {
        UIUtils.setControlVisible((Control)this.authTypeLabel, (!this.isCloudProvided ? 1 : 0) != 0);
        UIUtils.setControlVisible((Control)this.authTypeGroup, (!this.isCloudProvided ? 1 : 0) != 0);
        if (this.authTypeFiller != null) {
            UIUtils.setControlVisible((Control)this.authTypeFiller, (!this.isCloudProvided ? 1 : 0) != 0);
        }
        if (this.passwordLabel != null) {
            boolean isPasswordVisible = this.isPasswordApplicable();
            UIUtils.setControlVisible((Control)this.passwordLabel, (boolean)isPasswordVisible);
            UIUtils.setControlVisible((Control)this.passPlaceholder, (boolean)isPasswordVisible);
        }
        boolean akVisible = !this.isCloudProvided && this.curConfigType == IAMAuthType.KEY;
        UIUtils.setControlVisible((Control)this.awsAccessKeyLabel, (boolean)akVisible);
        UIUtils.setControlVisible((Control)this.awsAccessKeyText, (boolean)akVisible);
        UIUtils.setControlVisible((Control)this.awsSecretKeyLabel, (boolean)akVisible);
        UIUtils.setControlVisible((Control)this.awsSecretKeyText, (boolean)akVisible);
        UIUtils.setControlVisible((Control)this.awsSaveKeysCheck, (boolean)akVisible);
        boolean pnVisible = !this.isCloudProvided && this.curConfigType == IAMAuthType.PROFILE;
        UIUtils.setControlVisible((Control)this.awsProfileNameLabel, (boolean)pnVisible);
        UIUtils.setControlVisible((Control)this.awsProfileNameCombo, (boolean)pnVisible);
        if (this.awsProfileFiller != null) {
            UIUtils.setControlVisible((Control)this.awsProfileFiller, (boolean)pnVisible);
        }
        this.updateExtraIAMSettingsVisibility();
        boolean ssoVisible = !this.isCloudProvided && this.curConfigType.isSupportsSSO();
        UIUtils.setControlVisible((Control)this.iamSSOCheckbox, (boolean)ssoVisible);
        UIUtils.setControlVisible((Control)this.ssoDocsLink, (boolean)ssoVisible);
        UIUtils.setControlVisible((Control)this.use3rdPartyAccessCheckbox, (!this.isCloudProvided && this.curConfigType.isSupportsAssumeRole() ? 1 : 0) != 0);
        boolean accountIdEnabled = !this.isCloudProvided && this.curConfigType.isSupportsAssumeRole() && this.use3rdPartyAccessCheckbox.getSelection();
        UIUtils.setControlVisible((Control)this.iamAccountIdLabel, (boolean)accountIdEnabled);
        UIUtils.setControlVisible((Control)this.iamAccountIdText, (boolean)accountIdEnabled);
        UIUtils.setControlVisible((Control)this.iamRoleNameLabel, (boolean)accountIdEnabled);
        UIUtils.setControlVisible((Control)this.iamRoleNameText, (boolean)accountIdEnabled);
        this.awsAccessKeyText.getShell().layout(true, true);
    }

    public boolean isSSOEnabled() {
        return this.iamSSOCheckbox.getSelection();
    }

    protected void updateExtraIAMSettingsVisibility() {
    }

    public void loadSettings(DBPDataSourceContainer dataSource) {
        super.loadSettings(dataSource);
        this.initAuthTypes();
        DBPConnectionConfiguration configuration = dataSource.getConnectionConfiguration();
        this.isCloudProvided = !"local".equals(dataSource.getOrigin().getType());
        DBAAuthModel authModel = configuration.getAuthModel();
        if (!(authModel instanceof AuthModelIAMAbstract && ((AuthModelIAMAbstract)authModel).supportsDatabaseUser() || this.usernameLabel == null)) {
            UIUtils.setControlVisible((Control)this.usernameLabel, (boolean)false);
            UIUtils.setControlVisible((Control)this.usernameText, (boolean)false);
            UIUtils.setControlVisible((Control)this.regionLabel, (boolean)false);
            UIUtils.setControlVisible((Control)this.regionCombo, (boolean)false);
            this.usernameLabel.getParent().getParent().layout(true, true);
        }
        List<String> regions = AuthModelIAMConfigurator.getPublicRegions();
        for (String region : regions) {
            this.regionCombo.add(region);
        }
        if (!CommonUtils.isEmpty((String)configuration.getAuthProperty("iam.region"))) {
            this.regionCombo.setText(CommonUtils.notEmpty((String)configuration.getAuthProperty("iam.region")));
        }
        LinkedHashMap<String, String> authProperties = new LinkedHashMap<String, String>();
        if (configuration.getAuthProperties() != null) {
            authProperties.putAll(configuration.getAuthProperties());
        }
        if (!authProperties.containsKey("iam.aws_access_key") && !CommonUtils.isEmpty((String)configuration.getUserName()) && configuration.getUserName().length() == 20) {
            authProperties.put("iam.aws_access_key", configuration.getUserName());
        }
        if (!authProperties.containsKey("iam.aws_secret_key") && !CommonUtils.isEmpty((String)configuration.getUserPassword()) && configuration.getUserPassword().length() == 40) {
            authProperties.put("iam.aws_secret_key", configuration.getUserPassword());
        }
        this.loadIAMAuthSettings(authProperties);
        this.authTypeCombo.select(this.authTypes.indexOf(this.curConfigType));
        this.awsSaveKeysCheck.setSelection(dataSource.isSavePassword());
        this.updateIAMSettingsVisibility();
        this.authTypeCombo.setEnabled(!this.isCloudProvided);
        this.awsAccessKeyText.setEnabled(!this.isCloudProvided);
        this.awsSecretKeyText.setEnabled(!this.isCloudProvided);
        this.regionCombo.setEnabled(!this.isCloudProvided);
        this.awsProfileNameCombo.setEnabled(!this.isCloudProvided);
        this.use3rdPartyAccessCheckbox.setEnabled(!this.isCloudProvided);
        this.iamAccountIdText.setEnabled(!this.isCloudProvided);
        this.iamRoleNameText.setEnabled(!this.isCloudProvided);
        if (!this.isCloudProvided) {
            this.enableAccessControls();
        }
    }

    public void initAuthTypes() {
        this.authTypeCombo.removeAll();
        this.authTypes.clear();
        IAMAuthType[] iAMAuthTypeArray = this.getSupportedAuthTypes();
        int n = iAMAuthTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAMAuthType ct = iAMAuthTypeArray[n2];
            this.authTypes.add(ct);
            this.authTypeCombo.add(ct.getTitle());
            ++n2;
        }
    }

    @NotNull
    public static List<String> getPublicRegions() {
        return Region.regions().stream().map(Region::id).filter(r -> !r.startsWith("aws") && !r.contains("-iso") && !r.contains("-gov")).sorted().collect(Collectors.toList());
    }

    public void loadIAMAuthSettings(Map<String, String> authProperties) {
        this.curConfigType = CommonUtils.getBoolean((String)authProperties.get("iam.use_default_aws"), (boolean)Boolean.FALSE) ? IAMAuthType.DEFAULT : IAMAuthType.KEY;
        if (!CommonUtils.isEmpty((String)CommonUtils.toString((Object)authProperties.get("iam.profile_name")))) {
            this.curConfigType = IAMAuthType.PROFILE;
        }
        this.awsAccessKeyText.setText(CommonUtils.notEmpty((String)authProperties.get("iam.aws_access_key")));
        this.awsSecretKeyText.setText(CommonUtils.notEmpty((String)authProperties.get("iam.aws_secret_key")));
        this.awsProfileNameCombo.setText(CommonUtils.notEmpty((String)authProperties.get("iam.profile_name")));
        this.iamAccountIdText.setText(CommonUtils.notEmpty((String)authProperties.get("iam.account_id")));
        this.iamRoleNameText.setText(CommonUtils.notEmpty((String)authProperties.get("iam.role_name")));
        this.iamSSOCheckbox.setSelection(CommonUtils.getBoolean((String)authProperties.get("iam.sso_over_cli"), (boolean)Boolean.FALSE));
        this.use3rdPartyAccessCheckbox.setSelection(CommonUtils.getBoolean((String)authProperties.get("iam.cross_account_access"), (boolean)Boolean.FALSE));
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        super.saveSettings(dataSource);
        DBPConnectionConfiguration configuration = dataSource.getConnectionConfiguration();
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        props.put("iam.region", this.regionCombo.getText());
        this.saveIAMAuthSettings(props);
        configuration.setAuthProperties(props);
        dataSource.setSavePassword(this.isSavePasswordLocally() && (this.awsSaveKeysCheck.isVisible() && this.awsSaveKeysCheck.getSelection() || this.savePasswordCheck != null && this.savePasswordCheck.getSelection()));
    }

    public void saveIAMAuthSettings(Map<String, String> props) {
        if (this.curConfigType == IAMAuthType.KEY && this.awsSaveKeysCheck.getSelection()) {
            props.put("iam.aws_access_key", this.awsAccessKeyText.getText());
            props.put("iam.aws_secret_key", this.awsSecretKeyText.getText());
        } else {
            props.remove("iam.aws_access_key");
            props.remove("iam.aws_secret_key");
        }
        if (this.curConfigType == IAMAuthType.PROFILE) {
            props.put("iam.profile_name", this.awsProfileNameCombo.getText());
        } else {
            props.remove("iam.profile_name");
        }
        props.put("iam.use_default_aws", String.valueOf(this.curConfigType == IAMAuthType.DEFAULT));
        props.put("iam.account_id", this.iamAccountIdText.getText());
        props.put("iam.role_name", this.iamRoleNameText.getText());
        props.put("iam.sso_over_cli", String.valueOf(this.iamSSOCheckbox.getSelection()));
        props.put("iam.cross_account_access", String.valueOf(this.use3rdPartyAccessCheckbox.getSelection()));
    }

    public void resetSettings(DBPDataSourceContainer dataSource) {
    }

    public boolean isComplete() {
        if (IAMAuthType.KEY == this.curConfigType) {
            return true;
        }
        if (IAMAuthType.DEFAULT == this.curConfigType) {
            return true;
        }
        if (IAMAuthType.PROFILE == this.curConfigType) {
            return this.awsProfileNameCombo.getSelectionIndex() >= 0;
        }
        return false;
    }

    public void updateControls() {
        this.authTypeCombo.select(this.authTypes.indexOf(this.curConfigType));
        this.changeAuthType(this.curConfigType);
    }
}

