/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util.security;

import com.sap.dbtech.util.Tracer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SCRAMMD5 {
    public static final String algorithmname = "SCRAMMD5";
    public static final int clientProofSize = 16;

    private static byte[] hmacMD5(byte[] data, byte[] key) throws NoSuchAlgorithmException {
        int i;
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        if (key.length > 64) {
            md5.update(key);
            key = md5.digest();
        }
        byte[] ipad = new byte[64];
        byte[] opad = new byte[64];
        for (i = 0; i < 64; ++i) {
            ipad[i] = 54;
            opad[i] = 92;
        }
        for (i = key.length - 1; i >= 0; --i) {
            int n = i;
            ipad[n] = (byte)(ipad[n] ^ key[i]);
            int n2 = i;
            opad[n2] = (byte)(opad[n2] ^ key[i]);
        }
        byte[] content = new byte[data.length + 64];
        System.arraycopy(ipad, 0, content, 0, 64);
        System.arraycopy(data, 0, content, 64, data.length);
        data = md5.digest(content);
        content = new byte[data.length + 64];
        System.arraycopy(opad, 0, content, 0, 64);
        System.arraycopy(data, 0, content, 64, data.length);
        return md5.digest(content);
    }

    private static void RTESec_DumpHex(String text, byte[] bytearr) {
        System.out.println(text + ": " + Tracer.Hex2String(bytearr));
    }

    public static byte[] scrammMD5(byte[] salt, byte[] password, byte[] clientkey, byte[] serverkey) throws NoSuchAlgorithmException {
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        byte[] salted_pass = SCRAMMD5.hmacMD5(salt, password);
        byte[] client_key = md5.digest(salted_pass);
        byte[] client_verifier = md5.digest(client_key);
        int saltLen = salt.length;
        int serverkeyLen = serverkey.length;
        int clientkeyLen = clientkey.length;
        byte[] content = new byte[saltLen + serverkeyLen + clientkeyLen];
        System.arraycopy(salt, 0, content, 0, saltLen);
        System.arraycopy(serverkey, 0, content, saltLen, serverkeyLen);
        System.arraycopy(clientkey, 0, content, saltLen + serverkeyLen, clientkey.length);
        byte[] shared_key = SCRAMMD5.hmacMD5(content, client_verifier);
        byte[] client_proof = new byte[shared_key.length];
        for (int i = shared_key.length - 1; i >= 0; --i) {
            client_proof[i] = (byte)(shared_key[i] ^ client_key[i]);
        }
        return client_proof;
    }

    public static void maintest(String[] args) {
        String client_proof = "5d7f4505accba4e92c5778ea808dbc6a";
        byte[] salt = "der Salt".getBytes();
        byte[] password = "secret".getBytes();
        byte[] clientkey = "eine UserId und eine Zufallszahl".getBytes();
        byte[] serverkey = "-Value und eine andere Zufallszahl".getBytes();
        try {
            byte[] erg = SCRAMMD5.scrammMD5(salt, password, clientkey, serverkey);
            SCRAMMD5.RTESec_DumpHex("scrammMD5: client_proof", erg);
            String ergAsString = Tracer.Hex2String(erg);
            if (!client_proof.equalsIgnoreCase(ergAsString)) {
                System.out.println("Error wrong client proof: \nfound: " + ergAsString + "\nexpected " + client_proof);
            } else {
                System.out.println("Correct client proof computed");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

