/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.CharDataTranslator;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class TimeTranslator
extends CharDataTranslator {
    private static final int TimeSize_C = 8;

    TimeTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
    }

    protected TimeTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out) {
        this(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, false, false);
    }

    public Object getObject(SQLParamController controller, DataPart mem) throws SQLException {
        return this.getTime(controller, mem, null);
    }

    public String getString(SQLParamController controller, DataPart mem) throws SQLException {
        String result = null;
        if (!this.isNull(controller, mem)) {
            result = mem.getString(this.bufpos_output, this.physicalLength - 1);
        }
        return result;
    }

    protected int parseHours(byte[] raw) throws SQLException {
        return (raw[0] - 48) * 10 + (raw[1] - 48);
    }

    protected int parseMinutes(byte[] raw) {
        return (raw[3] - 48) * 10 + (raw[4] - 48);
    }

    protected int parseSeconds(byte[] raw) {
        return (raw[6] - 48) * 10 + (raw[7] - 48);
    }

    public Time getTime(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        Time result = null;
        if (!this.isNull(controller, mem)) {
            byte[] raw = mem.getBytes(this.bufpos_output, this.physicalLength - 1);
            int hour = this.parseHours(raw);
            int min = this.parseMinutes(raw);
            int sec = this.parseSeconds(raw);
            if (cal == null) {
                result = new Time(hour, min, sec);
            } else {
                cal.clear();
                cal.set(1970, 0, 1, hour, min, sec);
                result = DBTechTranslator.CalendarUtil.getTimeFromCalendar(cal);
            }
        }
        return result;
    }

    public Timestamp getTimestamp(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        Time timeValue = this.getTime(controller, mem, cal);
        if (timeValue == null) {
            return null;
        }
        return new Timestamp(timeValue.getTime());
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Object transSpecificForInput(Object obj) throws SQLException {
        Object result = null;
        if (obj instanceof Time) {
            result = this.transTimeForInput((Time)obj, Calendar.getInstance());
        }
        return result;
    }

    public Object transStringForInput(String val) throws SQLException {
        if (val == null) {
            return null;
        }
        try {
            return this.transTimeForInput(Time.valueOf(val), Calendar.getInstance());
        }
        catch (IllegalArgumentException exc) {
            try {
                Timestamp ts = Timestamp.valueOf(val);
                return this.transTimeForInput(new Time(ts.getTime()), Calendar.getInstance());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw this.newParseException(val, "Time");
            }
        }
    }

    public Object transTimeForInput(Time arg, Calendar cal) throws SQLException {
        if (arg == null) {
            return null;
        }
        cal.setTime(arg);
        int hours = cal.get(11);
        int minutes = cal.get(12);
        int seconds = cal.get(13);
        return this.formatTime(hours, minutes, seconds);
    }

    protected byte[] formatTime(int hours, int minutes, int seconds) {
        byte[] formattedTime = new byte[]{HighTime_C[hours], LowTime_C[hours], 58, (byte)(48 + minutes / 10), (byte)(48 + minutes % 10), 58, (byte)(48 + seconds / 10), (byte)(48 + seconds % 10)};
        return formattedTime;
    }

    protected void putSpecific(DataPart dataPart, Object data) throws SQLException {
        byte[] bytes = (byte[])data;
        this.checkFieldLimits(bytes.length);
        dataPart.putDefineByte(32, this.bufpos_input - 1);
        dataPart.putStringBytes(bytes, this.bufpos_input, this.physicalLength - 1);
    }
}

