/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.jdbc.translators.TimestampTranslator;
import java.sql.SQLException;

public class InternalTimestampTranslator
extends TimestampTranslator {
    public InternalTimestampTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
    }

    protected int parseYear(byte[] raw) {
        int year = (raw[0] - 48) * 1000;
        year += (raw[1] - 48) * 100;
        year += (raw[2] - 48) * 10;
        return year += raw[3] - 48;
    }

    protected int parseMonth(byte[] raw) {
        int month = (raw[4] - 48) * 10;
        return month += raw[5] - 48;
    }

    protected int parseDay(byte[] raw) {
        int day = (raw[6] - 48) * 10;
        return day += raw[7] - 48;
    }

    protected int parseHours(byte[] raw) {
        int hour = (raw[8] - 48) * 10;
        return hour += raw[9] - 48;
    }

    protected int parseMinutes(byte[] raw) {
        int min = (raw[10] - 48) * 10;
        return min += raw[11] - 48;
    }

    protected int parseSeconds(byte[] raw) {
        int sec = (raw[12] - 48) * 10;
        return sec += raw[13] - 48;
    }

    protected int parseNanoseconds(byte[] raw) {
        int milli = (raw[14] - 48) * 100;
        milli += (raw[15] - 48) * 10;
        int nano = ((milli += raw[16] - 48) * 10 + (raw[17] - 48)) * 100;
        nano += (raw[18] - 48) * 10;
        nano += raw[19] - 48;
        return nano *= 1000;
    }

    protected byte[] formatTimestamp(int year, int month, int day, int hour, int minute, int second, int nano) {
        byte[] formattedTimestamp = new byte[20];
        formattedTimestamp[0] = (byte)(48 + year / 1000);
        formattedTimestamp[1] = (byte)(48 + (year %= 1000) / 100);
        formattedTimestamp[2] = (byte)(48 + (year %= 100) / 10);
        formattedTimestamp[3] = (byte)(48 + (year %= 10));
        formattedTimestamp[4] = HighTime_C[month];
        formattedTimestamp[5] = LowTime_C[month];
        formattedTimestamp[6] = HighTime_C[day];
        formattedTimestamp[7] = LowTime_C[day];
        formattedTimestamp[8] = HighTime_C[hour];
        formattedTimestamp[9] = LowTime_C[hour];
        formattedTimestamp[10] = (byte)(48 + minute / 10);
        formattedTimestamp[11] = (byte)(48 + minute % 10);
        formattedTimestamp[12] = (byte)(48 + second / 10);
        formattedTimestamp[13] = (byte)(48 + second % 10);
        int tmpVal = nano / 1000;
        formattedTimestamp[14] = (byte)(48 + tmpVal / 100000);
        formattedTimestamp[15] = (byte)(48 + (tmpVal %= 100000) / 10000);
        formattedTimestamp[16] = (byte)(48 + (tmpVal %= 10000) / 1000);
        formattedTimestamp[17] = (byte)(48 + (tmpVal %= 1000) / 100);
        formattedTimestamp[18] = (byte)(48 + (tmpVal %= 100) / 10);
        formattedTimestamp[19] = (byte)(48 + (tmpVal %= 10));
        return formattedTimestamp;
    }

    public String getString(SQLParamController controller, DataPart mem) throws SQLException {
        String result = null;
        if (!this.isNull(controller, mem)) {
            byte[] raw = mem.getBytes(this.bufpos_output, this.physicalLength - 1);
            byte[] tmpArr = new byte[]{raw[0], raw[1], raw[2], raw[3], 45, raw[4], raw[5], 45, raw[6], raw[7], 32, raw[8], raw[9], 58, raw[10], raw[11], 58, raw[12], raw[13], 46, raw[14], raw[15], raw[16], raw[17], raw[18], raw[19]};
            result = new String(tmpArr);
        }
        return result;
    }
}

