/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.DateTranslator;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import java.sql.SQLException;

public class InternalDateTranslator
extends DateTranslator {
    public InternalDateTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
    }

    protected int parseYear(byte[] raw) {
        int year = (raw[0] - 48) * 1000;
        year += (raw[1] - 48) * 100;
        year += (raw[2] - 48) * 10;
        return year += raw[3] - 48;
    }

    protected int parseMonth(byte[] raw) {
        int month = (raw[4] - 48) * 10;
        return month += raw[5] - 48;
    }

    protected int parseDay(byte[] raw) {
        int day = (raw[6] - 48) * 10;
        return day += raw[7] - 48;
    }

    protected byte[] formatDate(int year, int month, int day) {
        byte[] formattedDate = new byte[]{(byte)(48 + year / 1000), (byte)(48 + (year %= 1000) / 100), (byte)(48 + (year %= 100) / 10), (byte)(48 + (year %= 10)), HighTime_C[month], LowTime_C[month], HighTime_C[day], LowTime_C[day]};
        return formattedDate;
    }

    public String getString(SQLParamController controller, DataPart mem) throws SQLException {
        String result = null;
        if (!this.isNull(controller, mem)) {
            byte[] raw = mem.getBytes(this.bufpos_output, this.physicalLength - 1);
            byte[] tmpArr = new byte[]{raw[0], raw[1], raw[2], raw[3], 45, raw[4], raw[5], 45, raw[6], raw[7]};
            result = new String(tmpArr);
        }
        return result;
    }
}

