/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc;

import com.sap.dbtech.jdbc.CallableStatementSapDB;
import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.Parseinfo;
import com.sap.dbtech.jdbc.packet.RequestPacket;
import com.sap.dbtech.jdbc.trace.log.PreparedStatement;
import java.sql.Connection;
import java.sql.SQLException;

public class PeekAndPoke {
    private PeekAndPoke() {
    }

    public static byte[] getParseId(java.sql.PreparedStatement stmt) {
        CallableStatementSapDB realStmt = PeekAndPoke.getRealStatement(stmt);
        byte[] result = realStmt.parseinfo.getMassParseid() != null ? realStmt.parseinfo.getMassParseid() : realStmt.parseinfo.getParseId();
        return result;
    }

    public static byte[] getParseIdForMonitor(java.sql.PreparedStatement stmt) {
        CallableStatementSapDB realStmt = PeekAndPoke.getRealStatement(stmt);
        byte[] result = PeekAndPoke.getParseId(realStmt);
        if (result != null) {
            result[result.length - 2] = 0;
        }
        return result;
    }

    public static void syntaxCheck(Connection connArg, String sqlCmd) throws SQLException {
        ConnectionSapDB connection = (ConnectionSapDB)connArg;
        RequestPacket requestPacket = connection.getRequestPacket(false);
        requestPacket.initSyntaxOnlyCommand(sqlCmd);
        connection.execute(requestPacket, connection, 1);
    }

    public static Parseinfo getParseinfo(java.sql.PreparedStatement stmt) {
        CallableStatementSapDB realStmt = PeekAndPoke.getRealStatement(stmt);
        return realStmt.parseinfo;
    }

    private static CallableStatementSapDB getRealStatement(java.sql.PreparedStatement stmt) {
        if (stmt instanceof PreparedStatement) {
            return (CallableStatementSapDB)((PreparedStatement)stmt).getInner();
        }
        if (stmt instanceof CallableStatementSapDB) {
            return (CallableStatementSapDB)stmt;
        }
        return null;
    }
}

