/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.preferences;

import java.util.HashMap;
import java.util.Map;
import org.jkiss.dbeaver.model.impl.preferences.AbstractPreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.utils.CommonUtils;

public abstract class SimplePreferenceStore
extends AbstractPreferenceStore {
    private DBPPreferenceStore parentStore;
    private Map<String, String> properties;
    private Map<String, String> defaultProperties = new HashMap<String, String>();
    private boolean dirty = false;

    public SimplePreferenceStore() {
        this.properties = new HashMap<String, String>();
    }

    protected SimplePreferenceStore(DBPPreferenceStore parentStore) {
        this();
        this.parentStore = parentStore;
    }

    public DBPPreferenceStore getParentStore() {
        return this.parentStore;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = new HashMap<String, String>(properties);
    }

    public Map<String, String> getDefaultProperties() {
        return this.defaultProperties;
    }

    public void setDefaultProperties(Map<String, String> defaultProperties) {
        this.defaultProperties = new HashMap<String, String>(defaultProperties);
    }

    public void clear() {
        this.properties.clear();
    }

    @Override
    public void addPropertyChangeListener(DBPPreferenceListener listener) {
        this.addListenerObject(listener);
    }

    @Override
    public void removePropertyChangeListener(DBPPreferenceListener listener) {
        this.removeListenerObject(listener);
    }

    @Override
    public boolean contains(String name) {
        return this.properties.containsKey(name);
    }

    @Override
    public boolean getBoolean(String name) {
        return this.toBoolean(this.getString(name));
    }

    @Override
    public boolean getDefaultBoolean(String name) {
        return this.toBoolean(this.getDefaultString(name));
    }

    private boolean toBoolean(String value) {
        return value != null && value.equals("true");
    }

    @Override
    public double getDouble(String name) {
        return this.toDouble(this.getString(name));
    }

    @Override
    public double getDefaultDouble(String name) {
        return this.toDouble(this.getDefaultString(name));
    }

    private double toDouble(String value) {
        double ival = 0.0;
        if (!CommonUtils.isEmpty((String)value)) {
            try {
                ival = Double.parseDouble(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return ival;
    }

    @Override
    public float getFloat(String name) {
        return this.toFloat(this.getString(name));
    }

    @Override
    public float getDefaultFloat(String name) {
        return this.toFloat(this.getDefaultString(name));
    }

    private float toFloat(String value) {
        float ival = 0.0f;
        if (!CommonUtils.isEmpty((String)value)) {
            try {
                ival = Float.parseFloat(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return ival;
    }

    @Override
    public int getInt(String name) {
        return this.toInt(this.getString(name));
    }

    @Override
    public int getDefaultInt(String name) {
        return this.toInt(this.getDefaultString(name));
    }

    private int toInt(String value) {
        int ival = 0;
        if (!CommonUtils.isEmpty((String)value)) {
            try {
                ival = Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return ival;
    }

    @Override
    public long getLong(String name) {
        return this.toLong(this.getString(name));
    }

    @Override
    public long getDefaultLong(String name) {
        return this.toLong(this.getDefaultString(name));
    }

    private long toLong(String value) {
        long ival = 0L;
        if (!CommonUtils.isEmpty((String)value)) {
            try {
                ival = Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return ival;
    }

    @Override
    public String getString(String name) {
        String value = this.properties.get(name);
        if (value == null) {
            if (this.parentStore.isDefault(name)) {
                value = this.defaultProperties.get(name);
            }
            if (value == null) {
                value = this.parentStore.getString(name);
            }
        }
        return value;
    }

    @Override
    public String getDefaultString(String name) {
        String value = this.defaultProperties.get(name);
        if (value == null) {
            if (this.parentStore.isDefault(name)) {
                return this.parentStore.getDefaultString(name);
            }
            return "";
        }
        return value;
    }

    @Override
    public boolean isDefault(String name) {
        return !this.properties.containsKey(name) && (this.defaultProperties.containsKey(name) || this.parentStore.isDefault(name));
    }

    public boolean isSet(String name) {
        return this.properties.containsKey(name);
    }

    @Override
    public boolean needsSaving() {
        return this.dirty;
    }

    public String[] preferenceNames() {
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    @Override
    public void setDefault(String name, double value) {
        this.defaultProperties.put(name, String.valueOf(value));
    }

    @Override
    public void setDefault(String name, float value) {
        this.defaultProperties.put(name, String.valueOf(value));
    }

    @Override
    public void setDefault(String name, int value) {
        this.defaultProperties.put(name, String.valueOf(value));
    }

    @Override
    public void setDefault(String name, long value) {
        this.defaultProperties.put(name, String.valueOf(value));
    }

    @Override
    public void setDefault(String name, String value) {
        this.defaultProperties.put(name, String.valueOf(value));
    }

    @Override
    public void setDefault(String name, boolean value) {
        this.defaultProperties.put(name, String.valueOf(value));
    }

    @Override
    public void setToDefault(String name) {
        String oldValue = this.properties.get(name);
        this.properties.remove(name);
        this.dirty = true;
        String newValue = null;
        if (this.defaultProperties != null) {
            newValue = this.defaultProperties.get(name);
        }
        this.firePropertyChangeEvent(name, oldValue, newValue);
    }

    @Override
    public void setValue(String name, double value) {
        double oldValue = this.getDouble(name);
        if (oldValue != value || !this.isSet(name)) {
            this.properties.put(name, String.valueOf(value));
            this.dirty = true;
            this.firePropertyChangeEvent(name, oldValue, value);
        }
    }

    @Override
    public void setValue(String name, float value) {
        float oldValue = this.getFloat(name);
        if (oldValue != value || !this.isSet(name)) {
            this.properties.put(name, String.valueOf(value));
            this.dirty = true;
            this.firePropertyChangeEvent(name, Float.valueOf(oldValue), Float.valueOf(value));
        }
    }

    @Override
    public void setValue(String name, int value) {
        int oldValue = this.getInt(name);
        if (oldValue != value || !this.isSet(name)) {
            this.properties.put(name, String.valueOf(value));
            this.dirty = true;
            this.firePropertyChangeEvent(name, oldValue, value);
        }
    }

    @Override
    public void setValue(String name, long value) {
        long oldValue = this.getLong(name);
        if (oldValue != value || !this.isSet(name)) {
            this.properties.put(name, String.valueOf(value));
            this.dirty = true;
            this.firePropertyChangeEvent(name, oldValue, value);
        }
    }

    @Override
    public void setValue(String name, String value) {
        String oldValue = this.getString(name);
        if (oldValue == null || !oldValue.equals(value) || !this.isSet(name)) {
            this.properties.put(name, value);
            this.dirty = true;
            this.firePropertyChangeEvent(name, oldValue, value);
        }
    }

    @Override
    public void setValue(String name, boolean value) {
        boolean oldValue = this.getBoolean(name);
        if (oldValue != value || !this.isSet(name)) {
            this.properties.put(name, String.valueOf(value));
            this.dirty = true;
            this.firePropertyChangeEvent(name, oldValue ? Boolean.TRUE : Boolean.FALSE, value ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SimplePreferenceStore)) {
            return false;
        }
        SimplePreferenceStore copy = (SimplePreferenceStore)obj;
        return CommonUtils.equalObjects((Object)this.parentStore, (Object)copy.parentStore) && CommonUtils.equalObjects(this.properties, copy.properties) && CommonUtils.equalObjects(this.defaultProperties, copy.defaultProperties);
    }
}

