/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.util.cache;

public class DListElement {
    private DListElement previousLink;
    private DListElement nextLink;
    private Object data;

    public DListElement(Object data) {
        this.data = data;
    }

    public Object getObject() {
        return this.data;
    }

    public DListElement next() {
        return this.nextLink;
    }

    public DListElement previous() {
        return this.previousLink;
    }

    public boolean atStart() {
        return this.previousLink == null;
    }

    public boolean atEnd() {
        return this.nextLink == null;
    }

    public void remove() {
        if (this.previousLink != null) {
            this.previousLink.nextLink = this.nextLink;
        }
        if (this.nextLink != null) {
            this.nextLink.previousLink = this.previousLink;
        }
        this.previousLink = null;
        this.nextLink = null;
    }

    public void prepend(DListElement newHead) {
        newHead.nextLink = this;
        this.previousLink = newHead;
    }

    public void append(DListElement newTail) {
        this.nextLink = newTail;
        newTail.previousLink = this;
    }

    public void insertAfter(DListElement newHead) {
        DListElement newTail = newHead.nextLink;
        newHead.nextLink = this;
        this.previousLink = newHead;
        this.nextLink = newTail;
        if (newTail != null) {
            newTail.previousLink = this;
        }
    }
}

