/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.powertoys;

import com.sap.dbtech.jdbc.DriverSapDB;
import com.sap.dbtech.jdbc.trace.TraceControl;
import com.sap.dbtech.powertoys.LoaderException;
import com.sap.dbtech.rte.comm.JdbcCommFactory;
import com.sap.dbtech.rte.comm.JdbcCommunication;
import com.sap.dbtech.rte.comm.NativeComm;
import com.sap.dbtech.rte.comm.PipedCommunication;
import com.sap.dbtech.rte.comm.RTEException;
import com.sap.dbtech.rte.comm.SocketComm;
import com.sap.dbtech.util.StructuredMem;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.Properties;

public class Loader {
    public static final String hostKeyC = "host";
    private static final String hostDefaultC = "";
    public static final String dbnameKeyC = "dbname";
    private static final String dbnameDefaultC = "";
    public static final String dbrootKeyC = "dbroot";
    private static final String dbrootDefaultC = "";
    public static final String userKeyC = "user";
    private static final String pgmNameC = "lserver";
    public static final String transportC = "transport";
    private static final int alignSizeC = 8;
    static final int indicatorLengthC = 4;
    private int communicationEncoding = 2;
    private JdbcCommunication connection;
    private boolean inCommunication;
    private TraceControl m_trcCtl;

    public Loader(Properties properties) throws RTEException {
        String host = properties.getProperty(hostKeyC, "");
        String dbname = properties.getProperty(dbnameKeyC, "");
        String dbroot = properties.getProperty(dbrootKeyC, "");
        String transport = properties.getProperty(transportC, "");
        this.m_trcCtl = DriverSapDB.openTrace(properties);
        JdbcCommFactory factory = null;
        try {
            try {
                factory = transport.equalsIgnoreCase("PIPED") ? PipedCommunication.factory : (DriverSapDB.loadNativeCommunication() == 2 ? NativeComm.factory : SocketComm.factory);
                this.m_trcCtl.tracer.print("new Loader Connection ", properties);
                this.connection = factory.xopen(host, dbname, dbroot, pgmNameC, properties, this.m_trcCtl.tracer);
            }
            catch (Error linkErr) {
                factory = SocketComm.factory;
                this.connection = factory.xopen(host, dbname, dbroot, pgmNameC, properties, this.m_trcCtl.tracer);
            }
        }
        catch (RTEException rteExc) {
            this.m_trcCtl.tracer.println("using " + factory);
            this.m_trcCtl.tracer.println("=> FAILED");
            throw rteExc;
        }
        this.m_trcCtl.tracer.println("using " + this.connection);
        this.m_trcCtl.tracer.println("=> " + this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws RTEException {
        this.m_trcCtl.tracer.println(this + "->release ()");
        if (this.connection != null) {
            try {
                try {
                    this.cmd("release");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.connection.release();
            }
            finally {
                this.connection = null;
            }
        }
    }

    public void finalize() throws RTEException {
        this.release();
    }

    public String cmd(String cmdString) throws RTEException, LoaderException {
        this.m_trcCtl.tracer.println(this + "->cmd (" + cmdString + ")");
        try {
            int alignedLen;
            StructuredMem request = this.connection.getRequestPacket();
            if (cmdString.length() == 0) {
                request.putBytes(new byte[]{0}, 0);
                alignedLen = 8;
            } else {
                byte[] byteArr = null;
                try {
                    byteArr = cmdString.getBytes(this.communicationEncoding == 0 ? "ISO8859_1" : "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new LoaderException(-25801, "Internal error [this version of java doesn't support encoding " + this.communicationEncoding + "]. Contact support.");
                }
                alignedLen = (byteArr.length + 8 - 1) / 8 * 8;
                request.putBytes(byteArr, 0);
            }
            this.connection.request(request, alignedLen);
            this.inCommunication = true;
            StructuredMem reply = this.connection.receive();
            this.inCommunication = false;
            String errorIndicator = reply.getString(0, Math.min(4, reply.size()));
            if (!errorIndicator.startsWith("OK")) {
                throw LoaderException.create(reply);
            }
            int dataStart = errorIndicator.indexOf(10) + 1;
            String result = reply.getString(dataStart, reply.size() - dataStart, this.communicationEncoding);
            this.m_trcCtl.tracer.println("=> " + result);
            String string = result;
            return string;
        }
        catch (LoaderException e) {
            this.m_trcCtl.tracer.println(" <-!");
            this.m_trcCtl.tracer.traceException(e);
            throw e;
        }
        catch (RTEException err) {
            this.m_trcCtl.tracer.println(" <-!");
            this.m_trcCtl.tracer.traceException(err);
            throw err;
        }
        finally {
            this.inCommunication = false;
        }
    }

    public void cancel() throws SQLException {
        if (this.inCommunication) {
            this.connection.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        if (this.connection != null) {
            try {
                this.connection.release();
            }
            finally {
                this.connection = null;
            }
        }
    }

    public static Loader dbLoader(String host, String dbname) throws RTEException {
        Properties props = new Properties();
        if (host != null) {
            props.put(hostKeyC, host);
        }
        if (dbname != null) {
            props.put(dbnameKeyC, dbname);
        }
        return new Loader(props);
    }

    public static Loader dbrootLoader(String host, String dbroot) throws RTEException {
        Properties props = new Properties();
        if (host != null) {
            props.put(hostKeyC, host);
        }
        props.put(dbrootKeyC, dbroot);
        return new Loader(props);
    }
}

