/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.CharDataTranslator;
import com.sap.dbtech.jdbc.translators.DBTechTranslator;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public class TimestampTranslator
extends CharDataTranslator {
    public static final long day0 = new Time(0, 0, 0).getTime();
    public static final long day1 = new Time(23, 59, 59).getTime();
    public static final String zeroPadC = "0000";
    private static final int TimestampSize_C = 26;

    TimestampTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out, boolean readOnly, boolean autoIncr) {
        super(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, readOnly, autoIncr);
    }

    protected TimestampTranslator(int mode, int ioType, int dataType, int len, int ioLen, int bufpos_in, int bufpos_out) {
        this(mode, ioType, dataType, len, ioLen, bufpos_in, bufpos_out, false, false);
    }

    public Object getObject(SQLParamController controller, DataPart mem) throws SQLException {
        return this.getTimestamp(controller, mem, null);
    }

    public java.sql.Date getDate(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        Timestamp timestamp = this.getTimestamp(controller, mem, cal);
        java.sql.Date result = null;
        if (timestamp != null) {
            result = new java.sql.Date(timestamp.getTime());
        }
        return result;
    }

    public Time getTime(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        Timestamp timestamp = this.getTimestamp(controller, mem, cal);
        Time result = null;
        if (timestamp != null) {
            result = new Time(timestamp.getTime());
        }
        return result;
    }

    public String getString(SQLParamController controller, DataPart mem) throws SQLException {
        String result = null;
        if (!this.isNull(controller, mem)) {
            result = mem.getString(this.bufpos_output, this.physicalLength - 1);
        }
        return result;
    }

    protected int parseYear(byte[] raw) {
        int year = (raw[0] - 48) * 1000;
        year += (raw[1] - 48) * 100;
        year += (raw[2] - 48) * 10;
        return year += raw[3] - 48;
    }

    protected int parseMonth(byte[] raw) {
        int month = (raw[5] - 48) * 10;
        return month += raw[6] - 48;
    }

    protected int parseDay(byte[] raw) {
        int day = (raw[8] - 48) * 10;
        return day += raw[9] - 48;
    }

    protected int parseHours(byte[] raw) {
        int hour = (raw[11] - 48) * 10;
        return hour += raw[12] - 48;
    }

    protected int parseMinutes(byte[] raw) {
        int min = (raw[14] - 48) * 10;
        return min += raw[15] - 48;
    }

    protected int parseSeconds(byte[] raw) {
        int sec = (raw[17] - 48) * 10;
        return sec += raw[18] - 48;
    }

    protected int parseNanoseconds(byte[] raw) {
        int milli = (raw[20] - 48) * 100;
        milli += (raw[21] - 48) * 10;
        int nano = ((milli += raw[22] - 48) * 10 + (raw[23] - 48)) * 100;
        nano += (raw[24] - 48) * 10;
        nano += raw[25] - 48;
        return nano *= 1000;
    }

    public Timestamp getTimestamp(SQLParamController controller, DataPart mem, Calendar cal) throws SQLException {
        Timestamp result = null;
        if (!this.isNull(controller, mem)) {
            byte[] raw = mem.getBytes(this.bufpos_output, this.physicalLength - 1);
            int year = this.parseYear(raw);
            int month = this.parseMonth(raw);
            int day = this.parseDay(raw);
            int hour = this.parseHours(raw);
            int min = this.parseMinutes(raw);
            int sec = this.parseSeconds(raw);
            int nano = this.parseNanoseconds(raw);
            if (cal == null) {
                result = new Timestamp(year - 1900, month - 1, day, hour, min, sec, nano);
            } else {
                cal.clear();
                cal.set(year, month - 1, day, hour, min, sec);
                result = DBTechTranslator.CalendarUtil.getTimestampFromCalendar(cal, nano);
            }
        }
        return result;
    }

    public boolean isCaseSensitive() {
        return false;
    }

    public Object transStringForInput(String val) throws SQLException {
        if (val == null) {
            return null;
        }
        try {
            return this.transTimestampForInput(Timestamp.valueOf(val), Calendar.getInstance());
        }
        catch (IllegalArgumentException exc) {
            try {
                java.sql.Date d = java.sql.Date.valueOf(val);
                return this.transTimestampForInput(new Timestamp(d.getTime()), Calendar.getInstance());
            }
            catch (IllegalArgumentException exc2) {
                try {
                    Time t = Time.valueOf(val);
                    return this.transTimestampForInput(new Timestamp(t.getTime()), Calendar.getInstance());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw this.newParseException(val, "Timestamp");
                }
            }
        }
    }

    public Object transSpecificForInput(Object obj) throws SQLException {
        Object result = null;
        if (obj instanceof Timestamp) {
            result = this.transTimestampForInput((Timestamp)obj, Calendar.getInstance());
        } else if (obj instanceof Time) {
            String timeString = ((Time)obj).toString();
            String dateString = new java.sql.Date(new Date().getTime()).toString();
            String fullString = dateString + " " + timeString + ".0";
            Timestamp ts = Timestamp.valueOf(fullString);
            result = this.transTimestampForInput(ts, Calendar.getInstance());
        } else if (obj instanceof java.sql.Date) {
            String dateString = ((java.sql.Date)obj).toString();
            String fullString = dateString + " 00:00:00.0";
            Timestamp ts = Timestamp.valueOf(fullString);
            result = this.transTimestampForInput(ts, Calendar.getInstance());
        } else if (obj instanceof Date) {
            Date utilDate = (Date)obj;
            result = this.transTimestampForInput(new Timestamp(utilDate.getTime()), Calendar.getInstance());
        } else if (obj instanceof String) {
            String utilString = (String)obj;
            result = this.transStringForInput(utilString);
        }
        return result;
    }

    public Object transTimestampForInput(Timestamp arg, Calendar cal) throws SQLException {
        if (arg == null) {
            return null;
        }
        cal.setTime(arg);
        int year = cal.get(1);
        if (year < 0 || year > 9999) {
            throw this.newParseException(arg.toString(), "Timestamp");
        }
        byte[] formattedTimestamp = this.formatTimestamp(year, cal.get(2) + 1, cal.get(5), cal.get(11), cal.get(12), cal.get(13), arg.getNanos());
        return formattedTimestamp;
    }

    protected byte[] formatTimestamp(int year, int month, int day, int hour, int minute, int second, int nano) {
        byte[] formattedTimestamp = new byte[26];
        formattedTimestamp[0] = (byte)(48 + year / 1000);
        formattedTimestamp[1] = (byte)(48 + (year %= 1000) / 100);
        formattedTimestamp[2] = (byte)(48 + (year %= 100) / 10);
        formattedTimestamp[3] = (byte)(48 + (year %= 10));
        formattedTimestamp[4] = 45;
        formattedTimestamp[5] = HighTime_C[month];
        formattedTimestamp[6] = LowTime_C[month];
        formattedTimestamp[7] = 45;
        formattedTimestamp[8] = HighTime_C[day];
        formattedTimestamp[9] = LowTime_C[day];
        formattedTimestamp[10] = 32;
        formattedTimestamp[11] = HighTime_C[hour];
        formattedTimestamp[12] = LowTime_C[hour];
        formattedTimestamp[13] = 58;
        formattedTimestamp[14] = (byte)(48 + minute / 10);
        formattedTimestamp[15] = (byte)(48 + minute % 10);
        formattedTimestamp[16] = 58;
        formattedTimestamp[17] = (byte)(48 + second / 10);
        formattedTimestamp[18] = (byte)(48 + second % 10);
        formattedTimestamp[19] = 46;
        int tmpVal = nano / 1000;
        formattedTimestamp[20] = (byte)(48 + tmpVal / 100000);
        formattedTimestamp[21] = (byte)(48 + (tmpVal %= 100000) / 10000);
        formattedTimestamp[22] = (byte)(48 + (tmpVal %= 10000) / 1000);
        formattedTimestamp[23] = (byte)(48 + (tmpVal %= 1000) / 100);
        formattedTimestamp[24] = (byte)(48 + (tmpVal %= 100) / 10);
        formattedTimestamp[25] = (byte)(48 + (tmpVal %= 10));
        return formattedTimestamp;
    }

    protected void putSpecific(DataPart dataPart, Object data) throws SQLException {
        byte[] bytes = (byte[])data;
        this.checkFieldLimits(bytes.length);
        dataPart.putDefineByte(32, this.bufpos_input - 1);
        dataPart.putStringBytes(bytes, this.bufpos_input, this.physicalLength - 1);
    }
}

