/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.ConnectionSapDB;
import com.sap.dbtech.jdbc.exceptions.StreamIOException;
import com.sap.dbtech.jdbc.translators.AbstractGetval;
import com.sap.dbtech.util.RawByteReader;
import com.sap.dbtech.util.StringUtil;
import com.sap.dbtech.util.StructuredMem;
import java.io.Reader;
import java.sql.SQLException;

class Getval
extends AbstractGetval {
    boolean isBinary = false;
    int asciiColumnAsUnicodeMultiplier = 1;

    public Getval(ConnectionSapDB connection, byte[] descriptor, StructuredMem dataPart, int dataKind, boolean isPacketEncodingUnicode) {
        super(connection, descriptor, dataPart, 1, isPacketEncodingUnicode);
        switch (dataKind) {
            case 8: 
            case 21: {
                this.isBinary = true;
                break;
            }
            case 6: 
            case 19: {
                if (!isPacketEncodingUnicode) break;
                this.asciiColumnAsUnicodeMultiplier = 2;
                break;
            }
            case 34: 
            case 35: {
                this.isUnicodeColumn = true;
            }
        }
    }

    public long length() throws SQLException {
        return this.lengthInBytes() * (long)this.asciiColumnAsUnicodeMultiplier / (long)this.itemSize;
    }

    public java.io.InputStream getAsciiStream() throws SQLException {
        return new InputStream();
    }

    public java.io.InputStream getBinaryStream() throws SQLException {
        return new InputStream();
    }

    public Reader getCharacterStream() throws SQLException {
        return new RawByteReader(this.getAsciiStream());
    }

    public byte[] transSearchPattern(String searchPattern) {
        byte[] pattern = StringUtil.bytes_iso8859_1(searchPattern);
        return pattern;
    }

    private class InputStream
    extends java.io.InputStream {
        String cachedString = null;

        private InputStream() {
        }

        public int read() throws StreamIOException {
            if (Getval.this.itemsInBuffer <= 0) {
                Getval.this.nextChunk();
            }
            if (Getval.this.atEnd) {
                return -1;
            }
            int result = Getval.this.streamBuffer.getUInt1(0);
            Getval.this.streamBuffer.moveBase(1);
            --Getval.this.itemsInBuffer;
            ++Getval.this.longPosition;
            return result;
        }

        public int read(byte[] b, int off, int len) throws StreamIOException {
            int bytesCopied = 0;
            while (len > 0 && !Getval.this.atEnd) {
                if (Getval.this.itemsInBuffer <= 0) {
                    Getval.this.nextChunk();
                }
                if (Getval.this.atEnd) continue;
                int chunkSize = Math.min(len, Getval.this.itemsInBuffer);
                byte[] chunk = Getval.this.streamBuffer.getBytes(0, chunkSize);
                System.arraycopy(chunk, 0, b, off, chunkSize);
                len -= chunkSize;
                off += chunkSize;
                Getval.this.itemsInBuffer -= chunkSize;
                Getval.this.streamBuffer.moveBase(chunkSize);
                bytesCopied += chunkSize;
            }
            if (bytesCopied == 0 && Getval.this.atEnd) {
                bytesCopied = -1;
            } else {
                Getval.this.longPosition += (long)bytesCopied;
            }
            return bytesCopied;
        }
    }
}

