/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;

public class ConnectionTestDialog
extends BaseDialog {
    private final String serverVersion;
    private final String clientVersion;
    private final long elapsedTime;

    public ConnectionTestDialog(Shell parentShell, String serverVersion, String clientVersion, long elapsedTime) {
        super(parentShell, "Connection Test", (DBPImage)DBIcon.TREE_DATABASE);
        this.serverVersion = serverVersion;
        this.clientVersion = clientVersion;
        this.elapsedTime = elapsedTime;
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 3;
        Label imageLabel = new Label(composite, 0);
        imageLabel.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.STATUS_INFO));
        Label messageLabel = new Label(composite, 0);
        messageLabel.setText(NLS.bind((String)ModelMessages.dialog_connection_wizard_start_connection_monitor_connected, (Object)this.elapsedTime));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        messageLabel.setLayoutData((Object)gd);
        UIUtils.createEmptyLabel((Composite)composite, (int)1, (int)1);
        UIUtils.createControlLabel((Composite)composite, (String)"Server").setLayoutData((Object)new GridData(2));
        GridData gd2 = new GridData(768);
        gd2.widthHint = 300;
        Text serverText = new Text(composite, 74);
        serverText.setText(this.serverVersion.trim());
        serverText.setLayoutData((Object)gd2);
        UIUtils.createEmptyLabel((Composite)composite, (int)1, (int)1);
        UIUtils.createControlLabel((Composite)composite, (String)"Driver").setLayoutData((Object)new GridData(2));
        Text driverText = new Text(composite, 74);
        driverText.setText(this.clientVersion.trim());
        GridData gd3 = new GridData(768);
        gd3.widthHint = 300;
        driverText.setLayoutData((Object)gd3);
        UIUtils.asyncExec(() -> {
            boolean bl = this.getButton(0).setFocus();
        });
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }
}

