/*
 * Decompiled with CFR 0.152.
 */
package com.yugabyte.driver.core;

import com.datastax.driver.core.Host;
import com.yugabyte.driver.core.PartitionMetadata;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableSplitMetadata {
    private static final Logger logger = LoggerFactory.getLogger(TableSplitMetadata.class);
    private final NavigableMap<Integer, PartitionMetadata> partitionMap = new TreeMap<Integer, PartitionMetadata>();

    public PartitionMetadata getPartitionMetadata(int key) {
        Map.Entry<Integer, PartitionMetadata> entry = this.partitionMap.floorEntry(key);
        if (entry == null) {
            return null;
        }
        PartitionMetadata partition = entry.getValue();
        logger.debug("key " + key + " -> partition = " + partition.toString());
        return partition;
    }

    public List<Host> getHosts(int key) {
        PartitionMetadata partitionMetadata = this.getPartitionMetadata(key);
        if (partitionMetadata == null) {
            return Collections.emptyList();
        }
        return partitionMetadata.getHosts();
    }

    public NavigableMap<Integer, PartitionMetadata> getPartitionMap() {
        return this.partitionMap;
    }
}

