/*
 * Decompiled with CFR 0.152.
 */
package com.exasol.jdbc.importExport;

import com.exasol.jdbc.ClusterNode;
import com.exasol.jdbc.DebugLog;
import com.exasol.jdbc.TextUtil;
import com.exasol.jdbc.Translator;
import com.exasol.jdbc.importExport.HTTPThread;
import com.exasol.jdbc.importExport.HttpPush;
import com.exasol.jdbc.importExport.MultiFileInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.Socket;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.UUID;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpPushTool {
    final String sql;
    final HttpPush hp;
    final String[] files;
    final String[] errFiles;
    final String cookie;
    final String errCookie;
    final DebugLog log;
    final PrintStream logPrinterOut;
    final PrintStream logPrinterErr;
    HTTPThread hpt = null;
    static final Pattern impexpPattern = Pattern.compile("^\\s*(IMPORT|EXPORT).*", 34);
    static final Pattern impPatternCsv = Pattern.compile("^\\s*IMPORT[\\s\\(]+.+(LOCAL\\s+CSV+(\\s+FILE\\s+'([^']+?)')+).*$", 34);
    static final Pattern impsPatternCsv = Pattern.compile("^\\s*IMPORT[\\s\\(]+.+(LOCAL\\s+SECURE\\s+CSV+(\\s+FILE\\s+'([^']+?)')+).*$", 34);
    static final Pattern impPatternErrCsv = Pattern.compile("^\\s*IMPORT[\\s\\(]+.+(LOCAL\\s+CSV+(\\s+FILE\\s+'([^']+?)')+)(.+)ERRORS\\s+INTO\\s+(LOCAL\\s+CSV+(\\s+FILE\\s+'([^']+?)')+).*$", 34);
    static final Pattern impsPatternErrCsv = Pattern.compile("^\\s*IMPORT[\\s\\(]+.+(LOCAL\\s+SECURE\\s+CSV+(\\s+FILE\\s+'([^']+?)')+)(.+)ERRORS\\s+INTO\\s+(LOCAL\\s+SECURE\\s+CSV+(\\s+FILE\\s+'([^']+?)')+).*$", 34);
    static final Pattern expPatternCsv = Pattern.compile("^\\s*EXPORT[\\s\\(]+.+(LOCAL\\s+CSV+(\\s+FILE\\s+'([^']+?)')+).*$", 34);
    static final Pattern expsPatternCsv = Pattern.compile("^\\s*EXPORT[\\s\\(]+.+(LOCAL\\s+SECURE\\s+CSV+(\\s+FILE\\s+'([^']+?)')+).*$", 34);
    static final Pattern impPatternFbv = Pattern.compile("^\\s*IMPORT[\\s\\(]+.+(LOCAL\\s+FBV+(\\s+FILE\\s+'([^']+?)')+).*$", 34);
    static final Pattern impsPatternFbv = Pattern.compile("^\\s*IMPORT[\\s\\(]+.+(LOCAL\\s+SECURE\\s+FBV+(\\s+FILE\\s+'([^']+?)')+).*$", 34);
    static final Pattern expPatternFbv = Pattern.compile("^\\s*EXPORT[\\s\\(]+.+(LOCAL\\s+FBV+(\\s+FILE\\s+'([^']+?)')+).*$", 34);
    static final Pattern expsPatternFbv = Pattern.compile("^\\s*EXPORT[\\s\\(]+.+(LOCAL\\s+SECURE\\s+FBV+(\\s+FILE\\s+'([^']+?)')+).*$", 34);

    public void KillHttpPushToolThread() {
        if (this.hpt != null) {
            try {
                this.hpt.InterruptThread();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public HttpPushTool(HttpPush httpPush, HttpPush httpPush2, String string, String[] stringArray, String[] stringArray2, String string2, String string3, DebugLog debugLog, PrintStream printStream, PrintStream printStream2) {
        this.sql = string;
        this.hp = httpPush;
        this.files = stringArray;
        this.errFiles = stringArray2;
        this.cookie = string2;
        this.errCookie = string3;
        this.log = debugLog;
        this.logPrinterOut = printStream;
        this.logPrinterErr = printStream2;
        this.hpt = new HTTPThread(httpPush, stringArray, string2, debugLog, printStream, printStream2);
        this.hpt.start();
        if (null != httpPush2) {
            this.hpt = new HTTPThread(httpPush2, stringArray2, string3, debugLog, printStream, printStream2);
            this.hpt.start();
        }
    }

    public void logOut(String string) {
        if (this.log != null) {
            this.log.log(string);
        }
        if (this.logPrinterOut != null) {
            this.logPrinterOut.println(string);
        }
    }

    public void logErr(String string) {
        if (this.log != null) {
            this.log.log(string);
        }
        if (this.logPrinterErr != null) {
            this.logPrinterErr.println(string);
        }
    }

    public void logErr(Throwable throwable) {
        if (this.log != null) {
            this.log.log(throwable);
        }
        if (this.logPrinterErr != null) {
            throwable.printStackTrace(this.logPrinterErr);
        }
    }

    public static HttpPushTool transformCommand(String string, Vector vector) throws IOException, SQLException {
        return HttpPushTool.transformCommand(string, vector, false, null, null, null);
    }

    public static HttpPushTool transformCommand(String string, Vector vector, boolean bl) throws IOException, SQLException {
        return HttpPushTool.transformCommand(string, vector, bl, null, null, null);
    }

    public static HttpPushTool transformCommand(String string, Vector vector, boolean bl, DebugLog debugLog, PrintStream printStream, PrintStream printStream2) throws IOException, SQLException {
        Object object;
        int n;
        String string2 = "";
        String string3 = "";
        String[] stringArray = null;
        String[] stringArray2 = null;
        boolean bl2 = false;
        boolean bl3 = true;
        int n2 = 0;
        int n3 = 0;
        Matcher matcher = impexpPattern.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        String string4 = TextUtil.removeAllSQLComments(string);
        Matcher matcher2 = impPatternCsv.matcher(string4);
        Matcher matcher3 = impsPatternCsv.matcher(string4);
        Matcher matcher4 = impPatternErrCsv.matcher(string4);
        Matcher matcher5 = impsPatternErrCsv.matcher(string4);
        Matcher matcher6 = expPatternCsv.matcher(string4);
        Matcher matcher7 = expsPatternCsv.matcher(string4);
        Matcher matcher8 = impPatternFbv.matcher(string4);
        Matcher matcher9 = impsPatternFbv.matcher(string4);
        Matcher matcher10 = expPatternFbv.matcher(string4);
        Matcher matcher11 = expsPatternFbv.matcher(string4);
        int n4 = 0;
        String string5 = " ";
        if (matcher5.matches()) {
            n3 = matcher5.end(1);
            n2 = n3 - matcher5.group(1).length();
            n4 = matcher5.end(5);
            stringArray = HttpPushTool.GetFilesFromMatcher(matcher5.group(1));
            string5 = matcher5.group(4);
            stringArray2 = HttpPushTool.GetFilesFromMatcher(matcher5.group(5));
            bl2 = true;
            bl3 = true;
        } else if (matcher4.matches()) {
            n3 = matcher4.end(1);
            n2 = n3 - matcher4.group(1).length();
            n4 = matcher4.end(5);
            stringArray = HttpPushTool.GetFilesFromMatcher(matcher4.group(1));
            string5 = matcher4.group(4);
            stringArray2 = HttpPushTool.GetFilesFromMatcher(matcher4.group(5));
            bl2 = false;
            bl3 = true;
        } else if (matcher3.matches()) {
            n3 = matcher3.end(1);
            n2 = n3 - matcher3.group(1).length();
            stringArray = HttpPushTool.GetFilesFromMatcher(matcher3.group(1));
            bl2 = true;
            bl3 = true;
        } else if (matcher2.matches()) {
            n3 = matcher2.end(1);
            n2 = n3 - matcher2.group(1).length();
            stringArray = HttpPushTool.GetFilesFromMatcher(matcher2.group(1));
            bl2 = false;
            bl3 = true;
        } else if (matcher9.matches()) {
            n3 = matcher9.end(1);
            n2 = n3 - matcher9.group(1).length();
            stringArray = HttpPushTool.GetFilesFromMatcher(matcher9.group(1));
            bl2 = true;
            bl3 = false;
        } else if (matcher8.matches()) {
            n3 = matcher8.end(1);
            n2 = n3 - matcher8.group(1).length();
            stringArray = HttpPushTool.GetFilesFromMatcher(matcher8.group(1));
            bl2 = false;
            bl3 = false;
        } else if (matcher6.matches()) {
            n3 = matcher6.end(1);
            n2 = n3 - matcher6.group(1).length();
            stringArray = HttpPushTool.GetFilesFromMatcher(matcher6.group(1));
            HttpPushTool.DummyFiles(stringArray);
            bl2 = false;
            bl3 = true;
        } else if (matcher7.matches()) {
            n3 = matcher7.end(1);
            n2 = n3 - matcher7.group(1).length();
            stringArray = HttpPushTool.GetFilesFromMatcher(matcher7.group(1));
            HttpPushTool.DummyFiles(stringArray);
            bl2 = true;
            bl3 = true;
        } else if (matcher11.matches()) {
            n3 = matcher11.end(1);
            n2 = n3 - matcher11.group(1).length();
            stringArray = HttpPushTool.GetFilesFromMatcher(matcher11.group(1));
            if (stringArray.length > 1) {
                throw new SQLException("Only one secure FBV file can be specified in export.", "04505");
            }
            bl2 = true;
            bl3 = false;
        } else if (matcher10.matches()) {
            n3 = matcher10.end(1);
            n2 = n3 - matcher10.group(1).length();
            stringArray = HttpPushTool.GetFilesFromMatcher(matcher10.group(1));
            if (stringArray.length > 1) {
                throw new SQLException("Only one FBV file can be specified in export.", "04503");
            }
            bl2 = false;
            bl3 = false;
        } else {
            return null;
        }
        if (bl) {
            bl2 = true;
        }
        if (null == vector) {
            throw new SQLException("Cannot connect, no hosts known.", "04506");
        }
        String string6 = UUID.randomUUID().toString();
        String string7 = null;
        if (stringArray2 != null) {
            string7 = UUID.randomUUID().toString();
        }
        if (stringArray[0].toLowerCase().endsWith(".gz")) {
            string6 = string6 + ".gz";
        } else if (stringArray[0].toLowerCase().endsWith(".bz2")) {
            string6 = string6 + ".bz2";
        } else if (stringArray[0].toLowerCase().endsWith(".zip")) {
            string6 = string6 + "." + stringArray[0];
        }
        if (debugLog != null) {
            debugLog.log(Translator.UseCookie(string6));
            if (string7 != null) {
                debugLog.log(Translator.UseCookie("Error table cookie: " + string6));
            }
        }
        if (printStream != null) {
            printStream.println(Translator.UseCookie(string6));
            if (string7 != null) {
                printStream.println(Translator.UseCookie("Error table cookie: " + string6));
            }
        }
        if (debugLog != null) {
            for (n = 0; n < stringArray.length; ++n) {
                debugLog.log(Translator.File(stringArray[n]));
            }
            if (null != stringArray2) {
                for (n = 0; n < stringArray2.length; ++n) {
                    debugLog.log(Translator.File(stringArray2[n]));
                }
            }
        }
        if (printStream != null) {
            for (n = 0; n < stringArray.length; ++n) {
                printStream.println(Translator.File(stringArray[n]));
            }
            if (null != stringArray2) {
                for (n = 0; n < stringArray2.length; ++n) {
                    printStream.println(Translator.File(stringArray2[n]));
                }
            }
        }
        Socket socket = HttpPushTool.GetNewSocket(vector, debugLog, printStream2, string4);
        Socket socket2 = null;
        if (stringArray2 != null) {
            socket2 = HttpPushTool.GetNewSocket(vector, debugLog, printStream2, string4);
        }
        HttpPush httpPush = new HttpPush(socket, stringArray, string6, bl2, true);
        HttpPush httpPush2 = null;
        if (stringArray2 != null) {
            httpPush2 = new HttpPush(socket2, stringArray2, string7, bl2, true);
        }
        String string8 = httpPush.getRemoteHost();
        int n5 = httpPush.getRemotePort();
        String string9 = null;
        if (stringArray2 != null) {
            string9 = httpPush2.getRemoteHost();
        }
        int n6 = 0;
        if (stringArray2 != null) {
            n6 = httpPush2.getRemotePort();
        }
        String string10 = bl2 ? "https" : "http";
        string2 = string4.substring(0, n2);
        string3 = n3 >= string4.length() ? "" : string4.substring(n3, string4.length()).trim();
        if (stringArray2 != null) {
            object = "";
            if (stringArray.length > 1) {
                object = " MULTIPLE LOCAL FILES";
            }
            string3 = (string3 = string4.substring(n4, string4.length()).trim()).endsWith(";") ? string3.substring(0, string3.length() - 1) + (String)object + ";" : string3 + (String)object + ";";
            string4 = string2 + (bl3 ? "CSV" : "FBV") + " AT '" + string10 + "://" + string8 + ":" + String.valueOf(n5) + "' FILE '" + string6 + "'" + string5 + "errors into CSV AT '" + string10 + "://" + string9 + ":" + String.valueOf(n6) + "' FILE '" + string7 + "' " + string3;
        } else {
            object = "";
            if (stringArray.length > 1) {
                object = " MULTIPLE LOCAL FILES";
            }
            string3 = string3.endsWith(";") ? string3.substring(0, string3.length() - 1) + (String)object + ";" : string3 + (String)object + ";";
            string4 = string2 + (bl3 ? "CSV" : "FBV") + " AT '" + string10 + "://" + string8 + ":" + String.valueOf(n5) + "' FILE '" + string6 + "' " + string3;
        }
        object = new HttpPushTool(httpPush, httpPush2, string4, stringArray, stringArray2, string6, string7, debugLog, printStream, printStream2);
        return object;
    }

    private static void DummyFiles(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            File file = new File(stringArray[i]);
            if (file.exists() || file.isDirectory()) continue;
            try {
                file.createNewFile();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static Socket GetNewSocket(Vector vector, DebugLog debugLog, PrintStream printStream, String string) throws IOException {
        Socket socket = null;
        Vector vector2 = (Vector)vector.clone();
        Collections.shuffle(vector2);
        Enumeration enumeration = vector2.elements();
        while (socket == null && enumeration.hasMoreElements()) {
            ClusterNode clusterNode = (ClusterNode)enumeration.nextElement();
            try {
                socket = new Socket(clusterNode.GetHost(), clusterNode.GetPort());
            }
            catch (Exception exception) {
                socket = null;
            }
        }
        if (socket == null) {
            if (debugLog != null) {
                debugLog.log(Translator.Connect_failed());
            }
            if (printStream != null) {
                printStream.println(Translator.Connect_failed());
            }
            throw new IOException(Translator.Connect_for_SQL_failed(string));
        }
        return socket;
    }

    static String[] GetFilesFromMatcher(String string) {
        try {
            String[] stringArray = string.split("\\s'");
            for (int i = 1; i < stringArray.length; ++i) {
                stringArray[i].trim();
                stringArray[i] = i < stringArray.length - 1 ? stringArray[i].substring(0, stringArray[i].length() - 6) : stringArray[i].substring(0, stringArray[i].length() - 1);
            }
            String[] stringArray2 = stringArray;
            stringArray = new String[stringArray2.length - 1];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray2[i + 1];
            }
            return stringArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public void close() throws IOException {
        this.hp.close();
    }

    private Thread getPushThread() {
        return this.hpt;
    }

    public String getSQL() {
        return this.sql;
    }

    public void checkForErrors() throws IOException {
        this.hpt.checkForErrors();
    }

    public static class PullFile
    implements HttpPush.PullFileInterface {
        private FileOutputStream fout = null;
        private byte[] buffer = new byte[16384];

        public PullFile(String string, boolean bl) throws IOException {
            try {
                this.fout = new FileOutputStream(new File(string), bl);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new FileNotFoundException(fileNotFoundException.toString() + ": " + string);
            }
        }

        public void putBuffer(byte[] byArray, int n) throws IOException {
            this.fout.write(byArray, 0, n);
        }

        public void close() throws IOException {
            if (this.fout != null) {
                this.fout.close();
            }
        }
    }

    public static class PushFiles
    implements HttpPush.PushFileInterface {
        private MultiFileInputStream fin = null;
        private byte[] buffer = new byte[16384];
        private int buffer_full = 0;
        private boolean eof = false;

        public void close() throws IOException {
            if (null != this.fin) {
                this.fin.close();
            }
        }

        public PushFiles(String[] stringArray) throws IOException {
            this.fin = new MultiFileInputStream(stringArray);
        }

        public byte[] getBuffer() {
            return this.buffer;
        }

        public boolean hasMoreElements() throws IOException {
            this.buffer_full = this.fin.read(this.buffer);
            return this.buffer_full != -1;
        }

        public int nextElement() {
            return this.buffer_full;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            try {
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }
}

