/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.model;

import com.dbeaver.db.mongodb.data.MongoDocument;
import com.dbeaver.db.mongodb.exec.MongoResultSet;
import com.dbeaver.db.mongodb.exec.MongoSession;
import com.dbeaver.db.mongodb.exec.sql.MongoDeleteStatement;
import com.dbeaver.db.mongodb.exec.sql.MongoInsertStatement;
import com.dbeaver.db.mongodb.exec.sql.MongoSQLUtils;
import com.dbeaver.db.mongodb.exec.sql.MongoSelectStatement;
import com.dbeaver.db.mongodb.exec.sql.MongoUpdateStatement;
import com.dbeaver.db.mongodb.model.MGCollectionAttribute;
import com.dbeaver.db.mongodb.model.MGDataSource;
import com.dbeaver.db.mongodb.model.MGDataType;
import com.dbeaver.db.mongodb.model.MGDatabase;
import com.dbeaver.db.mongodb.model.MGIndex;
import com.dbeaver.ee.model.document.DBAbstractDocumentContainer;
import com.mongodb.CommandResult;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.MapReduceCommand;
import com.mongodb.MapReduceOutput;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoException;
import com.mongodb.client.MongoCollection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.bson.Document;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBFetchProgress;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPNamedObject2;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBPSystemObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataFormatter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.data.ExecuteBatchImpl;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.meta.IPropertyCacheValidator;
import org.jkiss.dbeaver.model.meta.LazyProperty;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyGroup;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSDocumentContainer;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.model.struct.cache.AbstractObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.model.struct.rdb.DBSTrigger;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class MGCollection
extends DBAbstractDocumentContainer<MGDataSource>
implements DBSTable,
DBSDataContainer,
DBSDataManipulator,
DBSDocumentContainer,
DBPSaveableObject,
DBPSystemObject,
DBPNamedObject2 {
    private static final Log log = Log.getLog(MGCollection.class);
    private static final boolean LOAD_ATTRIBUTES = false;
    private final MGDatabase database;
    private String collectionName;
    private final IndexCache indexCache = new IndexCache();
    private List<MGCollectionAttribute> metaAttributes;
    private final IdAttribute attrId;
    private final Stats stats = new Stats();
    private boolean persisted;

    public MGCollection(MGDatabase database, String collectionName, boolean persisted) {
        super((DBPDataSource)database.getDataSource());
        this.database = database;
        this.collectionName = collectionName;
        this.attrId = new IdAttribute(this);
        this.persisted = persisted;
    }

    @NotNull
    protected DBSEntityAttribute createDocumentAttribute() {
        return new DocumentAttribute(this);
    }

    @Property(viewable=true, order=3)
    public MGDatabase getDatabase() {
        return this.database;
    }

    @Deprecated
    @NotNull
    public DBCollection getCollection(MongoSession session) throws DBCException {
        return this.database.getDB(session).getCollection(this.collectionName);
    }

    @NotNull
    public MongoCollection<Document> getMongoCollection(MongoSession session) throws DBCException {
        return this.database.getDatabase(session).getCollection(this.collectionName);
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return this.collectionName;
    }

    public void setName(String newName) {
        this.collectionName = newName;
    }

    @Property(viewable=true, editable=true, order=100)
    public String getDescription() {
        return null;
    }

    public MGDatabase getParentObject() {
        return this.database;
    }

    @NotNull
    public DBSEntityType getEntityType() {
        return DBSEntityType.TABLE;
    }

    @NotNull
    public List<? extends MGCollectionAttribute> getAttributes(@NotNull DBRProgressMonitor monitor) throws DBCException {
        if (this.metaAttributes == null) {
            this.metaAttributes = new ArrayList<MGCollectionAttribute>();
        }
        if (this.metaAttributes != null) {
            return this.metaAttributes;
        }
        monitor.beginTask("Map collection '" + this.collectionName + "' field names", 2);
        try {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (MongoSession session = (MongoSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read attributes");){
                    MapReduceOutput result = this.getCollection(session).mapReduce("function() { for (var key in this) { var value = this[key];var type; if (value instanceof Array) type = 'array'; else if (value instanceof Date) type = 'date'; else type = typeof this[key]; emit(type + ':' + key, null); } }", "function(key, stuff) { return null; }", null, MapReduceCommand.OutputType.INLINE, null);
                    monitor.worked(1);
                    this.metaAttributes = new ArrayList<MGCollectionAttribute>();
                    this.metaAttributes.add(this.attrId);
                    for (DBObject field : result.results()) {
                        String fieldInfo = (String)field.get("_id");
                        int divPos = fieldInfo.indexOf(58);
                        String fieldType = fieldInfo.substring(0, divPos);
                        String fieldName = fieldInfo.substring(divPos + 1);
                        if (fieldName.equals("_id")) continue;
                        MGDataType type = ((MGDataSource)this.getDataSource()).getDataTypeByJS(fieldType);
                        MetaAttribute attr = new MetaAttribute(this, fieldName, type, this.metaAttributes.size());
                        this.metaAttributes.add(attr);
                    }
                    monitor.worked(1);
                    this.metaAttributes.sort(DBUtils.nameComparator());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                if (!(e instanceof MongoCommandException) || ((MongoCommandException)e).getErrorCode() != 8000) {
                    throw new DBCException("Can't read field names", (Throwable)e);
                }
                log.debug((Object)"MapReduce is restricted, no columns");
                this.metaAttributes = new ArrayList<MGCollectionAttribute>();
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return this.metaAttributes;
    }

    public DBSEntityAttribute getAttribute(@NotNull DBRProgressMonitor monitor, @NotNull String attributeName) throws DBCException {
        if (attributeName.equals("_id")) {
            return this.attrId;
        }
        return super.getAttribute(monitor, attributeName);
    }

    public boolean isView() {
        return false;
    }

    public Collection<? extends DBSTableIndex> getIndexes(DBRProgressMonitor monitor) throws DBException {
        return this.indexCache.getAllObjects(monitor, this);
    }

    @Nullable
    public List<? extends DBSTrigger> getTriggers(@NotNull DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return String.valueOf(DBUtils.getQuotedIdentifier((DBSObject)this.database)) + "." + DBUtils.getQuotedIdentifier((DBSObject)this);
    }

    public int getSupportedFeatures() {
        return 458757;
    }

    @NotNull
    public DBCStatistics readData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, @Nullable DBDDataFilter dataFilter, long firstRow, long maxRows, long flags, int fetchSize) throws DBCException {
        try {
            DBCStatistics statistics;
            block18: {
                MongoSession mongoSession = (MongoSession)session;
                statistics = new DBCStatistics();
                session.getProgressMonitor().subTask(ModelMessages.model_jdbc_fetch_table_data);
                Throwable throwable = null;
                Object var15_14 = null;
                try (MongoSelectStatement statement = new MongoSelectStatement(mongoSession, this, dataFilter);){
                    MongoResultSet resultSet;
                    statement.setStatementSource(source);
                    statement.setLimit(firstRow, maxRows);
                    statement.setResultsFetchSize(fetchSize);
                    statistics.setQueryText(statement.getQueryString());
                    statistics.addStatementsCount();
                    if (!statement.executeStatement() || (resultSet = statement.openResultSet()) == null) break block18;
                    try {
                        dataReceiver.fetchStart((DBCSession)mongoSession, (DBCResultSet)resultSet, firstRow, maxRows);
                        DBFetchProgress fetchProgress = new DBFetchProgress(session.getProgressMonitor());
                        while (resultSet.nextRow()) {
                            if (fetchProgress.isCanceled()) break;
                            dataReceiver.fetchRow((DBCSession)mongoSession, (DBCResultSet)resultSet);
                            fetchProgress.monitorRowFetch();
                        }
                        fetchProgress.dumpStatistics(statistics);
                    }
                    finally {
                        dataReceiver.fetchEnd((DBCSession)mongoSession, (DBCResultSet)resultSet);
                        resultSet.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            DBCStatistics dBCStatistics = statistics;
            return dBCStatistics;
        }
        catch (MongoException e) {
            throw new DBCException((Throwable)e, session.getExecutionContext());
        }
        finally {
            dataReceiver.close();
        }
    }

    public long countData(@NotNull DBCExecutionSource source, @NotNull DBCSession session, @Nullable DBDDataFilter dataFilter, long flags) throws DBCException {
        try {
            return this.getCollection((MongoSession)session).count(MongoSQLUtils.makeQueryFromFilter((MGDataSource)this.getDataSource(), dataFilter));
        }
        catch (MongoException e) {
            throw new DBCException((Throwable)e, session.getExecutionContext());
        }
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch insertData(@NotNull DBCSession session, @NotNull DBSAttributeBase[] attributes, @Nullable DBDDataReceiver keysReceiver, final @NotNull DBCExecutionSource source) throws DBCException {
        final MongoSession mongoSession = (MongoSession)session;
        return new ExecuteBatchImpl(attributes, null, true){

            @NotNull
            protected DBCStatement prepareStatement(@NotNull DBCSession session, DBDValueHandler[] handlers, Object[] attributeValues, Map<String, Object> options) throws DBCException {
                MongoInsertStatement statement = new MongoInsertStatement(mongoSession, MGCollection.this, this.attributes, attributeValues);
                statement.setStatementSource(source);
                return statement;
            }

            protected void bindStatement(@NotNull DBDValueHandler[] handlers, @NotNull DBCStatement statement, Object[] attributeValues) throws DBCException {
                ((MongoInsertStatement)statement).addRowValues(attributeValues);
            }
        };
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch updateData(@NotNull DBCSession session, final @NotNull DBSAttributeBase[] updateAttributes, final @NotNull DBSAttributeBase[] keyAttributes, @Nullable DBDDataReceiver keysReceiver, final @NotNull DBCExecutionSource source) throws DBCException {
        DBSAttributeBase[] attributes = (DBSAttributeBase[])ArrayUtils.concatArrays((Object[])updateAttributes, (Object[])keyAttributes);
        final MongoSession mongoSession = (MongoSession)session;
        return new ExecuteBatchImpl(attributes, keysReceiver, true){

            @NotNull
            protected DBCStatement prepareStatement(@NotNull DBCSession session, DBDValueHandler[] handlers, Object[] attributeValues, Map<String, Object> options) throws DBCException {
                MongoUpdateStatement statement = new MongoUpdateStatement(mongoSession, MGCollection.this, updateAttributes, keyAttributes, attributeValues);
                statement.setStatementSource(source);
                return statement;
            }

            protected void bindStatement(@NotNull DBDValueHandler[] handlers, @NotNull DBCStatement statement, Object[] attributeValues) throws DBCException {
                ((MongoUpdateStatement)statement).addRowValues(attributeValues);
            }
        };
    }

    @NotNull
    public DBSDataManipulator.ExecuteBatch deleteData(@NotNull DBCSession session, final @NotNull DBSAttributeBase[] keyAttributes, final @NotNull DBCExecutionSource source) throws DBCException {
        final MongoSession mongoSession = (MongoSession)session;
        return new ExecuteBatchImpl(keyAttributes, null, true){

            @NotNull
            protected DBCStatement prepareStatement(@NotNull DBCSession session, DBDValueHandler[] handlers, Object[] attributeValues, Map<String, Object> options) throws DBCException {
                MongoDeleteStatement statement = new MongoDeleteStatement(mongoSession, MGCollection.this, keyAttributes, attributeValues);
                statement.setStatementSource(source);
                return statement;
            }

            protected void bindStatement(@NotNull DBDValueHandler[] handlers, @NotNull DBCStatement statement, Object[] attributeValues) throws DBCException {
                ((MongoDeleteStatement)statement).setRowValues(attributeValues);
            }
        };
    }

    @NotNull
    public DBCStatistics truncateData(DBCSession session, DBCExecutionSource source) throws DBCException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (DBSDataManipulator.ExecuteBatch batch = this.deleteData(session, new DBSAttributeBase[0], source);){
            return batch.execute(session, Collections.emptyMap());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public String getAttributeName(DBSAttributeBase attribute) {
        return DBUtils.getObjectFullName((DBPNamedObject)attribute, (DBPEvaluationContext)DBPEvaluationContext.DML);
    }

    public String getAttributeValue(DBSAttributeBase attribute, Object value) {
        if (value instanceof Number || value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof Date) {
            String formattedTimestamp;
            try {
                DBDDataFormatter formatter = ((MGDataSource)this.getDataSource()).getContainer().getDataFormatterProfile().createFormatter("timestamp", (DBSTypedObject)attribute);
                formattedTimestamp = formatter.formatValue(value);
            }
            catch (Exception exception) {
                formattedTimestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(value);
            }
            return "{ts '" + formattedTimestamp + "'}";
        }
        if (value instanceof MongoDocument) {
            return String.valueOf(((MongoDocument)((Object)value)).getDocumentId());
        }
        return "'" + value + "'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PropertyGroup(category="Statistics")
    @LazyProperty(cacheValidator=StatsValidator.class)
    public Stats getStats(DBRProgressMonitor monitor) throws DBCException {
        Stats stats = this.stats;
        synchronized (stats) {
            if (!this.stats.loaded) {
                Throwable throwable = null;
                Object var4_5 = null;
                try (MongoSession session = (MongoSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read stats");){
                    CommandResult result = this.getCollection(session).getStats();
                    this.stats.count = CommonUtils.toLong((Object)result.get("count"));
                    this.stats.size = CommonUtils.toLong((Object)result.get("size"));
                    this.stats.avgObjSize = CommonUtils.toLong((Object)result.get("avgObjSize"));
                    this.stats.storageSize = CommonUtils.toLong((Object)result.get("storageSize"));
                    this.stats.numExtents = CommonUtils.toLong((Object)result.get("numExtents"));
                    this.stats.lastExtentSize = CommonUtils.toLong((Object)result.get("lastExtentSize"));
                    this.stats.paddingFactor = CommonUtils.toLong((Object)result.get("paddingFactor"));
                    this.stats.flags = CommonUtils.toLong((Object)result.get("flags"));
                    this.stats.totalIndexSize = CommonUtils.toLong((Object)result.get("totalIndexSize"));
                    this.stats.loaded = true;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            return this.stats;
        }
    }

    public boolean isSystem() {
        return this.collectionName.startsWith("system.");
    }

    public String toString() {
        return this.getName();
    }

    public static class DocumentAttribute
    extends MGCollectionAttribute
    implements DBPQualifiedObject {
        DocumentAttribute(MGCollection collection) {
            super(collection, "##document", 0);
        }

        public String getTypeName() {
            return "json";
        }

        public int getTypeID() {
            return 2;
        }

        public DBPDataKind getDataKind() {
            return DBPDataKind.DOCUMENT;
        }

        public boolean isRequired() {
            return false;
        }

        public boolean isAutoGenerated() {
            return false;
        }

        @NotNull
        public String getFullyQualifiedName(DBPEvaluationContext context) {
            if (context == DBPEvaluationContext.UI) {
                return "Document";
            }
            return "##document";
        }
    }

    public static class IdAttribute
    extends MGCollectionAttribute {
        IdAttribute(MGCollection collection) {
            super(collection, "_id", 0);
        }

        public String getTypeName() {
            return "ObjectId";
        }

        public int getTypeID() {
            return 1;
        }

        public DBPDataKind getDataKind() {
            return DBPDataKind.ROWID;
        }

        public boolean isRequired() {
            return true;
        }

        public boolean isAutoGenerated() {
            return true;
        }
    }

    class IndexCache
    extends AbstractObjectCache<MGCollection, MGIndex> {
        IndexCache() {
        }

        @NotNull
        public Collection<MGIndex> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable MGCollection collection) throws DBException {
            if (!this.isFullyCached()) {
                Throwable throwable = null;
                Object var4_5 = null;
                try (MongoSession session = (MongoSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)MGCollection.this, (String)"Read indexes");){
                    ArrayList<MGIndex> indexes = new ArrayList<MGIndex>();
                    for (DBObject indexInfo : MGCollection.this.getCollection(session).getIndexInfo()) {
                        MGIndex index = new MGIndex(monitor, collection, indexInfo);
                        indexes.add(index);
                    }
                    this.setCache(indexes);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            return this.getCachedObjects();
        }

        public MGIndex getObject(@NotNull DBRProgressMonitor monitor, @Nullable MGCollection casKeyspace, @NotNull String name) throws DBException {
            return (MGIndex)DBUtils.findObject(this.getAllObjects(monitor, casKeyspace), (String)name);
        }
    }

    public static class MetaAttribute
    extends MGCollectionAttribute {
        private final MGDataType type;

        MetaAttribute(MGCollection collection, String name, MGDataType type, int position) {
            super(collection, name, position);
            this.type = type;
        }

        @Property(viewable=true, editable=false, order=2)
        public String getTypeName() {
            return this.type.getName();
        }

        public int getTypeID() {
            return this.type.getTypeID();
        }

        public DBPDataKind getDataKind() {
            return this.type.getDataKind();
        }

        public boolean isRequired() {
            return false;
        }

        public boolean isAutoGenerated() {
            return false;
        }
    }

    public static class Stats {
        private boolean loaded;
        private Long count;
        private long size;
        private long avgObjSize;
        private long storageSize;
        private long numExtents;
        private long lastExtentSize;
        private long paddingFactor;
        private long flags;
        private long totalIndexSize;

        @Property(viewable=true, order=21, category="Statistics")
        public Long getCount() {
            return this.count;
        }

        @Property(viewable=true, order=22, category="Statistics")
        public long getSize() {
            return this.size;
        }

        @Property(viewable=false, order=23, category="Statistics")
        public long getAvgObjSize() {
            return this.avgObjSize;
        }

        @Property(viewable=false, order=24, category="Statistics")
        public long getStorageSize() {
            return this.storageSize;
        }

        @Property(viewable=false, order=25, category="Statistics")
        public long getNumExtents() {
            return this.numExtents;
        }

        @Property(viewable=false, order=26, category="Statistics")
        public long getLastExtentSize() {
            return this.lastExtentSize;
        }

        @Property(viewable=false, order=27, category="Statistics")
        public long getPaddingFactor() {
            return this.paddingFactor;
        }

        @Property(viewable=false, order=28, category="Statistics")
        public long getFlags() {
            return this.flags;
        }

        @Property(viewable=false, order=29, category="Statistics")
        public long getTotalIndexSize() {
            return this.totalIndexSize;
        }
    }

    public static class StatsValidator
    implements IPropertyCacheValidator<MGCollection> {
        public boolean isPropertyCached(MGCollection object, Object propertyId) {
            return object.stats.loaded;
        }
    }
}

