/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.exec.sql;

import com.dbeaver.db.mongodb.MongoUtils;
import com.dbeaver.db.mongodb.data.MongoDocument;
import com.dbeaver.db.mongodb.exec.MongoBaseStatement;
import com.dbeaver.db.mongodb.exec.MongoSession;
import com.dbeaver.db.mongodb.exec.sql.MongoSQLUtils;
import com.dbeaver.db.mongodb.model.MGCollection;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import java.util.ArrayList;
import java.util.List;
import org.bson.types.ObjectId;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.utils.CommonUtils;

public class MongoUpdateStatement
extends MongoBaseStatement {
    private DBSAttributeBase[] keyAttributes;
    private DBSAttributeBase[] valueAttributes;
    private final List<Object[]> rowValues = new ArrayList<Object[]>();

    public MongoUpdateStatement(MongoSession session, MGCollection mongoCollection, DBSAttributeBase[] updateAttributes, DBSAttributeBase[] keyAttributes, Object[] rowValues) {
        super(session, MongoUpdateStatement.makeQuery(mongoCollection, updateAttributes, keyAttributes, rowValues));
        this.collection = mongoCollection;
        this.keyAttributes = keyAttributes;
        this.valueAttributes = updateAttributes;
    }

    public void addRowValues(Object[] rowValues) {
        this.rowValues.add(rowValues);
    }

    @Override
    public void addToBatch() throws DBCException {
    }

    @Override
    public int[] executeStatementBatch() throws DBCException {
        this.executeStatement();
        return new int[this.rowValues.size()];
    }

    public boolean executeStatement() throws DBCException {
        this.beforeExecute();
        try {
            boolean docUpdate = this.valueAttributes.length == 1 && this.valueAttributes[0].getDataKind() == DBPDataKind.DOCUMENT;
            for (Object[] row : this.rowValues) {
                if (docUpdate) {
                    DBObject o = (DBObject)((MongoDocument)((Object)row[0])).getRawValue();
                    MongoSQLUtils.normalizeMongoValue(((MongoSession)this.getSession()).getDataSource(), o);
                    this.writeResult = this.collection.getCollection((MongoSession)this.getSession()).save(o, WriteConcern.MAJORITY);
                    if (this.writeResult.getN() == 0) {
                        throw new DBCException("Document wasn't updated: " + this.writeResult.toString());
                    }
                    if (this.writeResult.isUpdateOfExisting()) continue;
                    throw new DBCException("Document wasn't updated but new document was created instead (" + o.get("_id") + ") - unsupported ObjectId format");
                }
                BasicDBObject q = new BasicDBObject();
                int i = 0;
                while (i < this.keyAttributes.length) {
                    Object keyValue = row[this.valueAttributes.length + i];
                    if (keyValue instanceof MongoDocument) {
                        q.put("_id", ((MongoDocument)((Object)keyValue)).getDocumentId());
                    } else if (keyValue != null) {
                        if (!(keyValue instanceof ObjectId) && ObjectId.isValid((String)CommonUtils.toString((Object)keyValue))) {
                            keyValue = new ObjectId(keyValue.toString());
                        }
                        q.put("_id", keyValue);
                    } else {
                        throw new DBCException("Null document ID specified");
                    }
                    ++i;
                }
                BasicDBObject o = new BasicDBObject();
                int i2 = 0;
                while (i2 < this.valueAttributes.length) {
                    BasicDBObject setMap = (BasicDBObject)o.get("$set");
                    if (setMap == null) {
                        setMap = new BasicDBObject();
                        o.put("$set", (Object)setMap);
                    }
                    setMap.put((Object)this.collection.getAttributeName(this.valueAttributes[i2]), MongoUtils.unwrapMongoValue(this.valueAttributes[i2], row[i2]));
                    ++i2;
                }
                MongoSQLUtils.normalizeMongoValue(((MongoSession)this.getSession()).getDataSource(), (DBObject)o);
                this.writeResult = this.collection.getCollection((MongoSession)this.getSession()).update((DBObject)q, (DBObject)o, false, false);
                if (this.writeResult.getN() != 0) continue;
                throw new DBCException("Document wasn't updated: " + this.writeResult.toString());
            }
            return false;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            this.afterExecute();
            this.rowValues.clear();
        }
    }

    private static String makeQuery(MGCollection collection, DBSAttributeBase[] updateAttributes, DBSAttributeBase[] keyAttributes, Object[] rowValues) {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(collection.getFullyQualifiedName(DBPEvaluationContext.DML)).append("\nSET ");
        int i = 0;
        while (i < updateAttributes.length) {
            if (i > 0) {
                sql.append(",");
            }
            sql.append(collection.getAttributeName(updateAttributes[i])).append("=").append(collection.getAttributeValue(updateAttributes[i], rowValues[i]));
            ++i;
        }
        if (keyAttributes.length > 0) {
            sql.append("\nWHERE ");
            i = 0;
            while (i < keyAttributes.length) {
                if (i > 0) {
                    sql.append(" AND ");
                }
                sql.append(collection.getAttributeName(keyAttributes[i])).append("=").append(collection.getAttributeValue(keyAttributes[i], rowValues[keyAttributes.length + i]));
                ++i;
            }
        }
        return sql.toString();
    }
}

