/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.exec.sql;

import com.dbeaver.db.mongodb.exec.MongoBaseStatement;
import com.dbeaver.db.mongodb.exec.MongoSession;
import com.dbeaver.db.mongodb.exec.sql.MongoSQLUtils;
import com.dbeaver.db.mongodb.model.MGCollection;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCException;

public class MongoSelectStatement
extends MongoBaseStatement {
    @Nullable
    private final DBDDataFilter dataFilter;

    public MongoSelectStatement(@NotNull MongoSession mongoSession, @NotNull MGCollection collection, @Nullable DBDDataFilter dataFilter) {
        super(mongoSession, MongoSQLUtils.makeSQLQuery(collection, dataFilter));
        this.collection = collection;
        this.dataFilter = dataFilter;
    }

    public boolean executeStatement() throws DBCException {
        this.beforeExecute();
        try {
            DBObject ref = MongoSQLUtils.makeQueryFromFilter(((MongoSession)this.getSession()).getDataSource(), this.dataFilter);
            DBCursor dBCursor = this.result = ref == null ? this.collection.getCollection((MongoSession)this.getSession()).find() : this.collection.getCollection((MongoSession)this.getSession()).find(ref);
            if (this.dataFilter != null && this.dataFilter.hasOrdering()) {
                BasicDBObject order = new BasicDBObject();
                for (DBDAttributeConstraint constr : this.dataFilter.getOrderConstraints()) {
                    String name = MongoSQLUtils.unquote(constr.getFullAttributeName());
                    order.put(name, (Object)(constr.isOrderDescending() ? -1 : 1));
                }
                this.result.sort((DBObject)order);
            }
            return true;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            this.afterExecute();
        }
    }
}

