/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.mongodb.edit;

import com.dbeaver.db.mongodb.exec.MongoSession;
import com.dbeaver.db.mongodb.model.MGCollection;
import com.dbeaver.db.mongodb.model.MGDatabase;
import com.mongodb.MongoNamespace;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.CreateCollectionOptions;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.edit.DirectDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;

public class MongoCollectionManager
extends SQLObjectEditor<MGCollection, MGDatabase>
implements DBEObjectRenamer<MGCollection> {
    public long getMakerOptions(DBPDataSource dataSource) {
        return 1L;
    }

    @Nullable
    public DBSObjectCache<? extends DBSObject, MGCollection> getObjectsCache(MGCollection object) {
        return object.getDatabase().getCollectionCache();
    }

    protected MGCollection createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, Object container, Object copyFrom, Map<String, Object> options) {
        return new MGCollection((MGDatabase)container, "NewCollection", false);
    }

    protected void addObjectCreateActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, final SQLObjectEditor.ObjectCreateCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new DirectDatabasePersistAction("Create collection"){

            public void afterExecute(DBCSession session, Throwable error) throws DBCException {
                MGCollection collection = (MGCollection)command.getObject();
                CreateCollectionOptions colOptions = new CreateCollectionOptions();
                collection.getDatabase().getDatabase((MongoSession)session).createCollection(collection.getName(), colOptions);
            }
        });
    }

    protected void addObjectDeleteActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, final SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new DirectDatabasePersistAction("Drop collection " + ((MGCollection)command.getObject()).getFullyQualifiedName(DBPEvaluationContext.UI)){

            public void afterExecute(DBCSession session, Throwable error) throws DBCException {
                MGCollection collection = (MGCollection)command.getObject();
                collection.getCollection((MongoSession)session).drop();
            }
        });
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull MGCollection object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, options, newName);
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, final SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        actions.add((DBEPersistAction)new DirectDatabasePersistAction("Rename collection"){

            public void afterExecute(DBCSession session, Throwable error) throws DBCException {
                MGCollection collection = (MGCollection)command.getObject();
                MongoSession mongoSession = (MongoSession)session;
                MongoCollection mongoCollection = collection.getDatabase().getDatabase(mongoSession).getCollection(command.getOldName());
                mongoCollection.renameCollection(new MongoNamespace(collection.getDatabase().getName(), command.getNewName()));
            }
        });
    }
}

